package com.changda.gjjapp.zhfwpt.service.impl.tyfb;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import javax.xml.rpc.ParameterMode;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;

import com.alibaba.fastjson.JSON;
import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.db.entity.M_LANMU;
import com.changda.gjjapp.db.entity.M_TSXQ;
import com.changda.gjjapp.db.entity.M_XWINFO;
import com.changda.gjjapp.zhfwpt.dao.tyfb.TyfbInfoDao;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.HtjkDto;
import com.changda.gjjapp.zhfwpt.dto.tyfb.TyfbLoggingDto;
import com.changda.gjjapp.zhfwpt.dto.tyfb.UpdateNumDto;
import com.changda.gjjapp.zhfwpt.dto.tyfb.UpdateStatisticsDto;
import com.changda.gjjapp.zhfwpt.service.tyfb.TyfbxwInfoService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.sun.mail.util.BASE64DecoderStream;

import org.dom4j.DocumentHelper;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Clob;
import java.sql.SQLException;

import sun.misc.BASE64Encoder;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * 统一发布新闻信息
 * 
 * @author Administrator
 */
@org.springframework.stereotype.Service()
public class TyfbxwInfoImp extends XMLUtil implements TyfbxwInfoService {

	@Autowired
	private TyfbInfoDao tyfbDao;

	// 调用模板进行对文章的增删改
	public String editArticle(String xml) {
		String endpoint = "http://www.hg.gov.cn/jcms/services/WSSynchronize?wsdl"; // 信息获取接口
		String strXml = xml;
		String strLoginId = "32b46a245ebdd662ec91bf7d2c8b65fd16db5b92a1a3d3727db2563e1e0ef3391df4446457039f33cf1b519196c473f3250c53305291d78d9f0cd7883e387c55b750f53f3a7f3c664db8634fb362e130d9524b66d49813bf42f869ac21f36e216a8c3c696c897fb1aab44080a1486f469e7397a3c5b66b31ad9850795eb2b781"; // 登录名
		String strPwd = "09b60b11017a89bb2f8d798581ffff09db6f4ceb8ba531f5868d66e42de1c0581a1b3a8103e449902511cc12828c0a40ab61dea8d983c08580dc02a4eba87903019a559ab9c2b7ffbd31de8788477d31021ff67749ef052ed284a29598ad1eb3df1005ee04aa4d82b1c0cf5f61de2f4fa32c656f8fccea24643d177ceb9bd81a"; // 登陆密码
		String strKey = ""; // 空即可
		String hasZip = "";// 空即可
		String result = "";

		try {
			Service service = new Service();
			Call call = (Call) service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(endpoint));
			call.setOperationName("wsSynchronize");
			// 设置参数类型 节点id
			call.addParameter("strXml", XMLType.XSD_STRING, ParameterMode.IN);
			// 设置参数类型 登陆名
			call.addParameter("strLoginId", XMLType.XSD_STRING, ParameterMode.IN);
			// 设置参数类型 密码
			call.addParameter("strPwd", XMLType.XSD_STRING, ParameterMode.IN);
			// 设置参数类型 密钥
			call.addParameter("strKey", XMLType.XSD_STRING, ParameterMode.IN);
			// 保留参数，为空即可
			call.addParameter("hasZip", XMLType.XSD_STRING, ParameterMode.IN);
			call.setReturnType(XMLType.XSD_STRING);
			result = (String) call.invoke(new Object[] { strXml, strLoginId, strPwd, strKey, hasZip }); // 返回处理结果
			System.out.println("wsGetMultiInfos is END");
			System.out.println("result4 == " + result);
		} catch (Exception ex) {
			System.out.println("wsGetMultiInfos is ERROR");
			ex.printStackTrace();
		}
		return result;
	}

	// 栏目信息模板
	public String CateInfoMB(M_XWINFO mXwinfo, String state, String date) {
		String xml = "";
		xml += "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
		xml += "<dahan>";
		xml += "<version>1.0</version>";
		xml += "<copyright>dahan</copyright>";
		xml += "<article>";
		xml += "<vc_title fieldtype=\"1\" name=\"标题\"><![CDATA[" + mXwinfo.getVc_title() + "]]></vc_title>";
		xml += "<vc_sectitle fieldtype=\"1\" name=\"副标题\"><![CDATA[" + mXwinfo.getVc_sectitle() + "]]></vc_sectitle>";
		xml += "<vc_thdtitle fieldtype=\"1\" name=\"引题\"><![CDATA[" + mXwinfo.getVc_thdtitle() + "]]></vc_thdtitle>";
		xml += "<vc_linktitle fieldtype=\"1\" name=\"链接标题\"></vc_linktitle>";
		xml += "<vc_author fieldtype=\"1\" name=\"作者\"><![CDATA[" + mXwinfo.getVc_author() + "]]></vc_author>";
		xml += "<vc_source fieldtype=\"1\" name=\"来源\"><![CDATA[" + mXwinfo.getVc_source() + "]]></vc_source>";
		xml += "<vc_keyword fieldtype=\"1\" name=\"关键字\"><![CDATA[" + mXwinfo.getVc_keyword() + "]]></vc_keyword>";
		xml += "<vc_describe fieldtype=\"11\" name=\"摘要\"><![CDATA[" + mXwinfo.getVc_describe() + "]]></vc_describe>";
		xml += "<artcontent fieldtype=\"7\" name=\"文章内容\"><![CDATA[" + mXwinfo.getVc_content() + "]]></artcontent>";
		xml += "<c_deploytime fieldtype=\"3\" name=\"显示时间\">" + mXwinfo.getC_deploytime() + "</c_deploytime>";
		xml += "<c_createdate fieldtype=\"3\" name=\"创建时间\">" + date + "</c_createdate>";
		xml += "<vc_pic fieldtype=\"4\" name=\"图片\"><![CDATA[" + mXwinfo.getVc_pic() + "]]></vc_pic>";
		xml += "<appendimg id=\"vc_pic\" name=\"对应图片名\"></appendimg>";
		xml += "<vc_attach fieldtype=\"6\" id=\"vc_pic\" name=\"附件\"></vc_attach>";
		xml += "<appendfile id=\"vc_attach\" name=\"对应文件名\"></appendfile>";
		xml += "<columnid>" + mXwinfo.getI_cataid() + "</columnid>";
		xml += "<distinctive>" + mXwinfo.getI_id() + "</distinctive>";
		xml += "<state>" + state + "</state>";
		xml += "<identifier>vc_identifier</identifier>";
		xml += "</article>";
		xml += "</dahan>";
		return xml;
	}

	// 获取栏目信息
	@Override
	public void lanmuInfo() {
		String endpoint = "http://www.hg.gov.cn/jcms/services/WSReceive?wsdl"; // 信息获取接口
		int nCataId = 8384; // 栏目id
		int bRef = 0; // 是否取引用
		int iBase64 = 0; // 内容不加密
		int nStart = 1; // 信息起始
		int nEnd = 5; // 信息终止
		int bAsc = 1; // 排序
		String strStartCTime = "2018-12-13"; // 起始时间
		String strEndCTime = "2018-12-15"; // 终止时间
		String strLoginId = "32b46a245ebdd662ec91bf7d2c8b65fd16db5b92a1a3d3727db2563e1e0ef3391df4446457039f33cf1b519196c473f3250c53305291d78d9f0cd7883e387c55b750f53f3a7f3c664db8634fb362e130d9524b66d49813bf42f869ac21f36e216a8c3c696c897fb1aab44080a1486f469e7397a3c5b66b31ad9850795eb2b781"; // 登录名
		String strPwd = "09b60b11017a89bb2f8d798581ffff09db6f4ceb8ba531f5868d66e42de1c0581a1b3a8103e449902511cc12828c0a40ab61dea8d983c08580dc02a4eba87903019a559ab9c2b7ffbd31de8788477d31021ff67749ef052ed284a29598ad1eb3df1005ee04aa4d82b1c0cf5f61de2f4fa32c656f8fccea24643d177ceb9bd81a"; // 登陆密码
		String strKey = ""; // 空即可
		String result = "";

		try {
			Service service = new Service();
			Call call = (Call) service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(endpoint));
			call.setOperationName("wsGetMultiInfos");
			// 设置参数类型 节点id
			call.addParameter("nCataId", XMLType.SOAP_INT, ParameterMode.IN);
			call.addParameter("bRef", XMLType.SOAP_INT, ParameterMode.IN);
			call.addParameter("iBase64", XMLType.SOAP_INT, ParameterMode.IN);
			call.addParameter("nStart", XMLType.SOAP_INT, ParameterMode.IN);
			call.addParameter("nEnd", XMLType.SOAP_INT, ParameterMode.IN);
			call.addParameter("bAsc", XMLType.SOAP_INT, ParameterMode.IN);
			call.addParameter("strStartCTime", XMLType.SOAP_STRING, ParameterMode.IN);
			call.addParameter("strEndCTime", XMLType.SOAP_STRING, ParameterMode.IN);
			call.addParameter("strLoginId", XMLType.SOAP_STRING, ParameterMode.IN);
			call.addParameter("strPwd", XMLType.SOAP_STRING, ParameterMode.IN);
			call.addParameter("strKey", XMLType.SOAP_STRING, ParameterMode.IN);
			call.setReturnType(XMLType.SOAP_STRING);
			result = call.invoke(new Object[] { nCataId, bRef, iBase64, nStart, nEnd, bAsc, strStartCTime, strEndCTime,
					strLoginId, strPwd, strKey }).toString();
			System.out.println("wsGetMultiInfos is END");
//			System.out.println("result4 == " + result);
		} catch (Exception ex) {
			System.out.println("wsGetMultiInfos is ERROR");
			ex.printStackTrace();
		}

	}

	@Override
	public void getWZID() {
		String endpoint = "http://www.hg.gov.cn/jcms/services/WSReceive?wsdl"; // 信息获取接口
		String strWeblds = "14"; // 网站id
		String strLoginId = "32b46a245ebdd662ec91bf7d2c8b65fd16db5b92a1a3d3727db2563e1e0ef3391df4446457039f33cf1b519196c473f3250c53305291d78d9f0cd7883e387c55b750f53f3a7f3c664db8634fb362e130d9524b66d49813bf42f869ac21f36e216a8c3c696c897fb1aab44080a1486f469e7397a3c5b66b31ad9850795eb2b781"; // 登录名
		String strPwd = "09b60b11017a89bb2f8d798581ffff09db6f4ceb8ba531f5868d66e42de1c0581a1b3a8103e449902511cc12828c0a40ab61dea8d983c08580dc02a4eba87903019a559ab9c2b7ffbd31de8788477d31021ff67749ef052ed284a29598ad1eb3df1005ee04aa4d82b1c0cf5f61de2f4fa32c656f8fccea24643d177ceb9bd81a"; // 登陆密码
		String strKey = ""; // 空即可
		String result = "";

		try {
			Service service = new Service();
			Call call = (Call) service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(endpoint));
			call.setOperationName("wsGetColumn");

			call.addParameter("strWeblds", XMLType.SOAP_STRING, ParameterMode.IN);
			call.addParameter("strLoginId", XMLType.SOAP_STRING, ParameterMode.IN);
			call.addParameter("strPwd", XMLType.SOAP_STRING, ParameterMode.IN);
			call.addParameter("strKey", XMLType.SOAP_STRING, ParameterMode.IN);
			call.setReturnType(XMLType.SOAP_STRING);

			result = call.invoke(new Object[] { strWeblds, strLoginId, strPwd, strKey }).toString();

			System.out.println("wsGetColumn is END");
			System.out.println("result4 == " + result);

			Document doc = DocumentHelper.parseText(result);// 报文转成doc对象
			Element root = doc.getRootElement();// 获取根元素，准备递归解析这个XML树
			Map<String, Object> xml2Json = xml2Json(root);
			Object id = xml2Json.get("id");
			List<Map<String, Object>> listMap1 = (List<Map<String, Object>>) xml2Json.get("item");
			for (Map<String, Object> map : (List<Map<String, Object>>) listMap1) {
				String childId = (String) map.get("id");// 父级id
				String text = (String) map.get("text");
				// tyfbDao.insertFJLanMu(childId, text, "0");
				// System.out.println(childId+":"+text);
				Object items = map.get("item");// 子集集合
				// System.out.print("父级id:" + childId);
				// System.out.println("--子集："+items);
				if (items != null) {
					for (Map<String, Object> map1 : (List<Map<String, Object>>) items) {
						Object childId1 = map1.get("id");// 2子集id
						Object items1 = map1.get("item");// 2子集集合
						System.out.println("父级id:" + childId1 + "--" + items1);
					}
				}
			}
		} catch (Exception ex) {
			System.out.println("wsGetColumn is ERROR");
			ex.printStackTrace();
		}
	}

	// 树形列表的结构数据
	@Override
	public List<M_LANMU> lanmuJG() {
		List<Map<String, Object>> data = tyfbDao.lanmuJG();
		List<M_LANMU> list = new ArrayList<>();
		for (Map<String, Object> map : data) {
			M_LANMU m = new M_LANMU();
			m.setPrimaryid(map.get("PRIMARYID").toString());
			m.setLanmuid(map.get("LANMUID").toString());
			m.setLanmuname(map.get("LANMUNAME").toString());
			m.setParentid(map.get("PARENTID").toString());
			list.add(m);
		}
		return list;
	}

	// 插入文章内容
	public void insertInfo() {
		List<Map<String, Object>> data = tyfbDao.searchLanmu();
		for (Map<String, Object> map : data) {
			String lanmuid = map.get("LANMUID").toString();
			int num = getLanMuInfo(lanmuid);
			if (num == 1) {
				continue;
			} else if (num == 8) {
				break;
			}
		}
	}

	// 获取栏目下信息
	@Override
	public int getLanMuInfo(String lanmuid) {
		String endpoint = "http://www.hg.gov.cn/jcms/services/WSReceive?wsdl"; // 信息获取接口
		int lanmid = Integer.parseInt(lanmuid);
		// int lanmid = 8384;
		int num = 0;
		M_XWINFO mXwinfo = null;
		while (true) {
			int nCataId = lanmid; // 栏目id
			int bRef = 0; // 是否取引用
			int iBase64 = 0; // 内容不加密
			int nStart = 1 + num; // 信息起始
			int nEnd = 1 + num; // 信息终止
			int bAsc = 1; // 排序
			// String strStartCTime = "2018-12-13"; // 起始时间
			// String strEndCTime = "2018-12-15"; // 终止时间
			String strLoginId = "32b46a245ebdd662ec91bf7d2c8b65fd16db5b92a1a3d3727db2563e1e0ef3391df4446457039f33cf1b519196c473f3250c53305291d78d9f0cd7883e387c55b750f53f3a7f3c664db8634fb362e130d9524b66d49813bf42f869ac21f36e216a8c3c696c897fb1aab44080a1486f469e7397a3c5b66b31ad9850795eb2b781"; // 登录名
			String strPwd = "09b60b11017a89bb2f8d798581ffff09db6f4ceb8ba531f5868d66e42de1c0581a1b3a8103e449902511cc12828c0a40ab61dea8d983c08580dc02a4eba87903019a559ab9c2b7ffbd31de8788477d31021ff67749ef052ed284a29598ad1eb3df1005ee04aa4d82b1c0cf5f61de2f4fa32c656f8fccea24643d177ceb9bd81a"; // 登陆密码
			String strKey = ""; // 空即可
			String result = "";

			try {
				Service service = new Service();
				Call call = (Call) service.createCall();
				call.setTargetEndpointAddress(new java.net.URL(endpoint));
				call.setOperationName("wsGetMultiInfos");
				// 设置参数类型 节点id
				call.addParameter("nCataId", XMLType.SOAP_INT, ParameterMode.IN);
				call.addParameter("bRef", XMLType.SOAP_INT, ParameterMode.IN);
				call.addParameter("iBase64", XMLType.SOAP_INT, ParameterMode.IN);
				call.addParameter("nStart", XMLType.SOAP_INT, ParameterMode.IN);
				call.addParameter("nEnd", XMLType.SOAP_INT, ParameterMode.IN);
				call.addParameter("bAsc", XMLType.SOAP_INT, ParameterMode.IN);
				/*
				 * call.addParameter("strStartCTime", XMLType.SOAP_STRING,
				 * ParameterMode.IN); call.addParameter("strEndCTime",
				 * XMLType.SOAP_STRING, ParameterMode.IN);
				 */
				call.addParameter("strLoginId", XMLType.SOAP_STRING, ParameterMode.IN);
				call.addParameter("strPwd", XMLType.SOAP_STRING, ParameterMode.IN);
				call.addParameter("strKey", XMLType.SOAP_STRING, ParameterMode.IN);
				call.setReturnType(XMLType.SOAP_STRING);
				result = call
						.invoke(new Object[] { nCataId, bRef, iBase64, nStart, nEnd, bAsc, strLoginId, strPwd, strKey })
						.toString();
				// System.out.println("wsGetMultiInfos is END");
				// System.out.println(lanmid);
				// System.out.println("-----------------开始：" + nStart + "结束：" +
				// nEnd);
				// System.out.println("result4 == " + result);
				Document document = DocumentHelper.parseText(result);

				Element root = document.getRootElement();

				// 栏目id
				Element i_cataidElement = (Element) root.selectSingleNode("/main/article/field[@id='i_cataid']");
				if (i_cataidElement == null) {
					break;
				}
				String i_cataid = i_cataidElement.getText();

				// 栏目名称
				Element vc_catanameElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_cataname']");
				String vc_cataname = vc_catanameElement.getText();
				// 网站id
				Element i_webidElement = (Element) root.selectSingleNode("/main/article/field[@id='i_webid']");
				String i_webid = i_webidElement.getText();
				// 网站名称
				Element vc_webnameElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_webname']");
				String vc_webname = vc_webnameElement.getText();

				// 流水号
				Element i_idElement = (Element) root.selectSingleNode("/main/article/field[@id='i_id']");
				String i_id = i_idElement.getText();
				// if (i_id.equals("294697") ) {
				// // 图片
				// Element vc_picElement =
				// (Element)root.selectSingleNode("/main/article/field[@id='vc_pic']");
				// String vc_pic = vc_picElement.getText();
				//
				//
				// final Base64.Decoder decoder = Base64.getDecoder();
				// final Base64.Encoder encoder = Base64.getEncoder();
				// byte[] textByte = vc_pic.getBytes("UTF-8");
				// //解码
				// System.out.println(new String(decoder.decode(textByte),
				// "UTF-8"));
				// System.out.println("111");
				// break;
				// }

				// 标题
				Element vc_titleElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_title']");
				String vc_title = vc_titleElement.getText();

				// 副标题
				Element vc_sectitleElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_sectitle']");
				String vc_sectitle = vc_sectitleElement.getText();

				// 引题
				Element vc_thdtitleElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_thdtitle']");
				String vc_thdtitle = vc_thdtitleElement.getText();

				// 作者
				Element vc_authorElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_author']");
				String vc_author = vc_authorElement.getText();

				// 来源
				Element vc_sourceElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_source']");
				String vc_source = vc_sourceElement.getText();

				// 录入人ID
				Element vc_useridElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_userid']");
				String vc_userid = vc_useridElement.getText();

				// 录入人
				Element vc_editorElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_editor']");
				String vc_editor = vc_editorElement.getText();

				// 关键字
				Element vc_keywordElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_keyword']");
				String vc_keyword = vc_keywordElement.getText();

				// 摘要
				Element vc_describeElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_describe']");
				String vc_describe = vc_describeElement.getText();

				// 显示时间
				Element c_deploytimeElement = (Element) root
						.selectSingleNode("/main/article/field[@id='c_deploytime']");

				String c_deploytime = c_deploytimeElement.getText();

				// 创建时间
				Element c_createdateElement = (Element) root
						.selectSingleNode("/main/article/field[@id='c_createdate']");
				SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				String cjsj = c_createdateElement.getText();
				Date c_createdate = sdf2.parse(cjsj);

				// 动画
				// Element vc_flashElement =
				// (Element)root.selectSingleNode("/main/article/field[@id='vc_flash']");
				// String vc_flash = vc_flashElement.getText();

				// 附件
				// Element vc_attachElement =
				// (Element)root.selectSingleNode("/main/article/field[@id='vc_attach']");
				// String vc_attach = vc_attachElement.getText();

				// 视频
				// Element vc_mediaElement =
				// (Element)root.selectSingleNode("/main/article/field[@id='vc_media']");
				// String vc_media = vc_mediaElement.getText();

				// 信息内容
				Element vc_contentElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_content']");
				String vc_content_tmp = vc_contentElement.getText();

				// System.out.println("aaaa-------------------vc_content_tmp:"+vc_content_tmp);

				// 将中文空格替换成英文空格

				// String vc_content = vc_content_tmp.replace("  "," ");

				String vc_content = vc_content_tmp.replace(" ", " ");

				vc_content = vc_content.replace(" ", " ");

				// String vc_content = new String(vc_content_tmp.getBytes(
				// "UTF-8"));

				// vc_content_tmp.getBytes("UTF-8");

				mXwinfo = new M_XWINFO();
				// 栏目id
				mXwinfo.setI_cataid(i_cataid);
				// 栏目名称
				mXwinfo.setVc_cataname(vc_cataname);
				mXwinfo.setI_webid(i_webid);
				mXwinfo.setVc_webname(vc_webname);
				mXwinfo.setI_id(i_id);
				mXwinfo.setVc_title(vc_title);
				mXwinfo.setVc_sectitle(vc_sectitle);
				mXwinfo.setVc_thdtitle(vc_thdtitle);
				mXwinfo.setVc_author(vc_author);
				mXwinfo.setVc_source(vc_source);
				mXwinfo.setVc_userid(vc_userid);
				mXwinfo.setVc_editor(vc_editor);
				mXwinfo.setVc_keyword(vc_keyword);
				mXwinfo.setVc_describe(vc_describe);
				mXwinfo.setC_deploytime(c_deploytime);
				mXwinfo.setC_createdate(c_createdate);
				// mXwinfo.setVC_PIC(vc_pic);
				// mXwinfo.setVC_FLASH(vc_flash);
				// mXwinfo.setVC_ATTACH(vc_attach);
				// mXwinfo.setVC_MEDIA(vc_media);
				mXwinfo.setVc_content(vc_content);
				insertContent(mXwinfo);
				num++;

			} catch (Exception ex) {
				System.out.println("wsGetMultiInfos is ERROR");
				ex.printStackTrace();
			}

		}

		return 1;
	}

	public int insertContent(M_XWINFO m_xwinfo) {
		int num = tyfbDao.insertContent(m_xwinfo);

		return num;
	}

	// 插入文章内容
	public int insertLanMuContent(M_XWINFO m_xwinfo) {
		int num = 0;
		try {
			num = tyfbDao.insertLanMuContent(m_xwinfo);
		} catch (Exception e) {
			e.printStackTrace();
		}

		return num;
	}

	// 查询文章内容
	@Override
	public Map<String, Object> query(String lanmuid, String title, String issh2, String qssj, String zzsj, int page,
			int limit) {
		Map<String, Object> map = new HashMap<>();
		List<M_XWINFO> list = new ArrayList<>();
		Page<M_XWINFO> page2 = PageHelper.startPage(page, limit, true);
		List<Map<String, Object>> data = tyfbDao.query(lanmuid, title, issh2, qssj, zzsj);
		int count = (int) page2.getTotal();
		for (Map<String, Object> xwinfo : data) {
			M_XWINFO mXwinfo = new M_XWINFO();
			if (xwinfo.get("C_CREATEDATE") == null) {
				mXwinfo.setC_createdate(null);
			} else {
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				String cjsj = xwinfo.get("C_CREATEDATE").toString();
				Date c_creatwdate;
				try {
					c_creatwdate = sdf.parse(cjsj);
					mXwinfo.setC_createdate(c_creatwdate);
				} catch (ParseException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			if (xwinfo.get("YYFSSJ") == null) {
				mXwinfo.setYyfssj("");
			} else {
				mXwinfo.setYyfssj(xwinfo.get("YYFSSJ").toString());
			}
			if (xwinfo.get("ISYYFS") == null) {
				mXwinfo.setIsyyfs(0);
			} else {
				mXwinfo.setIsyyfs(Integer.parseInt(xwinfo.get("ISYYFS").toString()));
			}

			if (xwinfo.get("I_CATAID") == null) {
				mXwinfo.setI_cataid("");
			} else {
				mXwinfo.setI_cataid(xwinfo.get("I_CATAID").toString());
			}
			if (xwinfo.get("VC_CATANAME") == null) {
				mXwinfo.setVc_cataname("");
			} else {
				mXwinfo.setVc_cataname(xwinfo.get("VC_CATANAME").toString());
			}
			if (xwinfo.get("I_WEBID") == null) {
				mXwinfo.setI_webid("");
			} else {
				mXwinfo.setI_webid(xwinfo.get("I_WEBID").toString());
			}
			if (xwinfo.get("VC_WEBNAME") == null) {
				mXwinfo.setVc_webname("");
			} else {
				mXwinfo.setVc_webname(xwinfo.get("VC_WEBNAME").toString());
			}
			if (xwinfo.get("I_ID") == null) {
				mXwinfo.setI_id("");
			} else {
				mXwinfo.setI_id(xwinfo.get("I_ID").toString());
			}
			if (xwinfo.get("VC_TITLE") == null) {
				mXwinfo.setVc_title("");
			} else {
				mXwinfo.setVc_title(xwinfo.get("VC_TITLE").toString());
			}

			if (xwinfo.get("VC_SECTITLE") == null) {
				mXwinfo.setVc_sectitle("");
			} else {
				mXwinfo.setVc_sectitle(xwinfo.get("VC_SECTITLE").toString());
			}
			if (xwinfo.get("VC_THDTITLE") == null) {
				mXwinfo.setVc_thdtitle("");
			} else {
				mXwinfo.setVc_thdtitle(xwinfo.get("VC_THDTITLE").toString());
			}
			if (xwinfo.get("VC_AUTHOR") == null) {
				mXwinfo.setVc_author("");
			} else {
				mXwinfo.setVc_author(xwinfo.get("VC_AUTHOR").toString());
			}
			if (xwinfo.get("VC_SOURCE") == null) {
				mXwinfo.setVc_source("");
			} else {
				mXwinfo.setVc_source(xwinfo.get("VC_SOURCE").toString());
			}
			if (xwinfo.get("VC_USERID") == null) {
				mXwinfo.setVc_userid("");
			} else {
				mXwinfo.setVc_userid(xwinfo.get("VC_USERID").toString());
			}
			if (xwinfo.get("VC_EDITOR") == null) {
				mXwinfo.setVc_editor("");
			} else {
				mXwinfo.setVc_editor(xwinfo.get("VC_EDITOR").toString());
			}
			if (xwinfo.get("VC_KEYWORD") == null) {
				mXwinfo.setVc_keyword("");
			} else {
				mXwinfo.setVc_keyword(xwinfo.get("VC_KEYWORD").toString());
			}
			if (xwinfo.get("VC_DESCRIBE") == null) {
				mXwinfo.setVc_describe("");
			} else {
				mXwinfo.setVc_describe(xwinfo.get("VC_DESCRIBE").toString());
			}
			if (xwinfo.get("C_DEPLOYTIME") == null) {
				mXwinfo.setC_deploytime(null);
			} else {

				SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				String xssj = xwinfo.get("C_DEPLOYTIME").toString();
				Date c_deploytime;
				try {
					c_deploytime = sdf2.parse(xssj);
					mXwinfo.setC_createdate(c_deploytime);
				} catch (ParseException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			}

			if (xwinfo.get("VC_CONTENT") == null) {
				mXwinfo.setVc_content("");
			} else {
				try {
					String vc_content = ClobToString(xwinfo.get("VC_CONTENT"));
					mXwinfo.setVc_content(vc_content);
				} catch (SQLException | IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			}

			int iswz = Integer.parseInt(xwinfo.get("ISWZ").toString());
			mXwinfo.setIswz(iswz);

			int isapp = Integer.parseInt(xwinfo.get("ISAPP").toString());
			mXwinfo.setIsapp(isapp);

			int iswx = Integer.parseInt(xwinfo.get("ISWX").toString());
			mXwinfo.setIswx(iswx);

			int isznzd = Integer.parseInt(xwinfo.get("ISZNZD").toString());
			mXwinfo.setIsznzd(isznzd);

			int issh = Integer.parseInt(xwinfo.get("ISSH").toString());
			mXwinfo.setIssh(issh);

			list.add(mXwinfo);

		}

		map.put("total", count);
		map.put("data", list);
		return map;

	}

	// 编辑页面栏目下拉框
	@Override
	public List<M_LANMU> lanmuXiaLa(String lanmuid) {
		List<Map<String, Object>> data = tyfbDao.lanmuXiaLa(lanmuid);
		List<M_LANMU> list = new ArrayList<>();
		for (Map<String, Object> map : data) {
			M_LANMU m = new M_LANMU();
			m.setPrimaryid(map.get("PRIMARYID").toString());
			m.setLanmuid(map.get("LANMUID").toString());
			m.setLanmuname(map.get("LANMUNAME").toString());
			m.setParentid(map.get("PARENTID").toString());
			list.add(m);
		}
		return list;
	}

	public String ClobToString(Object object) throws SQLException, IOException {
		String reString = "";
		Reader is = ((Clob) object).getCharacterStream();// 得到流
		BufferedReader br = new BufferedReader(is);
		String s = br.readLine();
		StringBuffer sb = new StringBuffer();
		while (s != null) {// 执行循环将字符串全部取出付值给StringBuffer由StringBuffer转成STRING
			sb.append(s);
			s = br.readLine();
		}
		reString = sb.toString();
		return reString;
	}

	public static String encodeImageToBase64(URL url) throws Exception {
		// 将图片文件转化为字节数组字符串，并对其进行Base64编码处理
		// System.out.println("图片的路径为:" + url.toString());
		// 打开链接
		HttpURLConnection conn = null;
		try {
			conn = (HttpURLConnection) url.openConnection();
			// 设置请求方式为"GET"
			conn.setRequestMethod("GET");
			// 超时响应时间为5秒
			conn.setConnectTimeout(5 * 1000);
			// 通过输入流获取图片数据
			InputStream inStream = conn.getInputStream();
			// 得到图片的二进制数据，以二进制封装得到数据，具有通用性
			ByteArrayOutputStream outStream = new ByteArrayOutputStream();
			// 创建一个Buffer字符串
			byte[] buffer = new byte[1024];
			// 每次读取的字符串长度，如果为-1，代表全部读取完毕
			int len = 0;
			// 使用一个输入流从buffer里把数据读取出来
			while ((len = inStream.read(buffer)) != -1) {
				// 用输出流往buffer里写入数据，中间参数代表从哪个位置开始读，len代表读取的长度
				outStream.write(buffer, 0, len);
			}
			// 关闭输入流
			inStream.close();
			byte[] data = outStream.toByteArray();
			// 对字节数组Base64编码
			BASE64Encoder encoder = new BASE64Encoder();
			String base64 = encoder.encode(data);
			return base64;// 返回Base64编码过的字节数组字符串
		} catch (IOException e) {
			e.printStackTrace();
			throw new Exception("图片上传失败,请联系客服!");
		}

	}

	// 插入文章
	@SuppressWarnings("unchecked")
	public ResultDto insertWZ(String data) throws Exception {
		ResultDto resultDto = new ResultDto();
		Map<String, Object> map = JSON.parseObject(data, Map.class);
		if (map.get("vc_title") == null) {
			resultDto.setSuccess(false);
			return resultDto;
		}

		String isyyfs = map.get("isyyfs").toString();
		int isyyfs2 = Integer.parseInt(isyyfs);

		String yyfssj = "";
		if (isyyfs2 == 0) {
			yyfssj = "";
		} else {
			yyfssj = map.get("yyfssj").toString();
		}

		String imgFilePath = "";
		// 轮播图链接
		if (map.get("imgFilePath") != null) {
			imgFilePath = map.get("imgFilePath").toString();
			String base64_str = encodeImageToBase64(new URL(imgFilePath));// 将网络图片编码为base64
		}

		// 标题
		String titel = map.get("vc_title").toString();

		// 栏目id
		String i_cataid = map.get("i_cataid").toString();
		// 栏目名称
		String vc_cataname = map.get("vc_cataname").toString();
		// 是否发布网站
		int iswz = Integer.parseInt(map.get("iswz").toString());
		// 是否发布app
		int isapp = Integer.parseInt(map.get("isapp").toString());
		// 是否发布微信
		int iswx = Integer.parseInt(map.get("iswx").toString());
		// 是否发布智能终端
		int isznzd = Integer.parseInt(map.get("isznzd").toString());

		int issh = 0;
		// 来源
		String vc_source = "";
		if (map.get("vc_source") == null) {
			vc_source = "";
		} else {
			vc_source = map.get("vc_source").toString();
		}

		// 作者
		String vc_author = "";
		if (map.get("vc_author") == null) {
			vc_author = "";
		} else {
			vc_author = map.get("vc_author").toString();
		}

		// 录入人
		String vc_editor = "";
		if (map.get("vc_editor") == null) {
			vc_editor = "";
		} else {
			vc_editor = map.get("vc_editor").toString();
		}

		// 显示时间
		String c_deploytime = map.get("c_deploytime").toString();

		// 内容
		String vc_content = "";
		if (map.get("vc_content") == null) {
			vc_content = "";
		} else {
			vc_content = map.get("vc_content").toString();
		}

		M_XWINFO mXwinfo = new M_XWINFO();
		mXwinfo.setVc_title(titel);
		mXwinfo.setI_cataid(i_cataid);
		mXwinfo.setVc_cataname(vc_cataname);
		mXwinfo.setIswz(iswz);
		mXwinfo.setIsapp(isapp);
		mXwinfo.setIswx(iswx);
		mXwinfo.setIsznzd(isznzd);
		mXwinfo.setVc_source(vc_source);
		mXwinfo.setVc_author(vc_author);
		mXwinfo.setC_deploytime(c_deploytime);
		mXwinfo.setVc_content(vc_content);
		mXwinfo.setLbt(imgFilePath);
		mXwinfo.setYyfssj(yyfssj);
		mXwinfo.setIsyyfs(isyyfs2);

		mXwinfo.setVc_webname("黄冈住房公积金");
		mXwinfo.setI_webid("14");
		mXwinfo.setVc_sectitle("");
		mXwinfo.setVc_thdtitle("");
		mXwinfo.setVc_userid("");
		mXwinfo.setVc_editor(vc_editor);
		mXwinfo.setVc_keyword("");
		mXwinfo.setVc_pic("");
		mXwinfo.setVc_flash("");
		mXwinfo.setVc_attach("");
		mXwinfo.setVc_media("");
		mXwinfo.setVc_describe("");

		// 操作人
		mXwinfo.setOperator("");

		// 主键id
		String s = UUID.randomUUID().toString();
		// 去掉"-"符号
		String guid = s.substring(0, 8) + s.substring(9, 13) + s.substring(14, 18) + s.substring(19, 23)
				+ s.substring(24);
		mXwinfo.setI_id(guid);

		mXwinfo.setIssh(0);

		// 创建时间
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");// 设置日期格式
		String date = df.format(new Date());// new Date()为获取当前系统时间
		// 如果发送网站并且审核通过isfsgwz = 1表示网站有这篇网站

		mXwinfo.setIsfsgwz(0);

		int num = insertLanMuContent(mXwinfo);
		// if (issh > 0 && iswz > 0) {
		// String xml = CateInfoMB(mXwinfo, "1", date);
		// String result = editArticle(xml);
		// System.out.println(result);
		// }

		if (num > 0) {
			resultDto.setSuccess(true);
			return resultDto;
		} else {
			resultDto.setSuccess(false);
			return resultDto;
		}
	}

	// 获取栏目结构
	public String XMLStructure(String i_cataid) {
		String endpoint = "http://www.hg.gov.cn/jcms/services/WSSynchronize?wsdl"; // 信息获取接口
		// int lanmuid = Integer.parseInt(i_cataid);
		String cataId = "8562"; // 栏目id
		// String strWebId = "14";
		// String strLoginId = "admin"; // 登录名
		// String strPwd = "hanweb1"; // 登陆密码
		// String strKey = ""; // 空即可
		String result = "";

		try {
			Service service = new Service();
			Call call = (Call) service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(endpoint));
			call.setOperationName("wsGetColumnStyle");
			// 设置参数类型 节点id
			call.addParameter("cataId", XMLType.SOAP_STRING, ParameterMode.IN);
			call.setReturnType(XMLType.SOAP_STRING);
			result = call.invoke(new Object[] { cataId }).toString();
			System.out.println("wsGetMultiInfos is END");
			System.out.println("result4 == " + result);
		} catch (Exception ex) {
			System.out.println("wsGetMultiInfos is ERROR");
			ex.printStackTrace();
		}

		return result;
	}

	// 删除文章
	public ResultDto deleteWz(String i_id, String i_cataid) {
		ResultDto resultDto = new ResultDto();
		String state = "3"; // 删除的状态
		M_XWINFO mXwinfo = new M_XWINFO();
		mXwinfo.setI_cataid(i_cataid);
		mXwinfo.setI_id(i_id);
		int num = 0;
		try {
			num = tyfbDao.deleteWz(i_id);

		} catch (Exception e) {
			e.printStackTrace();
			resultDto.setSuccess(false);
			return resultDto;
		}
		if (num > 0) {
			resultDto.setSuccess(true);
			return resultDto;
		} else {
			resultDto.setSuccess(false);
			return resultDto;
		}

	}

	// 修改文章内容
	@Override
	public ResultDto updateWZ(String data) throws Exception {
		ResultDto resultDto = new ResultDto();
		Map<String, Object> map = JSON.parseObject(data, Map.class);

		// 标题
		String vc_title = map.get("vc_title").toString();
		// 栏目id

		String lbt = "";
		// 轮播图链接
		if (map.get("imgFilePath") != null && map.get("imgFilePath") != "") {
			lbt = map.get("imgFilePath").toString();
		}

		String isyyfs = map.get("isyyfs").toString();
		int isyyfs2 = Integer.parseInt(isyyfs);

		String yyfssj = "";
		if (isyyfs2 == 0) {
			yyfssj = "";
		} else {
			yyfssj = map.get("yyfssj").toString();
		}

		// 录入人
		String vc_editor = "";
		if (map.get("vc_editor") == null) {
			vc_editor = "";
		} else {
			vc_editor = map.get("vc_editor").toString();
		}

		String i_cataid = map.get("i_cataid").toString();
		// 栏目名称
		String vc_cataname = map.get("vc_cataname").toString();
		// 是否网站
		// int iswz = Integer.parseInt(map.get("iswz").toString());
		// //是否app
		// int isapp = Integer.parseInt(map.get("isapp").toString());
		// //是否微信
		// int iswx = Integer.parseInt(map.get("iswx").toString());
		// //是否智能终端
		// int isznzd = Integer.parseInt(map.get("isznzd").toString());
		// //是否审核
		// int issh = Integer.parseInt(map.get("issh").toString());
		// 来源
		String vc_source = "";
		if (map.get("vc_source") == null) {
			vc_source = "";
		} else {
			vc_source = map.get("vc_source").toString();
		}
		String iswz = map.get("iswz").toString();
		// 是否app
		String isapp = map.get("isapp").toString();
		// 是否微信
		String iswx = map.get("iswx").toString();
		// 是否智能终端
		String isznzd = map.get("isznzd").toString();
		// 是否审核
		String issh = "0";
		// 作者
		String vc_author = "";
		if (map.get("vc_author") == null) {
			vc_author = "";
		} else {
			vc_author = map.get("vc_author").toString();
		}
		// 显示时间
		String c_deploytime = map.get("c_deploytime").toString();

		// 内容
		String vc_content = "";
		if (map.get("vc_content") == null) {
			vc_content = "";
		} else {
			vc_content = map.get("vc_content").toString();
		}
		// 主键id
		String i_id = map.get("i_id").toString();

		// 操作人
		String operator = "";
		if (map.get("operator") == null) {
			operator = "";
		} else {
			operator = map.get("operator").toString();
		}

		M_XWINFO mXwinfo = wzInfo(i_id);
		int isfsgwz = mXwinfo.getIsfsgwz();
		int num = 0;
		try {
			num = tyfbDao.updateWZ(vc_title, i_cataid, vc_cataname, iswz, isapp, iswx, isznzd, issh, vc_author,
					c_deploytime, vc_content, i_id, operator, vc_source, isfsgwz, lbt, yyfssj, isyyfs, vc_editor);
		} catch (Exception e) {
			e.printStackTrace();
			resultDto.setSuccess(false);
			return resultDto;
		}

		// String isfsg = tyfbDao.isfsgwz(i_id);

		// mXwinfo.setVc_title(vc_title);
		// mXwinfo.setI_cataid(i_cataid);
		// mXwinfo.setVc_cataname(vc_cataname);
		// int iswz2 = Integer.parseInt(iswz.toString());
		// int isapp2 = Integer.parseInt(isapp.toString());
		// int iswx2 = Integer.parseInt(iswx.toString());
		// int isznzd2 = Integer.parseInt(isznzd.toString());
		// int issh2 = 0;
		//
		// mXwinfo.setIswz(iswz2);
		// mXwinfo.setIsapp(isapp2);
		// mXwinfo.setIswx(iswx2);
		// mXwinfo.setIssh(issh2);
		// mXwinfo.setIsznzd(isznzd2);
		// mXwinfo.setVc_author(vc_author);
		// mXwinfo.setVc_content(vc_content);
		// mXwinfo.setC_deploytime(c_deploytime);
		// mXwinfo.setI_id(i_id);
		// mXwinfo.setOperator(operator);
		// mXwinfo.setVc_source(vc_source);
		// mXwinfo.setIsfsgwz(isfsgwz);
		//
		// mXwinfo.setVc_webname("黄冈住房公积金");
		// mXwinfo.setI_webid("14");
		// mXwinfo.setVc_sectitle("");
		// mXwinfo.setVc_thdtitle("");
		// mXwinfo.setVc_userid("");
		// mXwinfo.setVc_editor("");
		// mXwinfo.setVc_keyword("");
		// mXwinfo.setVc_pic("");
		// mXwinfo.setVc_flash("");
		// mXwinfo.setVc_attach("");
		// mXwinfo.setVc_media("");
		// mXwinfo.setVc_describe("");
		//
		// SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		// String date = sdf.format(mXwinfo.getC_createdate());
		// if (isfsg.equals("1")) {
		// String xml = CateInfoMB(mXwinfo, "2", date);
		// String result = editArticle(xml);
		// } else {
		// if (issh.equals("1") && iswz.equals("1")) {
		// mXwinfo.setIsfsgwz(1);
		// String xml = CateInfoMB(mXwinfo, "1", date);
		// String result = editArticle(xml);
		// System.out.println(result);
		// tyfbDao.updateFSG(i_id, "1");
		// }
		// }

		if (num > 0) {
			resultDto.setSuccess(true);
			return resultDto;
		} else {
			resultDto.setSuccess(false);
			return resultDto;
		}
	}

	public M_XWINFO wzInfo(String i_id) {
		List<Map<String, Object>> data = tyfbDao.sreachInfo(i_id);
		M_XWINFO mXwinfo = null;
		for (Map<String, Object> xwinfo : data) {
			mXwinfo = new M_XWINFO();
			if (xwinfo.get("C_CREATEDATE") == null) {
				mXwinfo.setC_createdate(null);
			} else {
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				String cjsj = xwinfo.get("C_CREATEDATE").toString();
				Date c_creatwdate;
				try {
					c_creatwdate = sdf.parse(cjsj);
					mXwinfo.setC_createdate(c_creatwdate);
				} catch (ParseException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			}

			if (xwinfo.get("LBT") == null) {
				mXwinfo.setLbt("");
			} else {
				mXwinfo.setLbt(xwinfo.get("LBT").toString());
			}
			if (xwinfo.get("I_CATAID") == null) {
				mXwinfo.setI_cataid("");
			} else {
				mXwinfo.setI_cataid(xwinfo.get("I_CATAID").toString());
			}
			if (xwinfo.get("VC_CATANAME") == null) {
				mXwinfo.setVc_cataname("");
			} else {
				mXwinfo.setVc_cataname(xwinfo.get("VC_CATANAME").toString());
			}
			if (xwinfo.get("I_WEBID") == null) {
				mXwinfo.setI_webid("");
			} else {
				mXwinfo.setI_webid(xwinfo.get("I_WEBID").toString());
			}
			if (xwinfo.get("VC_WEBNAME") == null) {
				mXwinfo.setVc_webname("");
			} else {
				mXwinfo.setVc_webname(xwinfo.get("VC_WEBNAME").toString());
			}
			if (xwinfo.get("I_ID") == null) {
				mXwinfo.setI_id("");
			} else {
				mXwinfo.setI_id(xwinfo.get("I_ID").toString());
			}
			if (xwinfo.get("VC_TITLE") == null) {
				mXwinfo.setVc_title("");
			} else {
				mXwinfo.setVc_title(xwinfo.get("VC_TITLE").toString());
			}

			if (xwinfo.get("VC_SECTITLE") == null) {
				mXwinfo.setVc_sectitle("");
			} else {
				mXwinfo.setVc_sectitle(xwinfo.get("VC_SECTITLE").toString());
			}
			if (xwinfo.get("VC_THDTITLE") == null) {
				mXwinfo.setVc_thdtitle("");
			} else {
				mXwinfo.setVc_thdtitle(xwinfo.get("VC_THDTITLE").toString());
			}
			if (xwinfo.get("VC_AUTHOR") == null) {
				mXwinfo.setVc_author("");
			} else {
				mXwinfo.setVc_author(xwinfo.get("VC_AUTHOR").toString());
			}
			if (xwinfo.get("VC_SOURCE") == null) {
				mXwinfo.setVc_source("");
			} else {
				mXwinfo.setVc_source(xwinfo.get("VC_SOURCE").toString());
			}
			if (xwinfo.get("VC_USERID") == null) {
				mXwinfo.setVc_userid("");
			} else {
				mXwinfo.setVc_userid(xwinfo.get("VC_USERID").toString());
			}
			if (xwinfo.get("VC_EDITOR") == null) {
				mXwinfo.setVc_editor("");
			} else {
				mXwinfo.setVc_editor(xwinfo.get("VC_EDITOR").toString());
			}
			if (xwinfo.get("VC_KEYWORD") == null) {
				mXwinfo.setVc_keyword("");
			} else {
				mXwinfo.setVc_keyword(xwinfo.get("VC_KEYWORD").toString());
			}
			if (xwinfo.get("VC_DESCRIBE") == null) {
				mXwinfo.setVc_describe("");
			} else {
				mXwinfo.setVc_describe(xwinfo.get("VC_DESCRIBE").toString());
			}
			if (xwinfo.get("C_DEPLOYTIME") == null) {
				mXwinfo.setC_deploytime(null);
			} else {

				SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				String xssj = xwinfo.get("C_DEPLOYTIME").toString();
				Date c_deploytime;
				try {
					c_deploytime = sdf2.parse(xssj);
					mXwinfo.setC_createdate(c_deploytime);
				} catch (ParseException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			}

			if (xwinfo.get("VC_CONTENT") == null) {
				mXwinfo.setVc_content("");
			} else {
				try {
					String vc_content = ClobToString(xwinfo.get("VC_CONTENT"));
					mXwinfo.setVc_content(vc_content);
				} catch (SQLException | IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			}

			int iswz = Integer.parseInt(xwinfo.get("ISWZ").toString());
			mXwinfo.setIswz(iswz);

			int isapp = Integer.parseInt(xwinfo.get("ISAPP").toString());
			mXwinfo.setIsapp(isapp);

			int iswx = Integer.parseInt(xwinfo.get("ISWX").toString());
			mXwinfo.setIswx(iswx);

			int isznzd = Integer.parseInt(xwinfo.get("ISZNZD").toString());
			mXwinfo.setIsznzd(isznzd);

			int issh = Integer.parseInt(xwinfo.get("ISSH").toString());
			mXwinfo.setIssh(issh);

			int isfsgwz = Integer.parseInt(xwinfo.get("ISFSGWZ").toString());
			mXwinfo.setIsfsgwz(isfsgwz);
		}
		return mXwinfo;

	}

	// 根据id查询文章内容
	@Override
	public List<M_XWINFO> searchWZ(String i_id) {
		List<M_XWINFO> list = new ArrayList<>();
		List<Map<String, Object>> data = tyfbDao.searchWZ(i_id);
		for (Map<String, Object> xwinfo : data) {
			M_XWINFO mXwinfo = new M_XWINFO();
			if (xwinfo.get("C_CREATEDATE") == null) {
				mXwinfo.setC_createdate(null);
			} else {
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				String cjsj = xwinfo.get("C_CREATEDATE").toString();
				Date c_creatwdate;
				try {
					c_creatwdate = sdf.parse(cjsj);
					mXwinfo.setC_createdate(c_creatwdate);
				} catch (ParseException e) {
					e.printStackTrace();
				}

			}

			String yyfssj = "";
			if (xwinfo.get("YYFSSJ") == null) {
				yyfssj = "";
				mXwinfo.setYyfssj(yyfssj);
			} else {
				mXwinfo.setYyfssj(xwinfo.get("YYFSSJ").toString());
			}

			String isyyfs = xwinfo.get("ISYYFS").toString();
			int isyyfs2 = Integer.parseInt(isyyfs);
			mXwinfo.setIsyyfs(isyyfs2);

			if (xwinfo.get("LBT") == null) {
				mXwinfo.setLbt("");
			} else {
				mXwinfo.setLbt(xwinfo.get("LBT").toString());
			}

			if (xwinfo.get("I_CATAID") == null) {
				mXwinfo.setI_cataid("");
			} else {
				mXwinfo.setI_cataid(xwinfo.get("I_CATAID").toString());
			}
			if (xwinfo.get("VC_CATANAME") == null) {
				mXwinfo.setVc_cataname("");
			} else {
				mXwinfo.setVc_cataname(xwinfo.get("VC_CATANAME").toString());
			}
			if (xwinfo.get("I_WEBID") == null) {
				mXwinfo.setI_webid("");
			} else {
				mXwinfo.setI_webid(xwinfo.get("I_WEBID").toString());
			}
			if (xwinfo.get("VC_WEBNAME") == null) {
				mXwinfo.setVc_webname("");
			} else {
				mXwinfo.setVc_webname(xwinfo.get("VC_WEBNAME").toString());
			}
			if (xwinfo.get("I_ID") == null) {
				mXwinfo.setI_id("");
			} else {
				mXwinfo.setI_id(xwinfo.get("I_ID").toString());
			}
			if (xwinfo.get("VC_TITLE") == null) {
				mXwinfo.setVc_title("");
			} else {
				mXwinfo.setVc_title(xwinfo.get("VC_TITLE").toString());
			}

			if (xwinfo.get("VC_SECTITLE") == null) {
				mXwinfo.setVc_sectitle("");
			} else {
				mXwinfo.setVc_sectitle(xwinfo.get("VC_SECTITLE").toString());
			}
			if (xwinfo.get("VC_THDTITLE") == null) {
				mXwinfo.setVc_thdtitle("");
			} else {
				mXwinfo.setVc_thdtitle(xwinfo.get("VC_THDTITLE").toString());
			}
			if (xwinfo.get("VC_AUTHOR") == null) {
				mXwinfo.setVc_author("");
			} else {
				mXwinfo.setVc_author(xwinfo.get("VC_AUTHOR").toString());
			}
			if (xwinfo.get("VC_SOURCE") == null) {
				mXwinfo.setVc_source("");
			} else {
				mXwinfo.setVc_source(xwinfo.get("VC_SOURCE").toString());
			}
			if (xwinfo.get("VC_USERID") == null) {
				mXwinfo.setVc_userid("");
			} else {
				mXwinfo.setVc_userid(xwinfo.get("VC_USERID").toString());
			}
			if (xwinfo.get("VC_EDITOR") == null) {
				mXwinfo.setVc_editor("");
			} else {
				mXwinfo.setVc_editor(xwinfo.get("VC_EDITOR").toString());
			}
			if (xwinfo.get("VC_KEYWORD") == null) {
				mXwinfo.setVc_keyword("");
			} else {
				mXwinfo.setVc_keyword(xwinfo.get("VC_KEYWORD").toString());
			}
			if (xwinfo.get("VC_DESCRIBE") == null) {
				mXwinfo.setVc_describe("");
			} else {
				mXwinfo.setVc_describe(xwinfo.get("VC_DESCRIBE").toString());
			}
			if (xwinfo.get("C_DEPLOYTIME") == null) {
				mXwinfo.setC_deploytime(null);
			} else {

				SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				String xssj = xwinfo.get("C_DEPLOYTIME").toString();
				Date c_deploytime;
				try {
					c_deploytime = sdf2.parse(xssj);
					mXwinfo.setC_createdate(c_deploytime);
				} catch (ParseException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			}

			if (xwinfo.get("VC_CONTENT") == null) {
				mXwinfo.setVc_content("");
			} else {
				try {
					String vc_content = ClobToString(xwinfo.get("VC_CONTENT"));
					mXwinfo.setVc_content(vc_content);
				} catch (SQLException | IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			}

			int iswz = Integer.parseInt(xwinfo.get("ISWZ").toString());
			mXwinfo.setIswz(iswz);

			int isapp = Integer.parseInt(xwinfo.get("ISAPP").toString());
			mXwinfo.setIsapp(isapp);

			int iswx = Integer.parseInt(xwinfo.get("ISWX").toString());
			mXwinfo.setIswx(iswx);

			int isznzd = Integer.parseInt(xwinfo.get("ISZNZD").toString());
			mXwinfo.setIsznzd(isznzd);

			int issh = Integer.parseInt(xwinfo.get("ISSH").toString());
			mXwinfo.setIssh(issh);

			list.add(mXwinfo);

		}
		return list;
	}

	public void wsGetMultiInfos() {
		/* 接口访问地址 */
		String url = "http://www.hg.gov.cn/jcms/services/WSReceive?wsdl";
		/* 登录名、密码、密钥 */
		String strLoginId = "32b46a245ebdd662ec91bf7d2c8b65fd16db5b92a1a3d3727db2563e1e0ef3391df4446457039f33cf1b519196c473f3250c53305291d78d9f0cd7883e387c55b750f53f3a7f3c664db8634fb362e130d9524b66d49813bf42f869ac21f36e216a8c3c696c897fb1aab44080a1486f469e7397a3c5b66b31ad9850795eb2b781";
		String strPwd = "09b60b11017a89bb2f8d798581ffff09db6f4ceb8ba531f5868d66e42de1c0581a1b3a8103e449902511cc12828c0a40ab61dea8d983c08580dc02a4eba87903019a559ab9c2b7ffbd31de8788477d31021ff67749ef052ed284a29598ad1eb3df1005ee04aa4d82b1c0cf5f61de2f4fa32c656f8fccea24643d177ceb9bd81a";
		String strKey = "";
		/* 栏目ID */
		int nCataId = 8384;
		/* 起始时间、结束时间 */
		String strStartCTime = "2018-03-06";
		String strEndCTime = "2018-03-10";
		/* 是否获取引用信息、是否对内容进行base64编码 */
		int bRef = 0;
		int iBase64 = 0;
		/* 起始值、结束值 */
		int nStart = 1;
		int nEnd = 10;
		/* 降（升） 序 */
		int bAsc = 0;
		/* 返回值 */
		String result = "";
		try {
			Service service = new Service();
			Call call = (Call) service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(url));
			call.setOperationName("wsGetMultiInfos");
			call.addParameter("nCataId", XMLType.XSD_INT, ParameterMode.IN);
			call.addParameter("bRef", XMLType.XSD_INT, ParameterMode.IN);
			call.addParameter("iBase64", XMLType.XSD_INT, ParameterMode.IN);
			call.addParameter("nStart", XMLType.XSD_INT, ParameterMode.IN);
			call.addParameter("nEnd", XMLType.XSD_INT, ParameterMode.IN);
			call.addParameter("bAsc", XMLType.XSD_INT, ParameterMode.IN);
			call.addParameter("strStartCTime", XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter("strEndCTime", XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter("strLoginId", XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter("strPwd", XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter("strKey", XMLType.XSD_STRING, ParameterMode.IN);
			call.setReturnType(XMLType.XSD_STRING);
			result = (String) call.invoke(new Object[] { nCataId, bRef, iBase64, nStart, nEnd, bAsc, strStartCTime,
					strEndCTime, strLoginId, strPwd, strKey });
		} catch (Exception e) {
			result = "error";
			e.printStackTrace();
		}
		System.out.println("调用结果为：" + result);
	}

	// 更新文章
	public ResultDto updateWZContent(String lanmuid) {
		ResultDto resultDto = new ResultDto();
		int num4 = tyfbDao.isUpdate(lanmuid, "2");
		// System.out.println(num4);
		String endpoint = "http://www.hg.gov.cn/jcms/services/WSReceive?wsdl"; // 信息获取接口
		int lanmid = Integer.parseInt(lanmuid);
		int num = 0;
		M_XWINFO mXwinfo = null;
		//------------------------------------------------------------------
		//1.获取当前年月日
		String temp_str = "";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		temp_str = sdf.format(dt);
		System.out.println(temp_str);//输出当前年月日
		//2.获取上一年的年月日
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
		java.util.Date date = null;
		try {
			date = formatter.parse(temp_str);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} // Date格式
		Calendar calBegin = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calBegin.setTime(date);
		calBegin.add(Calendar.MONTH, -6);
		String datestr = formatter.format(calBegin.getTime());// String格式
		System.out.println(datestr);//输出上年年月日
		//---------------------------------------------------------------------------------
		
		while (true) {
			int nCataId = lanmid; // 栏目id
			int bRef = 0; // 是否取引用
			int iBase64 = 0; // 内容不加密
			int nStart = 1 + num; // 信息起始
			int nEnd = 1 + num; // 信息终止
			int bAsc = 1; // 排序
			 String strStartCTime = datestr; // 起始时间
			 String strEndCTime = temp_str; // 终止时间
			String strLoginId = "32b46a245ebdd662ec91bf7d2c8b65fd16db5b92a1a3d3727db2563e1e0ef3391df4446457039f33cf1b519196c473f3250c53305291d78d9f0cd7883e387c55b750f53f3a7f3c664db8634fb362e130d9524b66d49813bf42f869ac21f36e216a8c3c696c897fb1aab44080a1486f469e7397a3c5b66b31ad9850795eb2b781"; // 登录名
			String strPwd = "09b60b11017a89bb2f8d798581ffff09db6f4ceb8ba531f5868d66e42de1c0581a1b3a8103e449902511cc12828c0a40ab61dea8d983c08580dc02a4eba87903019a559ab9c2b7ffbd31de8788477d31021ff67749ef052ed284a29598ad1eb3df1005ee04aa4d82b1c0cf5f61de2f4fa32c656f8fccea24643d177ceb9bd81a"; // 登陆密码
			String strKey = ""; // 空即可
			String result = "";

			try {
				Service service = new Service();
				Call call = (Call) service.createCall();
				call.setTargetEndpointAddress(new java.net.URL(endpoint));
				call.setOperationName("wsGetMultiInfos");
				call.addParameter("nCataId", XMLType.XSD_INT, ParameterMode.IN);
				call.addParameter("bRef", XMLType.XSD_INT, ParameterMode.IN);
				call.addParameter("iBase64", XMLType.XSD_INT, ParameterMode.IN);
				call.addParameter("nStart", XMLType.XSD_INT, ParameterMode.IN);
				call.addParameter("nEnd", XMLType.XSD_INT, ParameterMode.IN);
				call.addParameter("bAsc", XMLType.XSD_INT, ParameterMode.IN);
				 call.addParameter("strStartCTime",XMLType.XSD_STRING,ParameterMode.IN);
				 call.addParameter("strEndCTime",XMLType.XSD_STRING,ParameterMode.IN);
				call.addParameter("strLoginId", XMLType.XSD_STRING, ParameterMode.IN);
				call.addParameter("strPwd", XMLType.XSD_STRING, ParameterMode.IN);
				call.addParameter("strKey", XMLType.XSD_STRING, ParameterMode.IN);
				call.setReturnType(XMLType.XSD_STRING);
				result = (String) call.invoke(
						new Object[] { nCataId, bRef, iBase64, nStart, nEnd, bAsc,strStartCTime,strEndCTime, strLoginId, strPwd, strKey });
				Document document = DocumentHelper.parseText(result);

				Element root = document.getRootElement();

				// Element code = (Element)
				// root.selectSingleNode("/dahan/code");
				// String code2 = code.getText();
				// if (code2.equals("08")) {
				// resultDto.setSuccess(true);
				// return resultDto;
				// }

				// 栏目id
				Element i_cataidElement = (Element) root.selectSingleNode("/main/article/field[@id='i_cataid']");
				if (i_cataidElement == null) {
					break;
				}
				String i_cataid = i_cataidElement.getText();

				// 栏目名称
				Element vc_catanameElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_cataname']");
				String vc_cataname = vc_catanameElement.getText();
				// 网站id
				Element i_webidElement = (Element) root.selectSingleNode("/main/article/field[@id='i_webid']");
				String i_webid = i_webidElement.getText();
				// 网站名称
				Element vc_webnameElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_webname']");
				String vc_webname = vc_webnameElement.getText();

				// 流水号
				Element i_idElement = (Element) root.selectSingleNode("/main/article/field[@id='i_id']");
				String i_id = i_idElement.getText();

				// 标题
				Element vc_titleElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_title']");
				String vc_title = vc_titleElement.getText();

				// 副标题
				Element vc_sectitleElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_sectitle']");
				String vc_sectitle = vc_sectitleElement.getText();

				// 引题
				Element vc_thdtitleElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_thdtitle']");
				String vc_thdtitle = vc_thdtitleElement.getText();

				// 作者
				Element vc_authorElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_author']");
				String vc_author = vc_authorElement.getText();

				// 来源
				Element vc_sourceElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_source']");
				String vc_source = vc_sourceElement.getText();

				// 录入人ID
				Element vc_useridElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_userid']");
				String vc_userid = vc_useridElement.getText();

				// 录入人
				Element vc_editorElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_editor']");
				String vc_editor = vc_editorElement.getText();

				// 关键字
				Element vc_keywordElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_keyword']");
				String vc_keyword = vc_keywordElement.getText();

				// 摘要
				Element vc_describeElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_describe']");
				String vc_describe = vc_describeElement.getText();

				// 显示时间
				Element c_deploytimeElement = (Element) root
						.selectSingleNode("/main/article/field[@id='c_deploytime']");

				String c_deploytime = c_deploytimeElement.getText();

				// 创建时间
				Element c_createdateElement = (Element) root
						.selectSingleNode("/main/article/field[@id='c_createdate']");
				SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				String cjsj = c_createdateElement.getText();
				Date c_createdate = sdf2.parse(cjsj);
				// 图片
				// Element vc_picElement =
				// (Element)root.selectSingleNode("/main/article/field[@id='vc_pic']");
				// String vc_pic = vc_picElement.getText();

				// 动画
				// Element vc_flashElement =
				// (Element)root.selectSingleNode("/main/article/field[@id='vc_flash']");
				// String vc_flash = vc_flashElement.getText();

				// 附件
				// Element vc_attachElement =
				// (Element)root.selectSingleNode("/main/article/field[@id='vc_attach']");
				// String vc_attach = vc_attachElement.getText();

				// 视频
				// Element vc_mediaElement =
				// (Element)root.selectSingleNode("/main/article/field[@id='vc_media']");
				// String vc_media = vc_mediaElement.getText();

				// 信息内容
				Element vc_contentElement = (Element) root.selectSingleNode("/main/article/field[@id='vc_content']");
				String vc_content_tmp = vc_contentElement.getText();

				// System.out.println("aaaa-------------------vc_content_tmp:"+vc_content_tmp);

				// 将中文空格替换成英文空格

				// String vc_content = vc_content_tmp.replace("  "," ");

				String vc_content = vc_content_tmp.replace(" ", " ");

				vc_content = vc_content.replace(" ", " ");

				// String vc_content = new String(vc_content_tmp.getBytes(
				// "UTF-8"));

				// vc_content_tmp.getBytes("UTF-8");

				mXwinfo = new M_XWINFO();
				// 栏目id
				mXwinfo.setI_cataid(i_cataid);
				// 栏目名称
				mXwinfo.setVc_cataname(vc_cataname);
				mXwinfo.setI_webid(i_webid);
				mXwinfo.setVc_webname(vc_webname);
				mXwinfo.setI_id(i_id);
				mXwinfo.setVc_title(vc_title);
				mXwinfo.setVc_sectitle(vc_sectitle);
				mXwinfo.setVc_thdtitle(vc_thdtitle);
				mXwinfo.setVc_author(vc_author);
				mXwinfo.setVc_source(vc_source);
				mXwinfo.setVc_userid(vc_userid);
				mXwinfo.setVc_editor(vc_editor);
				mXwinfo.setVc_keyword(vc_keyword);
				mXwinfo.setVc_describe(vc_describe);
				mXwinfo.setC_deploytime(c_deploytime);
				mXwinfo.setC_createdate(c_createdate);
				// mXwinfo.setVC_PIC(vc_pic);
				// mXwinfo.setVC_FLASH(vc_flash);
				// mXwinfo.setVC_ATTACH(vc_attach);
				// mXwinfo.setVC_MEDIA(vc_media);
				mXwinfo.setVc_content(vc_content);
				
				int num2 = tyfbDao.updateLanmuInfo(mXwinfo);
				if (num2 == 0) {
					int num3 = insertContent(mXwinfo);
					if (num3 > 0) {
						resultDto.setSuccess(true);
					} else {
						resultDto.setSuccess(false);
					}
				}
				System.out.println("多少行:"+nEnd);
				// System.out.println("成功");
				num++;

			} catch (Exception ex) {
				resultDto.setSuccess(true);
				tyfbDao.isUpdate(lanmuid, "1");
				System.out.println("wsGetMultiInfos is ERROR");
				ex.printStackTrace();
				return resultDto;
			}

		}
		tyfbDao.isUpdate(lanmuid, "1");
		resultDto.setSuccess(true);
		return resultDto;

	}

	// 审核文章
	@Override
	public ResultDto reviewArticle(String i_id, String isyyfs) throws Exception {
		ResultDto resultDto = new ResultDto();
		int issh2 = 1;
		M_XWINFO mXwinfo = wzInfo(i_id);
		String base64_str = "";

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// 转成base64
		// if (mXwinfo.getLbt() != null && mXwinfo.getLbt() != "") {
		// base64_str = encodeImageToBase64(new URL(mXwinfo.getLbt()));//
		// 将网络图片编码为base64
		// mXwinfo.setVc_pic(base64_str);
		// }

		if (isyyfs.equals("0")) {
			mXwinfo.setVc_webname("黄冈住房公积金");
			mXwinfo.setI_webid("14");
			int iswz = mXwinfo.getIswz();
			String isfsg = "0";
			isfsg = tyfbDao.isfsgwz(i_id);
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			String date = sdf.format(mXwinfo.getC_createdate());
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			// 先判断是否文章是否发送过网站，如果发送过只能修改不能重复发送
			if (isfsg.equals("1") && iswz > 0 && issh2 > 0) {
				// 把发送过网站的状态改成1发送过
				tyfbDao.updateFSG(i_id, "1");
				isfsg = tyfbDao.isfsgwz(i_id);
				String xml = CateInfoMB(mXwinfo, "2", date);
				String result = editArticle(xml);
				tyfbDao.updateISSH(i_id, issh2 + "");
				resultDto.setSuccess(true);
			} else if (isfsg.equals("0") && iswz == 1 && issh2 == 1) {
				mXwinfo.setIsfsgwz(1);
				String xml = CateInfoMB(mXwinfo, "1", date);
				String result = editArticle(xml);
				// System.out.println(result);
				tyfbDao.updateFSG(i_id, "1");
				tyfbDao.updateISSH(i_id, issh2 + "");
				resultDto.setSuccess(true);
			} else {
				tyfbDao.updateISSH(i_id, issh2 + "");
				resultDto.setSuccess(true);
			}
		} else {
			tyfbDao.updateISSH(i_id, issh2 + "");
			resultDto.setSuccess(true);
		}

		return resultDto;
	}

	// 获取栏目更新状态
	@Override
	public String getLanMuState(String lanmuid) {
		int isupdate = tyfbDao.getLanMuState(lanmuid);
		String updateState = isupdate + "";
		return updateState;
	}

	// 查询各渠道栏目内容的更新
	@Override
	public List<UpdateNumDto> sreachUpdateContentNum(String year) {
		return tyfbDao.sreachUpdateContentNum(year);
	}

	// 栏目更新量统计
	@Override
	public List<UpdateStatisticsDto> updateStatistics(String time) {

		return tyfbDao.updateStatistics(time);
	}

	// base64转码生成图片保存到本地生成url
	public void homeCarouselURL() {

	}

	// 定时预约发送文章
	@Override
	public void sendArticle() throws Exception {
		List<String> list = tyfbDao.nendSendArticle();
		for (String str : list) {
			String i_id = str;
			yyfb(i_id);
		}
	}

	//预约发送
	public void yyfb(String i_id) {
		M_XWINFO mXwinfo = wzInfo(i_id);
		int issh2 = 1;
		mXwinfo.setVc_webname("黄冈住房公积金");
		mXwinfo.setI_webid("14");
		int iswz = mXwinfo.getIswz();
		String isfsg = "0";
		isfsg = tyfbDao.isfsgwz(i_id);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String date = sdf.format(mXwinfo.getC_createdate());
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		// 先判断是否文章是否发送过网站，如果发送过只能修改不能重复发送
		if (isfsg.equals("1") && iswz > 0 && issh2 > 0) {
			// 把发送过网站的状态改成1发送过
			tyfbDao.updateFSG(i_id, "1");
			isfsg = tyfbDao.isfsgwz(i_id);
			String xml = CateInfoMB(mXwinfo, "2", date);
			String result = editArticle(xml);
			// 修改预约发送状态
			tyfbDao.updateIsyyfs(i_id);

		} else if (isfsg.equals("0") && iswz == 1 && issh2 == 1) {
			mXwinfo.setIsfsgwz(1);
			String xml = CateInfoMB(mXwinfo, "1", date);
			String result = editArticle(xml);
			// System.out.println(result);
			tyfbDao.updateFSG(i_id, "1");
			// 修改预约发送状态
			tyfbDao.updateIsyyfs(i_id);

		} else {
			// 修改预约发送状态
			tyfbDao.updateIsyyfs(i_id);

		}
	}

	//统一发布日志记录
	@Override
	public ResultDto logging_tyfb(String lanmuid, String iswx, String iswz, String isapp, String isznzd, String xwly,
			String zz, String xwsj, String czr, String czzt) {
		ResultDto resultDto = new ResultDto();
		int num = tyfbDao.logging_tyfb(lanmuid, iswx, iswz, isapp, isznzd, xwly, zz, xwsj, czr, czzt);
		if (num > 0) {
			resultDto.setSuccess(true);
			return resultDto;
		}else{
			resultDto.setSuccess(false);
			return resultDto;
		}
		
	}

	//统一发布日志记录查询
	@Override
	public Map<String, Object> logging_tyfb_select(int page,int limit) {
		Map<String, Object> map = new HashMap<>();
		Page<TyfbLoggingDto> page2 = PageHelper.startPage(page, limit, true);
		List<TyfbLoggingDto> list = tyfbDao.logging_tyfb_select();
		int count = (int) page2.getTotal();
		map.put("total", count);
		map.put("list", list);
		return map;
	}

}
