package com.changda.gjjapp.zhfwpt.service.qdxxgl;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.changda.gjjapp.zhfwpt.dto.qdxxgl.GqdmenwomenblDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdfwlTjDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdfwnldTjDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdgsjdTJDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdgzxzlTjDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdywfwlDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdywzbDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoFWLZBDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoYHTJDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoYeWuBanLiTongJiDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoYeWuFWDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoYongHuTongJiDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.TdqdblyhZBDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.TdqdywblZBDTO;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.TslvDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.WanWomanZBDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.XinXiTuiSongDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.YwblCGSBDBLvDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.YwblTypeZBSLDto;

public interface QuDaoXinXiGuanLiService {

    /**
     * 业务访问详情表插入
     */
    int insertYWFWXQ(String data);

    /**
     * 渠道访问详情表插入
     *
     */
    int insertQDFWXQ(String data);


    /**
     * 渠道业务访问量
     *
     * @param date 日期
     * @return
     */
    List<QdywfwlDto> qdywfwlData(String qssj, String zzsj, String num);
    
    /**
     * 渠道访问量占比
     * @return
     */
    List<QuDaoFWLZBDto> qdfwlZB(String year);
    
    /**
     * 渠道业务访问
     * @return
     */
    List<QuDaoYeWuFWDto> qdywfw(String qssj,String zzsj,String ywfl,String grzh);
    
    /**
     * 渠道业务办理统计
     * @return
     */
    List<QuDaoYeWuBanLiTongJiDto> qdywbltj(String qssj,String zzsj,String grzh,String ywfl);
    
    /**
     * 
     * 渠道用户统计分析
     * @return
     */
    List<QuDaoYHTJDto> qdyhtjfx();
    
    
    /**
     * 渠道用户信息统计注册数和活动用户
     * @param year
     * @return
     */
    List<QuDaoYongHuTongJiDto> qdyhtjZCAndHDYH(String year,String qdid);
    
    //渠道业务访问量插入上月的数据用于统计分析
    void qdywfwlInsertTjfx();
    
    /**
     * 渠道访问统计分析图
     * @param year年份
     * @param grzh 个人账号
     * @return
     */
    List<QuDaoYeWuFWDto> qdfwtjfxt(String year,String grzh,String ywfl);
    
    /**
     * 渠道各时间段统计
     * @param year 年份
     * @return 
     */
    List<QdgsjdTJDto> qdgsjdTj(@Param("year")String year);
    
    /**
     * 渠道各年龄段访问统计
     * @param year
     * @return
     */
    List<QdfwnldTjDto> qdfwnldTj(String year);
    
    /**
     * 渠道各年龄段业务访问统计
     * @param year
     * @param ywbm
     * @return
     */
    List<QdfwnldTjDto> qdywnldfwtj(String ywbm,String qssj,String zzsj);
    
    /**
     * 渠道业务各时间段统计
     * @param ywbm
     * @param qssj
     * @param zzsj
     * @return
     */
    List<QdgsjdTJDto> qdywgsjdtj(String ywbm,String qssj,String zzsj);
    
    /**
     * 渠道访问量统计
     * @param ywbm
     * @param qssj
     * @param zzsj
     * @return
     */
    List<QdfwlTjDto> qdfwlTj(String qdid,String year);
    
    /**
     * 渠道下载量关注量访问量统计
     * @param qdid
     * @param year
     * @return
     */
    List<QdgzxzlTjDto> qdgzxzlTj(String qdid,String year);
    
    /**
     * 各渠道注册男女比例占比
     * @return
     */
    List<GqdmenwomenblDto> gqdmenwomenbl();
    
    /**
     * 各渠道信息推送量统计
     * @param year 年饭
     */
    List<XinXiTuiSongDto> xinXiTuiSongTJ(String year);
    
    /**
     * 注销被锁定总人数
     */
    int userLogoutStatus();
    
    /**
     * 男女比例
     * @return
     */
    WanWomanZBDto wanWomanZB();
    
    /**
     * 渠道业务占比
     * @return
     */
    QdywzbDto qdywzb(String year,String month,String ywlx);
    
    /**
     * 注册用户年龄分析
     * @return
     */
    QdfwnldTjDto zcyhnlFX();
    
    /**
     * 各渠道办理成功失败代办率
     * @param year
     * @param month
     * @return
     */
    List<YwblCGSBDBLvDto> ywblCGSBDBlv(String year,String month,String qdid);
    
    /**
     * 业务办理类型 占比数量
     * @param qdid
     * @return
     */
    List<YwblTypeZBSLDto> ywblTypeZBSL(String year,String month,String qdid);
    
    /**
     * 投诉率
     * @param year
     * @return
     */
    TslvDto tslv(String year);
    
    /**
     * 用户分布情况
     * @param year
     * @param month
     * @param qdid
     * @return
     */
    TdqdblyhZBDto tdqdblyhZB(String year,String month,String qdid);
    
    /**
     * 渠道分布情况
     * @param year
     * @param month
     * @param qdid
     * @return
     */
    TdqdywblZBDTO tdqdywblZB(String year,String month,String qdid);
    
    /**
     * 用户分析活动用户的年龄段和活动用户和注册用户占比
     * @return
     */
    Map<String, Object> userFBNLD(String num);
}
