package com.changda.gjjapp.gedai.controller;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.gedai.dto.yinhangpikou.YinHangPiKouCompareDto;
import com.changda.gjjapp.gedai.dto.zhuyuehuakou.ZhuYueHuakouCompareDto;
import com.changda.gjjapp.gedai.service.yinhangpikou.IYinHangPiKouCheckService;
import com.changda.gjjapp.gedai.service.zhuyuehuakou.IZhuYueHuaKouCheckService;

@Controller()
@RequestMapping(value="/gedai/GD_YinHangPiKouCheck")
public class GD_YinHangPiKouCheckController {

	@Qualifier("yinHangPiKouCheckServiceImpl")
	@Autowired
	private IYinHangPiKouCheckService iYinHangPiKouCheckService;
	
	@Autowired  
	private IZhuYueHuaKouCheckService IZhuYueHuaKouCheckService;
	
	/*public void show(){
		System.out.println("11111111111111111");
	}*/
	
	@ResponseBody
	public void yinHangPiKouData() throws ParseException, IOException{
		String zjzxdm = "";
		String dkyh = "";
		String kjqj = "";
		Date hkrq=null;
		iYinHangPiKouCheckService.yinHangPiKouComparison(zjzxdm, dkyh, kjqj, hkrq);
	}

	
	public String show(){
		System.out.println("121232");
		
		return "aaaaa";
	}
	
	
	@RequestMapping("pkyj")
	@ResponseBody
	public ResultDto pkyj(HttpServletRequest request){
		ResultDto resultDto = new ResultDto();
		int hkfl = Integer.parseInt(request.getParameter("HKFL"));
		if (hkfl ==  01) {
			//执行查询逐月划扣
			resultDto = zyhkData(request);
		}else if (hkfl == 02) {
			//查询银行批扣
			resultDto = yhpkData(request);
		}
		
		return resultDto;
	}
	
	
	@RequestMapping("yhpkData")
	@ResponseBody
	public ResultDto yhpkData(HttpServletRequest request){
		String zjzxdm = request.getParameter("ZJZXDM");//从前端获取
		String dkyh = request.getParameter("DKYH");//从前端获取
		String kjqj = request.getParameter("kjqj");//从前端获取
		int page = Integer.parseInt(request.getParameter("page"));
		int limit = Integer.parseInt(request.getParameter("limit"));
		ResultDto resultDto = new ResultDto();
		Map<String, Object> yhpk = iYinHangPiKouCheckService.yhpkData(kjqj, zjzxdm, dkyh, page, limit);
		List<YinHangPiKouCompareDto> yhpkData = (List<YinHangPiKouCompareDto>) yhpk.get("yhpk");
		int total = (int) yhpk.get("total");
		resultDto.setTotal(total);
		resultDto.setData(yhpkData);
		resultDto.setSuccess(true);
		return resultDto;
	}

	@RequestMapping("zyhkData")
	@ResponseBody
	public ResultDto zyhkData(HttpServletRequest request){
		String zjzxdm = request.getParameter("ZJZXDM");//从前端获取
		String dkyh = request.getParameter("DKYH");//从前端获取
		String kjqj = request.getParameter("kjqj");//从前端获取
		int page = Integer.parseInt(request.getParameter("page"));
		int limit = Integer.parseInt(request.getParameter("limit"));
		ResultDto resultDto = new ResultDto();
		Map<String, Object> zyhk = IZhuYueHuaKouCheckService.zyhukData(kjqj, zjzxdm, dkyh, page, limit);
		List<ZhuYueHuakouCompareDto> zyhkData = (List<ZhuYueHuakouCompareDto>) zyhk.get("zyhk");
		int total = (int) zyhk.get("total");
		resultDto.setTotal(total);
		resultDto.setData(zyhkData);
		resultDto.setSuccess(true);
		return resultDto;
	}
}
