package com.changda.gjjapp.gedai.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.db.entity.GD_MX;
import com.changda.gjjapp.db.entity.TMP_YW_GDHK_QKMX_WH;
import com.changda.gjjapp.gedai.dto.zhuyuehuakou.ZhuYueHuakouCompareDto;
import com.changda.gjjapp.gedai.service.zhuyuehuakou.IZhuYueHuaKouCheckService;

@Controller("test")
@RequestMapping(value="/gedai/GD_ZhuYueHuaKouCheck")
public class GD_ZhuYueHuaKouCheckController {

	@Autowired
	@Qualifier("IZhuYueHuaKouCheckService")
	private IZhuYueHuaKouCheckService iZhuYueHuaKouCheckService;
	
	@RequestMapping("insertzyhk")
	@ResponseBody
	public  List<ZhuYueHuakouCompareDto> test(HttpServletRequest request) throws ParseException{
		ResultDto resultDto = new ResultDto();
		List<ZhuYueHuakouCompareDto> zhuYueHuaKouData = new ArrayList<>();
		String zjzxdm = request.getParameter("ZJZXDM");//从前端获取
		String dkyh = request.getParameter("DKYH");//从前端获取
		String kjqj = request.getParameter("kjqj");//从前端获取

		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM");
		
		//获取当前的本月的最后一天的日期
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.DAY_OF_MONTH,
		calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
		SimpleDateFormat lastDay= new SimpleDateFormat("yyyy-MM-dd");
		String last =  lastDay.format(calendar.getTime());
		Date sd = format.parse(last);
		java.sql.Date hkrq=new java.sql.Date(sd.getTime());
		System.err.println(hkrq);

		//获取本月减一
		Date ss = new Date();
		String time = format1.format(ss);
		Calendar cal = Calendar.getInstance();
		cal.setTime(format1.parse(time));
		cal.add(Calendar.MONTH, -1);
		String kjqj2 = format1.format(cal.getTime()); 
		System.err.println(kjqj2);

		iZhuYueHuaKouCheckService.DRDK_QKMX(hkrq, zjzxdm, dkyh, kjqj);

		resultDto.setData(zhuYueHuaKouData);
		resultDto.setSuccess(true);
		return zhuYueHuaKouData;
	}
	
	@RequestMapping("zyhkData")
	@ResponseBody
	public ResultDto zyhkData(HttpServletRequest request){
		String zjzxdm = request.getParameter("ZJZXDM");//从前端获取
		String dkyh = request.getParameter("DKYH");//从前端获取
		String kjqj = request.getParameter("kjqj");//从前端获取
		int page = Integer.parseInt(request.getParameter("page"));
		int limit = Integer.parseInt(request.getParameter("limit"));
		ResultDto resultDto = new ResultDto();
		Map<String, Object> zyhk = iZhuYueHuaKouCheckService.zyhukData(kjqj, zjzxdm, dkyh, page, limit);
		List<ZhuYueHuakouCompareDto> zyhkData = (List<ZhuYueHuakouCompareDto>) zyhk.get("zyhk");
		int total = (int) zyhk.get("total");
		resultDto.setTotal(total);
		resultDto.setData(zyhkData);
		resultDto.setSuccess(true);
		return resultDto;
	}
}
