package com.changda.gjjapp.gedai.service.impl.zhuyuehuakou;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.changda.gjjapp.db.entity.TMP_YW_GDHK_QKMX_WH;
import com.changda.gjjapp.gedai.dao.zhuyuehuakou.ZhuYueHuaKouCheckDao;
import com.changda.gjjapp.gedai.dto.zhuyuehuakou.DrdkQkmxDto;
import com.changda.gjjapp.gedai.dto.zhuyuehuakou.ZhuYueHuakouCompareDto;
import com.changda.gjjapp.gedai.service.zhuyuehuakou.IZhuYueHuaKouCheckService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;

@Service("IZhuYueHuaKouCheckService")
public class ZhuYueHuaKouCheckServiceImpl implements IZhuYueHuaKouCheckService{
	@Autowired
	private ZhuYueHuaKouCheckDao zhuYueHuaKouCheckDao;
	
	/**
	 * 上月公积金批扣金额
	 */
	@Override
	public List<Map<String, Object>> sygjjpkje(String kjqj,String zjzxdm,String dkyh) {
		List<Map<String, Object>> sypkjeList = zhuYueHuaKouCheckDao.sygjjpkje(zjzxdm, dkyh, kjqj);
		return sypkjeList;
	}
	
	/**
	 * 把查询出的逐月划扣上月和本月的数据插入到jk_zyhkwh表中
	 */
	@Override
	public void insertJKZYHK(List<ZhuYueHuakouCompareDto> list) {
		
	}
	
	/**
	 * 查询逐月划扣数据
	 */
	@Override
	public List<Map<String, Object>> zyhk(String kjqj, String zjzxdm, String dkyh) {
		
		return null;
	}

	
	/**
	 * 查询逐月划扣用于显示
	 * @param kjqj
	 * @param zjzxdm
	 * @param dkyh
	 * @return
	 */
	@Override
	public Map<String, Object> zyhukData(String kjqj, String zjzxdm, String dkyh,int page,int limit) {
		Map<String, Object> map = new HashMap<>();
 		List<ZhuYueHuakouCompareDto> zyhkData = new ArrayList<>();
		Page<ZhuYueHuakouCompareDto> page2 = PageHelper.startPage(page, limit, true);
		List<Map<String, Object>> zyhkList = zhuYueHuaKouCheckDao.zyhk(kjqj, zjzxdm, dkyh);
		int count = (int) page2.getTotal();
		
		for (Map<String, Object> zyhk : zyhkList) {
			ZhuYueHuakouCompareDto zyhkDto = new ZhuYueHuakouCompareDto();
			zyhkDto.setZjzxjc(zyhk.get("ZJZXJC").toString());
			zyhkDto.setYhjc(zyhk.get("YHJC").toString());
			zyhkDto.setBJ(Double.parseDouble(zyhk.get("BJ").toString()));
			zyhkDto.setLX(Double.parseDouble(zyhk.get("LX").toString()));
			zyhkDto.setFX(Double.parseDouble(zyhk.get("FX").toString()));
			zyhkDto.setHKJE(Double.parseDouble(zyhk.get("HKJE").toString()));
			zyhkDto.setSYBJ(Double.parseDouble(zyhk.get("SYBJ").toString()));
			zyhkDto.setSYLX(Double.parseDouble(zyhk.get("SYLX").toString()));
			zyhkDto.setSYFX(Double.parseDouble(zyhk.get("SYFX").toString()));
			zyhkDto.setSYHKJE(Double.parseDouble(zyhk.get("SYHKJE").toString()));
			zyhkDto.setJkrxm(zyhk.get("JKRXM").toString());
			zyhkDto.setJkhtbh(zyhk.get("JKHTBH").toString());
			zyhkDto.setJkrzjh(zyhk.get("JKRZJH").toString());
			zyhkDto.setZjzxdm(zyhk.get("ZJZXDM").toString());
			zyhkDto.setGrdkbm(zyhk.get("GRDKBM").toString());
			zyhkDto.setDkyh(zyhk.get("DKYH").toString());
			zyhkData.add(zyhkDto);
		}
		map.put("zyhk", zyhkData);
		map.put("total", count);
		return map;
	}


	/**
	 * 计算公积金个贷欠款及罚息明细  逐月划扣上月与本月对比
	 * @param GRDKBM 个人贷款编码
	 * @param HKKXQ 还款宽限期 0 无宽限期 >1 相应天数 99 当月任意日还款
	 * @param JXFS 复利利息计算方式：0 单利计息 1 复利计息
	 * @param ZNJFX 是否计算滞纳金罚息: 0 不计算 1 计算
	 * @param FXBS 罚息倍数
	 * @param HKRQ 还款日期
	 * @return
	 * @throws IOException 
	 */
	public void  DRDK_QKMX(Date HKRQ,String zjzxdm,String dkyh,String kjqj){
		//本月个人贷款编号
		List<Map<String, Object>> grdkbmList = zhuYueHuaKouCheckDao.bYGRDKBM(zjzxdm, dkyh, kjqj);
		List<TMP_YW_GDHK_QKMX_WH> list1 = new ArrayList<>();
		List<ZhuYueHuakouCompareDto> zhuYueHuaKouData = new ArrayList<>();
		List<Map<String, Object>> sygjjpkjeList = new ArrayList<>();
		for (int i = 0; i < grdkbmList.size(); i++) {
			
				Map map1 = new HashMap();
				Map map2 = new HashMap();
				Map map3 = new HashMap();
				Map map4 = new HashMap();
				
				String grdkbm = String.valueOf(grdkbmList.get(i).get("GRDKBM"));
				//中心代码
				String zjzxd = zhuYueHuaKouCheckDao.ZJZXDM(grdkbm);
				map1.put("ZJZXDM", zjzxd);
				map1.put("YYWDDM", null);
				map1.put("TJYHBM", null);
				map1.put("YHBM", null);
				map1.put("ZTBM", null);
				map1.put("HKKXQ", "HKKXQ");
				
				map2.put("ZJZXDM", zjzxd);
				map2.put("YYWDDM", null);
				map2.put("TJYHBM", null);
				map2.put("YHBM", null);
				map2.put("ZTBM", null);
				map2.put("FLLX", "FLLX");
				
				map3.put("ZJZXDM", zjzxd);
				map3.put("YYWDDM", null);
				map3.put("TJYHBM", null);
				map3.put("YHBM", null);
				map3.put("ZTBM", null);
				map3.put("ZNJFX", "ZNJFX");
				
				map4.put("ZJZXDM", zjzxd);
				map4.put("YYWDDM", null);
				map4.put("TJYHBM", null);
				map4.put("YHBM", null);
				map4.put("ZTBM", null);
				map4.put("FXBS", "FXBS");
				
				zhuYueHuaKouCheckDao.HKKXQ(map1);
				zhuYueHuaKouCheckDao.FLLX(map2);
				zhuYueHuaKouCheckDao.ZNJFX(map3);
				zhuYueHuaKouCheckDao.FXBS(map4);
				
				String HKKXQ =  map1.get("result").toString();
				String FLLX = map2.get("result").toString();
				String ZNJFX =  map3.get("result").toString();
				String FXBS =map4.get("result").toString();
				try {
					list1 = transferDRDK_QKMX(grdkbm, HKKXQ, FLLX, ZNJFX, FXBS, HKRQ);
					sygjjpkjeList = zhuYueHuaKouCheckDao.sygjjpkje(zjzxdm, dkyh, kjqj);
					ZhuYueHuakouCompareDto zhuyuehuakou = new ZhuYueHuakouCompareDto();
					for (Map<String, Object> sy : sygjjpkjeList) {
						if (sy.get("GRDKBM")==grdkbm||sy.get("GRDKBM").equals(grdkbm)) {
							Double bj =Double.parseDouble(sy.get("BJ").toString());
							Double lx =Double.parseDouble(sy.get("LX").toString());
							Double fx =Double.parseDouble(sy.get("FX").toString());
							zhuyuehuakou.setSYBJ(bj);	
							zhuyuehuakou.setSYHKJE(bj+lx+fx);	
							zhuyuehuakou.setSYFX(fx);
							zhuyuehuakou.setSYLX(lx);
							break;
						}
					}
					for (TMP_YW_GDHK_QKMX_WH by : list1) {
						System.err.println(by.toString());
						zhuyuehuakou.setBJ(by.getBCBJ());
						zhuyuehuakou.setFX(by.getBCZNJ()+by.getBCFLLX()+by.getBCZNJLX());
						zhuyuehuakou.setHKJE(by.getBCBJ()+(by.getBCZNJ()+by.getBCFLLX()+by.getBCZNJLX())+by.getBCLX());
						zhuyuehuakou.setLX(by.getBCLX());
					}
					zhuyuehuakou.setJkrxm((String)(grdkbmList.get(i).get("JKRXM")));
					zhuyuehuakou.setJkhtbh((String)(grdkbmList.get(i).get("JKHTBH")));
					zhuyuehuakou.setJkrzjh((String)(grdkbmList.get(i).get("JKRZJH")));
					zhuyuehuakou.setDkyh((String)(grdkbmList.get(i).get("DKYH")));
					zhuyuehuakou.setZjzxdm((String)(grdkbmList.get(i).get("ZJZXDM")));
					zhuyuehuakou.setGrdkbm(grdkbm);
					zhuYueHuaKouData.add(zhuyuehuakou);
				
					if (zhuYueHuaKouData.size()>=500) {
						zhuYueHuaKouCheckDao.insertJKZYHK(zhuYueHuaKouData);
						zhuYueHuaKouData= new ArrayList<>();
					}
					if (i==(grdkbmList.size()-1)&&zhuYueHuaKouData.size()!=0) {
						zhuYueHuaKouCheckDao.insertJKZYHK(zhuYueHuaKouData);
					}
				} catch (IOException e) {
					e.printStackTrace();
				}							
				System.err.println(zhuYueHuaKouData.size());
		}	
		
	}

	/**
	 * 调用gdmx存储过程查询临时表
	 * @param GRDKBM 个人贷款编码
	 * @param HKKXQ 还款宽限期 0 无宽限期 >1 相应天数 99 当月任意日还款
	 * @param JXFS 复利利息计算方式：0 单利计息 1 复利计息
	 * @param ZNJFX 是否计算滞纳金罚息: 0 不计算 1 计算
	 * @param FXBS 罚息倍数
	 * @param HKRQ 还款日期
	 * @return
	 * @throws IOException 
	 */
	public List<TMP_YW_GDHK_QKMX_WH> transferDRDK_QKMX(String GRDKBM,String HKKXQ,String JXFS,String ZNJFX,String FXBS,Date HKRQ) throws IOException{
		String fileName ="mybatis.xml";
		//读取mybatis.xml文件
	    InputStream inputStream = Resources.getResourceAsStream(fileName); 
	    //初始化mybatis，创建sqlsessionFactory类的实例
	    SqlSessionFactory sqlSessionFactory = new SqlSessionFactoryBuilder().build(inputStream);
	    //创建session实例
	    SqlSession sqlSession = sqlSessionFactory.openSession(false);//通过这种方式打开的SqlSession，autoCommit默认为false，需要手动提交事务
	    //插入数据
	    DrdkQkmxDto drdkQkmxDto = new DrdkQkmxDto();
		drdkQkmxDto.setGrdkbm(GRDKBM);
		drdkQkmxDto.setHkkxq(HKKXQ);
		drdkQkmxDto.setJxfs(JXFS);
		drdkQkmxDto.setZnjfx(ZNJFX);
		drdkQkmxDto.setFxbs(FXBS);
		drdkQkmxDto.setHkrq(HKRQ);
		//第一个参数为方法的完全限定名:位置信息+映射文件当中的id
		sqlSession.selectList("com.changda.gjjapp.gedai.dao.zhuyuehuakou.ZhuYueHuaKouCheckDao.DRDK_QKMX", drdkQkmxDto);
		//循环查询临时表
		List<TMP_YW_GDHK_QKMX_WH> list2= sqlSession.selectList("com.changda.gjjapp.gedai.dao.zhuyuehuakou.ZhuYueHuaKouCheckDao.queryTMPGDHKQKMX");
		//提交事务
		sqlSession.commit();
		//关闭session
		sqlSession.close();
		//关闭io流
	    inputStream.close();
		return list2;
	}

	/**
	 * 查询资金中心代码
	 */
	@Override
	public String ZJZXDM(String GRDKBM) {
		return zhuYueHuaKouCheckDao.ZJZXDM(GRDKBM);
	}

	@Override
	public String HKKXQ(String ZJZXDM, String YYWDDM, String TJYHBM, String YHBM, String ZTBM, String XTCSBM) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String FLLX(String ZJZXDM, String YYWDDM, String TJYHBM, String YHBM, String ZTBM, String XTCSBM) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String ZNJFX(String ZJZXDM, String YYWDDM, String TJYHBM, String YHBM, String ZTBM, String XTCSBM) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String FXBS(String ZJZXDM, String YYWDDM, String TJYHBM, String YHBM, String ZTBM, String XTCSBM) {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * 查询个人贷款编码
	 */
	@Override
	public List<Map<String, Object>> bYGRDKBM(String zjzxdm, String dkyh,String kjqj) {
		
		return null;
	}
	
	
	/**
	 * 获取扣划人员比对列表用于展示
	 * 涉及表 gd_grdkzz、GD_GJJZDHDSQ、gd_gthkr
	 */
	@Override
	public List<ZhuYueHuakouCompareDto> getKouHuaRenYuanCompareList(String kjqj, int page, int limt) {
		
		return null; 
	}


	@Override
	public double getPKJE(String grdkbm, String kjqj) {
		return 0;
	}

	
	
	

	
	
}
