package com.changda.gjjapp.zhfwpt.homepage.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.cd4j.foundation.core.web.BaseController;
import com.changda.gjjapp.zhfwpt.dto.homepage.ComplaintRateDto;
import com.changda.gjjapp.zhfwpt.dto.homepage.LoginCountDto;
import com.changda.gjjapp.zhfwpt.dto.homepage.MydInfoDto;
import com.changda.gjjapp.zhfwpt.dto.homepage.SelectRCAndSl;
import com.changda.gjjapp.zhfwpt.dto.homepage.YwSortTop5Dto;
import com.changda.gjjapp.zhfwpt.qdxxgl.controller.QuDaoXinXiGuanLiController;
import com.changda.gjjapp.zhfwpt.service.homepage.HomePageService;

import ch.qos.logback.classic.Logger;

@Controller()
@RequestMapping(value = "/zhfwpt/homepage")
public class HomePageController extends BaseController {
	@Autowired
	private HomePageService homePageService;

	// 首页用户投诉率
	@RequestMapping("complaintRate")
	@ResponseBody
	public ResultDto complaintRate(HttpServletRequest request) {
		String year = request.getParameter("year");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(year);
		ResultDto resultDto = new ResultDto();
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			ComplaintRateDto data = homePageService.complaintRate(year);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 问卷调查插入
	@RequestMapping("insertWjdcInfo")
	@ResponseBody
	public ResultDto insertWjdcInfo(HttpServletRequest request) {
		// 渠道id
		String qdid = request.getParameter("qdid");
		// 用户名
		String username = request.getParameter("userName");
		// 个人账号
		String grzh = request.getParameter("grzh");
		// 投票选项（001.非常满意002.满意003.不满意）
		String tpxx = request.getParameter("tpxx");
		// 业务类型
		String ywlx = request.getParameter("ywlx");
		String data=qdid+username+grzh+tpxx+ywlx;
		ResultDto resultDto = null;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(data);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			try {
				resultDto = homePageService.insertWjdcInfo(tpxx, username, grzh, qdid, ywlx);
				resultDto.setSuccess(true);
			} catch (Exception e) {
				logger.error("错误信息为:" + e);
				resultDto.setSuccess(false);
			}
		}
		return resultDto;
	}

	// 办理业务排行前五的业务
	@RequestMapping("ywsortTop5")
	@ResponseBody
	public ResultDto ywsortTop5(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		List<YwSortTop5Dto> data = homePageService.ywsortTop5();
		resultDto.setData(data);
		resultDto.setSuccess(true);
		return resultDto;
	}

	// 满意度占比
	@RequestMapping("mydInfo")
	@ResponseBody
	public ResultDto mydInfo(HttpServletRequest request) {
		String year = request.getParameter("year");
		ResultDto resultDto = new ResultDto();
//		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(year);
//		if(a){
//			resultDto.setData(0);
//			resultDto.setMessage("存在sql注入");
//			resultDto.setSuccess(false);
//		}else{
			List<MydInfoDto> data = homePageService.mydInfo(year);
			resultDto.setData(data);
			resultDto.setSuccess(true);
//		}
		
		return resultDto;
	}

	// 各时间段各渠道登录次数
	@RequestMapping("loginCount")
	@ResponseBody
	public ResultDto loginCount(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		List<LoginCountDto> data = homePageService.loginCount();
		resultDto.setData(data);
		resultDto.setSuccess(true);
		return resultDto;
	}

	// 查询当天登录人次和登录次数
	@RequestMapping("selectRCAndSl")
	@ResponseBody
	public ResultDto selectRCAndSl(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		List<SelectRCAndSl> data = homePageService.selectRCAndSl();
		resultDto.setData(data);
		resultDto.setSuccess(true);
		return resultDto;
	}
}
