package com.changda.gjjapp.zhfwpt.yhxxgl.controller;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.zhfwpt.dto.yhxxgl.YhxxLoggingDto;
import com.changda.gjjapp.zhfwpt.dto.yhxxgl.YongHuXinXiSearchDto;
import com.changda.gjjapp.zhfwpt.qdxxgl.controller.QuDaoXinXiGuanLiController;
import com.changda.gjjapp.zhfwpt.service.yhxxgl.YHXXGLService;

@Controller
@RequestMapping(value = "/zhfwpt/yhxxgl")
public class YongHuXinXiGuanLiController {

	@Autowired
	private YHXXGLService YHXXGLService;

	// 用户密码重置
	@RequestMapping("updatePWD")
	@ResponseBody
	public ResultDto updatePWD(HttpServletRequest request) {

		String zjhm = request.getParameter("zjhm");
		String grzh = request.getParameter("grzh");
		String pwd = request.getParameter("pwd");
		String z=zjhm+grzh+pwd;
		boolean flag = false;
		if (grzh != null && !grzh.trim().equals("")) {
			flag = YHXXGLService.updatePwd(zjhm, grzh, pwd);
		} else {
			flag = false;
		}
		ResultDto resultDto = new ResultDto();
		resultDto.setData(flag);
		resultDto.setSuccess(true);
		return resultDto;
	}

	// 用户信息查询
	@RequestMapping("yongHuXinXiSearch")
	@ResponseBody
	public ResultDto yongHuXinXiSearch(HttpServletRequest request) {
		int page = Integer.parseInt(request.getParameter("page"));
		int limit = Integer.parseInt(request.getParameter("limit"));
		String data = request.getParameter("data");
		String zckssj = request.getParameter("zckssj");
		String zcjssj = request.getParameter("zcjssj");
		String dlkssj = request.getParameter("dlkssj");
		String dljssj = request.getParameter("dljssj");
		String yhlb = request.getParameter("yhlb");
		ResultDto resultDto = new ResultDto();
		String z=data+zckssj+zcjssj+dlkssj+dljssj+yhlb;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			Map<String, Object> yhxx = YHXXGLService.yongHuXinXiSearch(yhlb, data, zckssj, zcjssj, dlkssj, dljssj, page,
					limit);
			List<YongHuXinXiSearchDto> yhxxData = (List<YongHuXinXiSearchDto>) yhxx.get("yhxx");
			int total = (int) yhxx.get("total");
			resultDto.setTotal(total);
			resultDto.setData(yhxxData);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 修改用户信息
	@RequestMapping("userInfoUpdate")
	@ResponseBody
	public ResultDto userInfoUpdate(HttpServletRequest request) {
		// 个人账户
		String grzh = request.getParameter("grzh");
		// 性别
		String xingbie = request.getParameter("xingbie");
		// 姓名全拼
		String xmqp = request.getParameter("xmqp");
		// 出生年月
		String csny = request.getParameter("csny");
		ResultDto resultDto = YHXXGLService.userInfoUpdate(grzh, xingbie, xmqp, csny);
		return resultDto;
	}

	// 用户注销
	@RequestMapping("iszx")
	@ResponseBody
	public ResultDto iszx(HttpServletRequest request) {
		// 个人账户
		String grzh = request.getParameter("grzh");
		// 是否注销
		String iszx = request.getParameter("iszx");

		// 关闭类型
		String zxbz = request.getParameter("zxbz");
		ResultDto resultDto = YHXXGLService.iszx(grzh, iszx, zxbz);
		return resultDto;
	}

	// 用户登录记录
	@RequestMapping("userLoginRecording")
	@ResponseBody
	public ResultDto userLoginRecording(HttpServletRequest request) {
		// 个人账户
		String grzh = request.getParameter("grzh");
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(grzh);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			resultDto = YHXXGLService.userLoginRecording(grzh);
		}
		
		return resultDto;
	}

	// 用户信息日志记录
	@RequestMapping("yhxx_logging")
	@ResponseBody
	public ResultDto yhxx_logging(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 用户姓名
		String username = request.getParameter("username");
		// 操作人
		String czr = request.getParameter("czr");
		// 操作状态
		String czzt = request.getParameter("czzt");
		resultDto = YHXXGLService.yhxx_logging(username, czr, czzt);
		return resultDto;
	}

	// 用户信息日志查询
	@RequestMapping("yhxx_logging_select")
	@ResponseBody
	public ResultDto yhxx_logging_select(HttpServletRequest request) {
		int page = Integer.parseInt(request.getParameter("page"));
		int limit = Integer.parseInt(request.getParameter("limit"));

		ResultDto resultDto = new ResultDto();
		Map<String, Object> yhxx = YHXXGLService.yhxx_logging_select(page, limit);

		List<YhxxLoggingDto> yhxxData = (List<YhxxLoggingDto>) yhxx.get("yhxxLogging");
		int total = (int) yhxx.get("total");
		resultDto.setTotal(total);
		resultDto.setData(yhxxData);
		resultDto.setSuccess(true);
		return resultDto;
	}
}
