package com.changda.gjjapp.zhfwpt.dao.qdxxgl;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import com.changda.cd4j.foundation.core.persistence.annotation.MyBatisDao;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.GqdmenwomenblDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.ManWomenZBDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdfwlTjDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdfwnldTjDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdgsjdTJDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdgzxzlTjDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdywfwlDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdywzbDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoFWLZBDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.TdqdblyhZBDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.TdqdywblZBDTO;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.TslvDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.WanWomanZBDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.XinXiTuiSongDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.YwblCGSBDBLvDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.YwblTypeZBSLDto;
import com.changda.gjjapp.zhfwpt.dto.qdywqxgl.QuDaoQuanXianGuanLiDto;

@MyBatisDao
public interface QuDaoXinXiGuanLiDao {
    /**
     * 业务访问详情表插入
     *
     * @param qdid     渠道id
     * @param ywid     业务编号
     * @param userName 用户名称
     */
    int insertYWFWXQ(@Param("qdid") String qdid, @Param("ywid") String ywid, @Param("userName") String userName,@Param("grzh")String grzh,@Param("zjzxid")String zjzxid,@Param("zjzxmc")String zjzxmc);

    /**
     * 渠道访问详情表插入
     *
     * @param qdid     渠道id
     * @param userName 用户名称
     * @param grzh      个人账号
     */
    int insertQDFWXQ(@Param("qdid") String qdid, @Param("userName") String userName,@Param("grzh")String grzh,@Param("zjzxid")String zjzxid,@Param("zjzxmc")String zjzxmc);

    /**
     * 渠道业务访问量 按年月日查
     *
     * @param date 日期
     * @return
     */
    List<QdywfwlDto> qdywfwlData(@Param("qssj") String qssj, @Param("zzsj") String zzsj);


    /**
     * 渠道业务访问量 按年月查
     *
     * @param date 日期
     * @return
     */
    List<QdywfwlDto> qdywfwlDataTwo(@Param("qssj") String qssj, @Param("zzsj") String zzsj);
    
    /**
     * 短信发送量
     */
    int dxfsl();
    
    /**
     * 渠道访问量占比
     * @return
     */
    List<QuDaoFWLZBDto> qdfwlZB(@Param("year")String year);

    
    /**
     * 渠道业务访问
     * @return
     */
    List<Map<String, Object>> qdywfw(@Param("qssj") String qssj, @Param("zzsj") String zzsj,@Param("ywfl")String ywfl,@Param("grzh") String grzh);
    
    /**
     * 渠道业务访问统计分析图
     * @return
     */
    List<Map<String, Object>> qdfwtjfxt(@Param("year")String year,@Param("ywfl")String ywfl,@Param("grzh") String grzh);
    
    /**
     * 渠道业务办理统计
     * @return
     */
    List<Map<String, Object>> qdywbltj(@Param("qssj") String qssj, @Param("zzsj") String zzsj,@Param("grzh")String grzh,@Param("ywfl")String ywfl);
    
    /**
     * 
     * 渠道用户统计分析
     * @return
     */
    List<Map<String, Object>> qdyhtjfx();
    
    /**
     * 渠道用户信息统计活动用户
     * @param year
     * @return
     */
    int qdyhfxHDYH(@Param("year")String year,@Param("qdid")String qdid);
    
    /**
     * 渠道用户信息统计注册用户
     * @param year
     * @return
     */
    int qdyhfxZCS(@Param("year")String year,@Param("qdid")String qdid);
    
    /**
     * 插入渠道访问量数据用于统计分析
     * @param qdid
     * @param sj
     * @return
     */
    int insertQDFWL(@Param("qdid")String qdid,@Param("sj")String sj,@Param("fwsl")String fwsl,@Param("fwnf")String fwnf,@Param("fwyf")String fwyf);
    
    /**
     * 查询渠道访问量数据用于统计分析
     * @return
     */
    int sreachQDFWL(@Param("qdid")String qdid,@Param("sj")String sj);
    
    /**
     * 渠道各时间段统计
     * @param year 年份
     * @return 
     */
    List<QdgsjdTJDto> qdgsjdTj(@Param("year")String year);
    
    /**
     * 渠道各年龄段访问统计
     * @param year
     * @return
     */
    List<QdfwnldTjDto> qdfwnldTj(@Param("year")String year);
    
    /**
     * 渠道各年龄段业务访问统计
     * @param year
     * @param ywbm
     * @return
     */
    List<QdfwnldTjDto> qdywnldfwtj(@Param("ywbm")String ywbm,@Param("qssj")String qssj,@Param("zzsj")String zzsj);
    
    /**
     * 渠道业务各时间段统计
     * @param ywbm
     * @param qssj
     * @param zzsj
     * @return
     */
    List<QdgsjdTJDto> qdywgsjdtj(@Param("ywbm")String ywbm,@Param("qssj")String qssj,@Param("zzsj")String zzsj);
    
    /**
     * 渠道访问量统计
     * @param ywbm
     * @param qssj
     * @param zzsj
     * @return
     */
    List<QdfwlTjDto> qdfwlTj(@Param("qdid")String qdid,@Param("year")String year);
    
    /**
     * 渠道下载量关注量访问量统计
     * @param qdid
     * @param year
     * @return
     */
    List<QdgzxzlTjDto> qdgzxzlTj(@Param("qdid")String qdid,@Param("year")String year);
    
    /**
     * 热线接听量
     */
    List<QdfwlTjDto> rxtj(@Param("year")String year);
    
    /**
     * 门户网站点击量
     * @param year
     * @return
     */
    List<QdfwlTjDto> wztj(@Param("year")String year);
    
    /**
     * 短信统计
     */
    List<QdfwlTjDto> dxtj(@Param("year")String year);
    
    /**
     * 各渠道注册男女比例占比
     * @return
     */
    List<GqdmenwomenblDto> gqdmenwomenbl();
    
    /**
     * 各渠道信息推送量统计
     * @param year 年饭
     */
    List<XinXiTuiSongDto> xinXiTuiSongTJ(@Param("year")String year);
    
    /**
     * 阀值控制
     * @param qdid
     * @return
     */
    QuDaoQuanXianGuanLiDto faZhiKongZhi(@Param("qdid")String qdid);
    
    /**
     * 注销被锁定总人数
     * @return
     */
    int userLogoutStatus();
    
    /**
     * 男女比例
     * @return
     */
    WanWomanZBDto wanWomanZB();
    
    /**
     * 渠道业务占比
     * @return
     */
    QdywzbDto qdywzb(@Param("year")String year,@Param("month")String month,@Param("ywlx")String ywlx);
    
    /**
     * 注册用户年龄分析
     * @return
     */
    QdfwnldTjDto zcyhnlFX();
    
    /**
     * 活动用户年龄分析
     * @return
     */
    QdfwnldTjDto hdyhnlfx();
    
    /**
     * 各渠道办理成功失败代办率
     * @param year
     * @param month
     * @return
     */
    List<YwblCGSBDBLvDto> ywblCGSBDBlv(@Param("year")String year,@Param("month")String month,@Param("qdid")String qdid);
    
    /**
     * 业务办理类型 占比数量
     * @param qdid
     * @return
     */
    YwblTypeZBSLDto ywblTypeZBSL(@Param("year")String year,@Param("month")String month,@Param("qdid")String qdid);
    
    /**
     * 投诉率
     * @param year
     * @return
     */
    TslvDto tslv(@Param("year")String year);
    
    /**
     * 用户分布情况
     * @param year
     * @param month
     * @param qdid
     * @return
     */
    TdqdblyhZBDto tdqdblyhZB(@Param("year")String year,@Param("month")String month,@Param("qdid")String qdid);
    
    /**
     * 渠道分布情况
     * @param year
     * @param month
     * @param qdid
     * @return
     */
    TdqdywblZBDTO tdqdywblZB(@Param("year")String year,@Param("month")String month,@Param("qdid")String qdid);
    
    /**
     * 男女活动用户占比
     * @return
     */
    ManWomenZBDto nanlvhdyhZB();
    
    /**
     * 男女注册用户占比
     * @return
     */
    ManWomenZBDto nanlvzcyhZB();
}
