package com.changda.gjjapp.zhfwpt.dao.tyfb;

import java.util.Date;
import java.util.List;
import java.util.Map;
import com.changda.gjjapp.db.entity.M_XWINFO;
import com.changda.gjjapp.zhfwpt.dto.tyfb.TyfbLoggingDto;
import com.changda.gjjapp.zhfwpt.dto.tyfb.UpdateNumDto;
import com.changda.gjjapp.zhfwpt.dto.tyfb.UpdateStatisticsDto;

import org.apache.ibatis.annotations.Param;
import com.changda.cd4j.foundation.core.persistence.annotation.MyBatisDao;

@MyBatisDao
public interface TyfbInfoDao {
	/**
	 * 插入父级栏目
	 * @param lanmuid 栏目id
	 * @param lanmuName 栏目名称
	 * @param parentid 上级栏目id
	 * @return
	 */
	String insertFJLanMu(@Param("lanmuid")String lanmuid,@Param("lanmuName")String lanmuName,@Param("parentid")String parentid);
	
	/**
	 * 树形列表的结构数据
	 * @return
	 */
	List<Map<String, Object>> lanmuJG();
	
	/**
	 * 插入栏目内容
	 */
	int insertLanMuContent(M_XWINFO m_xwinfo);
	
	/**
	 * 循环插入文章
	 * @param m_xwinfo
	 */
	int insertContent(M_XWINFO m_xwinfo);
	
	/**
	 * 查询需要插入文章内容的栏目
	 * @return
	 */
	List<Map<String, Object>> searchLanmu();
	
	
	/**
	 * 查询文章内容
	 * @param map
	 * @return
	 */
	List<Map<String,Object>> query(@Param("lanmuid")String lanmuid,@Param("title")String title,@Param("issh")String issh,@Param("qssj")String qssj,@Param("zzsj")String zzsj);

	/**
	 * 编辑页面栏目下拉框
	 * @param lanmuid
	 * @return
	 */
	List<Map<String, Object>> lanmuXiaLa(@Param("lanmuid")String lanmuid);
	
	//删除文章内容
	int deleteWz(@Param("i_id")String i_id);
	
	//修改文章内容
	int updateWZ(@Param("vc_title")String vc_title,@Param("i_cataid")String i_cataid,@Param("vc_cataname")String vc_cataname,@Param("iswz")String iswz,@Param("isapp")String isapp,@Param("iswx")String iswx,@Param("isznzd")String isznzd,@Param("issh")String issh,@Param("vc_author")String vc_author,@Param("c_deploytime")String c_deploytime,@Param("vc_content")String vc_content,@Param("i_id")String i_id,@Param("operator")String operator,@Param("vc_source")String vc_source,@Param("isfsgwz")int isfsgwz,@Param("lbt")String lbt,@Param("yyfssj")String yyfssj,@Param("isyyfs")String isyyfs,@Param("vc_editor")String vc_editor);
	
	//根据id查询文章内容
	List<Map<String, Object>> searchWZ(@Param("i_id")String i_id);
	
	//查询文章是否发送过网站
	String isfsgwz(@Param("i_id")String i_id);
	
	//查询文章信息
	List<Map<String, Object>> sreachInfo(@Param("i_id")String i_id);
	
	int updateFSG(@Param("i_id")String i_id,@Param("isfsgwz")String isfsgwz);
	
	//更新新闻内容
	int updateLanmuInfo(M_XWINFO m_XWINFO);
	
	//修改审核状态
	int updateISSH(@Param("i_id")String i_id,@Param("issh")String issh);
	
	//获取栏目更新状态
	int getLanMuState(@Param("lanmuid")String lanmuid);
	
	//更新栏目更新状态
	int isUpdate(@Param("lanmuid")String lanmuid,@Param("isupdate")String isupdate);
	
	//查询各渠道栏目内容的更新
	List<UpdateNumDto> sreachUpdateContentNum(@Param("year")String year);
	
	//栏目更新量统计
	List<UpdateStatisticsDto> updateStatistics(@Param("time")String time); 
	
	//查询需要预约发送的文章
	List<String> nendSendArticle();
	
	//修改预约状态
	int updateIsyyfs(@Param("i_id")String i_id);
	
	//统一发布日志记录
	int logging_tyfb(@Param("lanmuid")String lanmuid,@Param("iswx")String iswx,@Param("iswz")String iswz,@Param("isapp")String isapp,@Param("isznzd")String isznzd,@Param("xwly")String xwly,@Param("zz")String zz,@Param("xwsj")String xwsj,@Param("czr")String czr,@Param("czzt")String czzt);

	/**
	 * 统一发布日志记录
	 * @return
	 */
	List<TyfbLoggingDto> logging_tyfb_select();

}
