package com.changda.gjjapp.zhfwpt.service.homepage;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.zhfwpt.dto.homepage.ComplaintRateDto;
import com.changda.gjjapp.zhfwpt.dto.homepage.LoginCountDto;
import com.changda.gjjapp.zhfwpt.dto.homepage.MydInfoDto;
import com.changda.gjjapp.zhfwpt.dto.homepage.SelectRCAndSl;
import com.changda.gjjapp.zhfwpt.dto.homepage.YwSortTop5Dto;

/**
 * 综合服务平台后台管理首页接口
 * @author Administrator
 *
 */
public interface HomePageService {
	/**
	 * 首页用户投诉率
	 * @return
	 */
	ComplaintRateDto complaintRate(String year);
	
	/**
	 * 问卷调查插入
	 * @param tpxx 投票选项
	 * @param username 用户名
	 * @param grzh 个人账号
	 * @param qdid 渠道id
	 * @return
	 */
	ResultDto insertWjdcInfo(String tpxx,String username,String grzh,String qdid,String ywlx);
	
	/**
	 * 查询业务办理中前五的数据
	 * @return
	 */
	List<YwSortTop5Dto> ywsortTop5();
	
	/**
	 * 满意度调查占比
	 */
	List<MydInfoDto> mydInfo(String year);
	
	/**
	 * 各时间段各渠道登录次数
	 * @return
	 */
	List<LoginCountDto> loginCount();
	
	/**
	 * 查询当天登录人次和登录次数
	 * @return
	 */
	List<SelectRCAndSl> selectRCAndSl();
}
