package com.changda.gjjapp.zhfwpt.service.impl.qdxxgl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;

import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.changda.gjjapp.zhfwpt.dao.qdxxgl.QuDaoXinXiGuanLiDao;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.GqdmenwomenblDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.ManWomenZBDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdfwlTjDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdfwnldTjDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdgsjdTJDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdgzxzlTjDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdywfwlDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdywzbDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoFWLZBDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoYHTJDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoYeWuBanLiTongJiDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoYeWuFWDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoYongHuTongJiDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.TdqdblyhZBDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.TdqdywblZBDTO;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.TslvDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.WanWomanZBDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.XinXiTuiSongDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.YwblCGSBDBLvDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.YwblTypeZBSLDto;
import com.changda.gjjapp.zhfwpt.dto.qdywqxgl.QuDaoQuanXianGuanLiDto;
import com.changda.gjjapp.zhfwpt.service.qdxxgl.QuDaoXinXiGuanLiService;

@Service()
public class QuDaoXinXiGuanLiServiceImp implements QuDaoXinXiGuanLiService {

	@Autowired
	private QuDaoXinXiGuanLiDao QuDaoXinXiGuanLiDao;

	// 业务访问详情表插入
	@Override
	@SuppressWarnings( "unchecked" )
	public int insertYWFWXQ(String data) {
		Map<String, Object> map = JSON.parseObject(data, Map.class);
		// 渠道id
		String qdid = map.get("qdid").toString();
		// 业务编号
		String ywid = map.get("ywid").toString();
		// 用户名称
		String userName = map.get("userName").toString();
		// 个人账号
		String grzh = map.get("grzh").toString();
		String zjzxid = map.get("zjzxid").toString();
		String zjzxmc = map.get("zjzxmc").toString();
		int num = QuDaoXinXiGuanLiDao.insertYWFWXQ(qdid, ywid, userName, grzh,zjzxid,zjzxmc);

		if (num > 0) {
			return 1;
		} else {
			return 0;
		}
	}

	// 渠道访问详情表插入
	@Override
	@SuppressWarnings( "unchecked" )
	public int insertQDFWXQ(String data) {
		Map<String, Object> map = JSON.parseObject(data, Map.class);
		String qdid = map.get("qdid").toString();
		String userName = map.get("userName").toString();
		String grzh = map.get("grzh").toString();
		String zjzxid = map.get("zjzxid").toString();
		String zjzxmc = map.get("zjzxmc").toString();
		int num = QuDaoXinXiGuanLiDao.insertQDFWXQ(qdid, userName, grzh,zjzxid,zjzxmc);
		QuDaoQuanXianGuanLiDto  dto = QuDaoXinXiGuanLiDao.faZhiKongZhi(qdid);
		int zxrs = Integer.parseInt(dto.getMfzrs()); 
		int fz = Integer.parseInt(dto.getFz());
		if (zxrs >= fz) {
			return 1;
		} else {
			return 0;
		}
	}

	// 渠道业务访问量
	@Override
	public List<QdywfwlDto> qdywfwlData(String qssj, String zzsj, String num) {
		List<QdywfwlDto> data = null;
		if (num.trim().equals("01") || num.trim() == "01") {
			// 按照年月查
			data = QuDaoXinXiGuanLiDao.qdywfwlDataTwo(qssj, zzsj);
		} else if (num.equals("02") || num.trim() == "02") {
			// 按照年月日查
			data = QuDaoXinXiGuanLiDao.qdywfwlData(qssj, zzsj);
		}
		List<QdywfwlDto> list = new ArrayList<>();
//		for (Map<String, Object> qdfwl : data) {
//			QdywfwlDto qDto = new QdywfwlDto();
//			qDto.setMc(qdfwl.get("MC").toString());
//			qDto.setAppCount(Integer.parseInt(qdfwl.get("APP").toString()));
//			qDto.setGmCount(Integer.parseInt(qdfwl.get("GM").toString()));
//			qDto.setWxCount(Integer.parseInt(qdfwl.get("WX").toString()));
//			qDto.setWtCount(Integer.parseInt(qdfwl.get("WT").toString()));
//			list.add(qDto);
//		}
		return data;
	}

	// 渠道访问量占比
	@Override
	public List<QuDaoFWLZBDto> qdfwlZB(String year) {
		List<QuDaoFWLZBDto> data = QuDaoXinXiGuanLiDao.qdfwlZB(year);
		return data;
	}

	// 渠道业务访问
	@Override
	public List<QuDaoYeWuFWDto> qdywfw(String qssj, String zzsj,String ywfl,String grzh) {
		List<Map<String, Object>> data = QuDaoXinXiGuanLiDao.qdywfw(qssj, zzsj,ywfl,grzh);
		List<QuDaoYeWuFWDto> list = new ArrayList<QuDaoYeWuFWDto>();
		for (Map<String, Object> map : data) {
			QuDaoYeWuFWDto qDto = new QuDaoYeWuFWDto();
			qDto.setBm(map.get("YWBM").toString());
			qDto.setYwmc(map.get("YWMC").toString());

			qDto.setWtsl(map.get("WTSL").toString());
			String wtzb = map.get("WTZB").toString();
			if (wtzb.subSequence(0, 1).equals(".")) {
				wtzb = "0" + wtzb;
			}

			if (wtzb.equals("%")) {
				String wtzb2 = "0%";
				qDto.setWtzb(wtzb2);
			} else {
				qDto.setWtzb(wtzb);
			}

			qDto.setWxsl(map.get("WXSL").toString());
			String wxzb = map.get("WXZB").toString();
			if (wxzb.subSequence(0, 1).equals(".")) {
				wxzb = "0" + wxzb;
			}

			if (wxzb.equals("%")) {
				String wxzb2 = "0%";
				qDto.setWxzb(wxzb2);
			} else {
				qDto.setWxzb(wxzb);
			}

			qDto.setSjsl(map.get("SJSL").toString());
			String sjzb = map.get("SJZB").toString();
			if (sjzb.subSequence(0, 1).equals(".")) {
				sjzb = "0" + sjzb;
			}
			if (sjzb.equals("%")) {
				String sjzb2 = "0%";
				qDto.setSjzb(sjzb2);
			} else {
				qDto.setSjzb(sjzb);
			}
			
			qDto.setZnzdsl(map.get("ZNZDSL").toString());
			String znzdzb = map.get("ZNZDZB").toString();
			if (znzdzb.subSequence(0, 1).equals(".")) {
				znzdzb = "0" + znzdzb;
			}
			if (znzdzb.equals("%")) {
				String znzdzb2 = "0%";
				qDto.setZnzdzb(znzdzb2);
			} else {
				qDto.setZnzdzb(znzdzb);
			}
			
			int wt = Integer.parseInt(map.get("WTSL").toString());
			int wx = Integer.parseInt(map.get("WXSL").toString());
			int app = Integer.parseInt(map.get("SJSL").toString());
			int znzdsl = Integer.parseInt(map.get("ZNZDSL").toString());
			
			
			int zsl = wt + wx + app+znzdsl;
			String zsl2 = zsl+"";
			qDto.setZsl(zsl2);
			list.add(qDto);
		}

		return list;
	}

	// 渠道业务办理统计
	@Override
	public List<QuDaoYeWuBanLiTongJiDto> qdywbltj(String qssj, String zzsj,String grzh,String ywfl) {
		List<Map<String, Object>> data = QuDaoXinXiGuanLiDao.qdywbltj(qssj, zzsj,grzh,ywfl);
		List<QuDaoYeWuBanLiTongJiDto> list = new ArrayList<QuDaoYeWuBanLiTongJiDto>();
		
		//办理总数量
		int blzsl = 0;
		//成功总数量
		int cgzsl = 0;
		//失败总数量
		int sbzsl = 0;
		//处理中总数量
		int clzzsl = 0;
		QuDaoYeWuBanLiTongJiDto qDto2 = new QuDaoYeWuBanLiTongJiDto();
		
		for (Map<String, Object> map : data) {
			blzsl = blzsl + Integer.parseInt(map.get("BLCS").toString());
			cgzsl = cgzsl + Integer.parseInt(map.get("CGSL").toString());
			sbzsl = sbzsl + Integer.parseInt(map.get("SBSL").toString());
			clzzsl = clzzsl + Integer.parseInt(map.get("CLZSL").toString());
			
			QuDaoYeWuBanLiTongJiDto qDto = new QuDaoYeWuBanLiTongJiDto();
			qDto.setBlcs(map.get("BLCS").toString());
			qDto.setYwbm(map.get("YWBM").toString());
			qDto.setYwmc(map.get("YWMC").toString());
			qDto.setCgsl(map.get("CGSL").toString());
			String cgzb = map.get("CGZB").toString();
			if (cgzb.subSequence(0, 1).equals(".")) {
				cgzb = "0" + cgzb;
			}
			if (cgzb.equals("%")) {
				qDto.setCgzb("0%");
			} else {
				qDto.setCgzb(cgzb);
			}

			qDto.setSbsl(map.get("SBSL").toString());
			String sbzb = map.get("SBZB").toString();
			if (sbzb.subSequence(0, 1).equals(".")) {
				sbzb = "0" + sbzb;
			}
			if (sbzb.equals("%")) {
				qDto.setSbzb("0%");
			} else {
				qDto.setSbzb(sbzb);
			}

			qDto.setClzsl(map.get("CLZSL").toString());
			String clzzb = map.get("CLZZB").toString();
			if (clzzb.subSequence(0, 1).equals(".")) {
				clzzb = "0" + clzzb;
			}
			if (clzzb.equals("%")) {
				qDto.setClzzb("0%");
			} else {
				qDto.setClzzb(clzzb);
			}
			list.add(qDto);
			
		}
		qDto2.setBlzsl(blzsl);
		qDto2.setCgzsl(cgzsl);
		qDto2.setSbzsl(sbzsl);
		qDto2.setClzzsl(clzzsl);
		list.add(qDto2);
		return list;
	}

	// 渠道用户统计分析
	@Override
	public List<QuDaoYHTJDto> qdyhtjfx() {
		List<Map<String, Object>> data = QuDaoXinXiGuanLiDao.qdyhtjfx();
		List<QuDaoYHTJDto> list = new ArrayList<QuDaoYHTJDto>();
		for (Map<String, Object> map : data) {
			QuDaoYHTJDto qDto = new QuDaoYHTJDto();
			qDto.setQdid(map.get("QDID").toString());
			qDto.setQdmc(map.get("QDMC").toString());
			qDto.setZcyh(map.get("ZCYH").toString());
			String zczb = map.get("ZCZB").toString();
			if (zczb.subSequence(0, 1).equals(".")) {
				zczb = "0" + zczb;
			}
			if (zczb.equals("%")) {
				qDto.setZczb("0%");
			} else {
				qDto.setZczb(zczb);
			}

			qDto.setHdyh(map.get("HDYH").toString());
			String hdzb = map.get("HDZB").toString();
			if (hdzb.subSequence(0, 1).equals(".")) {
				hdzb = "0" + hdzb;
			}
			if (hdzb.equals("%")) {
				qDto.setHdzb("0%");
			} else {
				qDto.setHdzb(hdzb);
			}
			
			
			qDto.setHdyhzb1(map.get("HDYHZB1").toString());
			String hdzb2 = map.get("HDYHZB2").toString();
			if (hdzb2.subSequence(0, 1).equals(".")) {
				hdzb2 = "0" + hdzb2;
			}
			if (hdzb2.equals("%")) {
				qDto.setHdyhzb2("0%");
			} else {
				qDto.setHdyhzb2(hdzb2);
			}
			
			list.add(qDto);
		}

		return list;
	}

	// 渠道用户统计活动用户和注册用户
	@Override
	public List<QuDaoYongHuTongJiDto> qdyhtjZCAndHDYH(String year, String qdid) {
		// 一年的注册用户
		List<QuDaoYongHuTongJiDto> list = new ArrayList<QuDaoYongHuTongJiDto>();
		// 获取当前年份、月份、日期  
        Calendar cale = null;  
        cale = Calendar.getInstance(); 
		for (int i = 1; i <= 12; i++) {
			QuDaoYongHuTongJiDto qDto = new QuDaoYongHuTongJiDto();
			String s = String.format("%02d", i);
			String years = year + "-" + s;
			int zyi = QuDaoXinXiGuanLiDao.qdyhfxZCS(years, qdid);
			int hyi = QuDaoXinXiGuanLiDao.qdyhfxHDYH(years, qdid);
			int month = cale.get(Calendar.MONTH) + 1; 
			qDto.setMonth(i);
			if (i<=month) {
				qDto.sethCount(hyi);
			}else{
				qDto.sethCount(0);
			}
			qDto.setzCount(zyi);
			list.add(qDto);
		}
		return list;
	}

	// 渠道业务访问量插入上月的数据用于统计分析
	@Override
	public void qdywfwlInsertTjfx() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
		Date date = new Date();
		// 年份
		String year = null;
		year = sdf.format(date);
		SimpleDateFormat sdf2 = new SimpleDateFormat("MM");
		try {
			Date date2 = new Date();
			String m = sdf2.format(date2);
			// System.out.println("month:"+m);
			Date currdate = sdf2.parse(m);
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(currdate);
			calendar.set(Calendar.MONTH, calendar.get(Calendar.MONDAY) - 1);
			// 月份
			String month = sdf2.format(calendar.getTime());
			if (m.equals("01")) {
				Date y = sdf.parse(year);
				Calendar calendar2 = Calendar.getInstance();
				calendar2.setTime(y);
				calendar2.set(Calendar.YEAR, calendar2.get(Calendar.YEAR) - 1);
				year = sdf.format(calendar2.getTime());
			}
			String sj = year + month;
			String appCount = "" + (QuDaoXinXiGuanLiDao.sreachQDFWL("06", sj));
			String wxCount = "" + (QuDaoXinXiGuanLiDao.sreachQDFWL("05", sj));
			String wtCount = "" + (QuDaoXinXiGuanLiDao.sreachQDFWL("02", sj));

			QuDaoXinXiGuanLiDao.insertQDFWL("06", sj, appCount, year, month);
			QuDaoXinXiGuanLiDao.insertQDFWL("05", sj, wxCount, year, month);
			QuDaoXinXiGuanLiDao.insertQDFWL("02", sj, wtCount, year, month);
		} catch (ParseException e) {
			e.printStackTrace();
		}
	}

	//业务访问统计分析图
	@Override
	public List<QuDaoYeWuFWDto> qdfwtjfxt(String year,String ywfl,String grzh) {
		List<Map<String, Object>> data = QuDaoXinXiGuanLiDao.qdfwtjfxt(year, ywfl, grzh);
		List<QuDaoYeWuFWDto> list = new ArrayList<QuDaoYeWuFWDto>();
		//网厅数量
		int wt = 0;
		//微信数量
		int wx = 0;
		//手机app数量
		int app = 0;
		for (Map<String, Object> map : data) {
			QuDaoYeWuFWDto qDto = new QuDaoYeWuFWDto();
			qDto.setBm(map.get("YWBM").toString());
			qDto.setYwmc(map.get("YWMC").toString());
			if (map.get("WTSL")==null) {
				qDto.setWtsl("0");
				wt = 0;
			}else {
				wt = Integer.parseInt(map.get("WTSL").toString());
				qDto.setWtsl(map.get("WTSL").toString());
			}
			if (map.get("WXSL")==null) {
				wx = 0;
				qDto.setWxsl("0");
			}else {
				wt = Integer.parseInt(map.get("WXSL").toString());
				qDto.setWxsl(map.get("WXSL").toString());
			}
			if (map.get("SJSL")==null) {
				app = 0;
				qDto.setSjsl("0");
			}else {
				app = Integer.parseInt(map.get("SJSL").toString());
				qDto.setSjsl(map.get("SJSL").toString());
			}

			int zsl = wt + wx + app;
			String zsl2 = zsl+"";
			qDto.setZsl(zsl2);
			list.add(qDto);
		}
		return list;
	}

	//渠道各时间段统计
	@Override
	public List<QdgsjdTJDto> qdgsjdTj(String year) {
		return QuDaoXinXiGuanLiDao.qdgsjdTj(year);
	}

	//渠道各年龄段访问统计
	@Override
	public List<QdfwnldTjDto> qdfwnldTj(String year) {
		
		return QuDaoXinXiGuanLiDao.qdfwnldTj(year);
	}

	//渠道各年龄段业务访问统计
	@Override
	public List<QdfwnldTjDto> qdywnldfwtj( String ywbm,String qssj,String zzsj) {
		
		return QuDaoXinXiGuanLiDao.qdywnldfwtj(ywbm,qssj,zzsj);
	}

	//渠道业务各时间段统计
	@Override
	public List<QdgsjdTJDto> qdywgsjdtj(String ywbm, String qssj, String zzsj) {
		
		return QuDaoXinXiGuanLiDao.qdywgsjdtj(ywbm, qssj, zzsj);
	}

	//渠道访问量统计
	@Override
	public List<QdfwlTjDto> qdfwlTj(String qdid, String year) {
		List<QdfwlTjDto> data = null;
		if (qdid.equals("03")) {
			data = QuDaoXinXiGuanLiDao.rxtj(year);
		}else if (qdid.equals("04")) {
			data = QuDaoXinXiGuanLiDao.dxtj(year);
		}else if (qdid.equals("01")) {
			data = QuDaoXinXiGuanLiDao.wztj(year);
		}else {
			data = QuDaoXinXiGuanLiDao.qdfwlTj(qdid, year);
		}
		return data;
	}

	//渠道下载量关注量访问量统计
	@Override
	public List<QdgzxzlTjDto> qdgzxzlTj(String qdid, String year) {
		
		return QuDaoXinXiGuanLiDao.qdgzxzlTj(qdid, year);
	}

	//各渠道注册男女比例占比
	@Override
	public List<GqdmenwomenblDto> gqdmenwomenbl() {
		return QuDaoXinXiGuanLiDao.gqdmenwomenbl();
	}

	//各渠道信息推送量统计
	@Override
	public List<XinXiTuiSongDto> xinXiTuiSongTJ(String year) {
		
		return QuDaoXinXiGuanLiDao.xinXiTuiSongTJ(year);
	}

	//注销被锁定总人数
	@Override
	public int userLogoutStatus() {
		
		return QuDaoXinXiGuanLiDao.userLogoutStatus();
	}
	
	//男女占比
	@Override
	public WanWomanZBDto wanWomanZB() {
		return QuDaoXinXiGuanLiDao.wanWomanZB();
	}
	
	//渠道业务占比
	@Override
	public QdywzbDto qdywzb(String year, String month, String ywlx) {
		// TODO Auto-generated method stub
		return QuDaoXinXiGuanLiDao.qdywzb( year, month, ywlx);
	}

	//注册用户年龄段分析
	@Override
	public QdfwnldTjDto zcyhnlFX() {
		// TODO Auto-generated method stub
		return QuDaoXinXiGuanLiDao.zcyhnlFX();
	}

	//各渠道办理成功失败代办率
	@Override
	public List<YwblCGSBDBLvDto> ywblCGSBDBlv(String year, String month,String qdid) {
		// TODO Auto-generated method stub
		return QuDaoXinXiGuanLiDao.ywblCGSBDBlv(year, month,qdid);
	}

	//业务办理类型 占比数量
	@Override
	public List<YwblTypeZBSLDto> ywblTypeZBSL(String year,String month,String qdid) {
		List<YwblTypeZBSLDto> list = new ArrayList<YwblTypeZBSLDto>();
		if (qdid.equals("00")) {
			YwblTypeZBSLDto dto1 = QuDaoXinXiGuanLiDao.ywblTypeZBSL(year,month,"02");
			list.add(dto1);
			YwblTypeZBSLDto dto2 =QuDaoXinXiGuanLiDao.ywblTypeZBSL(year,month,"05");
			list.add(dto2);
			YwblTypeZBSLDto dto3 =QuDaoXinXiGuanLiDao.ywblTypeZBSL(year,month,"06");
			list.add(dto3);
		}else {
			YwblTypeZBSLDto dto = QuDaoXinXiGuanLiDao.ywblTypeZBSL(year,month,qdid);
			list.add(dto);
		}
		return list;
	}

	// 投诉率
	@Override
	public TslvDto tslv(String year) {
		// TODO Auto-generated method stub
		return QuDaoXinXiGuanLiDao.tslv(year);
	}

	//用户分布情况 特定渠道用户业务办理数
	@Override
	public TdqdblyhZBDto tdqdblyhZB(String year, String month, String qdid) {
		// TODO Auto-generated method stub
		return QuDaoXinXiGuanLiDao.tdqdblyhZB(year, month, qdid);
	}

	//渠道分布情况
	@Override
	public TdqdywblZBDTO tdqdywblZB(String year, String month, String qdid) {
		// TODO Auto-generated method stub
		return QuDaoXinXiGuanLiDao.tdqdywblZB(year, month, qdid);
	}

	//用户分析活动用户的年龄段和活动用户和注册用户占比
	@Override
	public Map<String, Object> userFBNLD(String num) {
		Map<String, Object> map = new HashMap<>();
		//num 0 注册用户 1.活动用户
		if (num.equals("0")) {
			ManWomenZBDto manWomenZBDto = QuDaoXinXiGuanLiDao.nanlvzcyhZB();
			QdfwnldTjDto qDto = QuDaoXinXiGuanLiDao.zcyhnlFX();
			map.put("manWomenZBDto", manWomenZBDto);
			map.put("QdfwnldTjDto", qDto);
		}else if (num.equals("1")) {
			ManWomenZBDto manWomenZBDto = QuDaoXinXiGuanLiDao.nanlvhdyhZB();
			QdfwnldTjDto qDto = QuDaoXinXiGuanLiDao.hdyhnlfx();
			map.put("manWomenZBDto", manWomenZBDto);
			map.put("QdfwnldTjDto", qDto);
		}
		return map;
	} 
}
