package com.changda.gjjapp.zhfwpt.service.impl.yhxxgl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.db.entity.WXN_USER;
import com.changda.gjjapp.zhfwpt.dao.yhxxgl.YHXXGLDao;
import com.changda.gjjapp.zhfwpt.dto.yhxxgl.YhxxLoggingDto;
import com.changda.gjjapp.zhfwpt.service.yhxxgl.YHXXGLService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;

/**
 * 用户信息管理
 * @author Administrator
 */
@Service()
public class YHXXGLServiceImp implements YHXXGLService {
    @Autowired
    private YHXXGLDao YHXXGLDao;

    private String dbServer = "gjj80.";
    //private String dbServer = "gjj80";

    //用户密码重置
    @Override
    public boolean updatePwd(String zjhm, String grzh, String pwd) {
        int num = YHXXGLDao.updatePwd(dbServer,zjhm, grzh, pwd);
        if (num > 0) {
			return true;
		}else {
			return false;
		}
    }

    //用户信息查询
    @Override
    public Map<String, Object> yongHuXinXiSearch(String yhlb,String data, String zckssj, String zcjssj, String dljssj, String dlkssj, int page, int limit) {
    	Map<String, Object> map = new HashMap<>();
        Page<WXN_USER> page2 = PageHelper.startPage(page, limit, true);
        List<WXN_USER> yhxxList = YHXXGLDao.yongHuXinXiSearch(yhlb,dbServer,data, zckssj, zcjssj, dljssj, dlkssj);
        int count = (int) page2.getTotal();
        map.put("total", count);
        map.put("yhxx", yhxxList);
        return map;
    }

    //修改用户信息
	@Override
	public ResultDto userInfoUpdate(String grzh, String xingbie, String xmqp, String csny) {
		ResultDto resultDto = new ResultDto();
		String csny2 = csny.substring(0, 4) + csny.substring(5, 7);
		int num = YHXXGLDao.userInfoUpdate(grzh, xingbie, xmqp, csny2);
		if (num > 0) {
			resultDto.setSuccess(true);
		}else {
			resultDto.setSuccess(false);
		}
		return resultDto;
	}

	//修改用户注销状态
	@Override
	public ResultDto iszx(String grzh, String iszx,String zxbz) {
		ResultDto resultDto = new ResultDto();
		int num = YHXXGLDao.iszx(grzh, iszx,zxbz);
		Map<String, Object> map = new HashMap<>();
		if (num > 0) {
			String zt = YHXXGLDao.zxzt(grzh);
			map.put("zxzt", zt);
			resultDto.setData(map);
			resultDto.setSuccess(true);
		}else {
			String zt = YHXXGLDao.zxzt(grzh);
			map.put("zxzt", zt);
			resultDto.setData(map);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	//用户刷新记录
	@Override
	public ResultDto userLoginRecording(String grzh) {
		ResultDto resultDto = new ResultDto();
		int num = YHXXGLDao.userLoginRecording(grzh);
		int cn = YHXXGLDao.grsxCount(grzh);
		if (cn>0) {
			YHXXGLDao.iszx(grzh, "1", "1");
		}
		Map<String, Object> map = new HashMap<>();
		if (num>0) {
			map.put("num", 1);
			resultDto.setData(map);
			resultDto.setSuccess(true);
		}else {
			map.put("num", 0);
			resultDto.setData(map);
			resultDto.setSuccess(false);
		}
		return resultDto;
	}

	//用户信息日志记录
	@Override
	public ResultDto yhxx_logging(String username, String czr, String czzt) {
		ResultDto resultDto = new ResultDto();
		int num = YHXXGLDao.yhxx_logging(username, czr, czzt);
		if (num > 0) {
			resultDto.setSuccess(true);
			return resultDto;
		}else {
			resultDto.setSuccess(false);
			return resultDto;
		}

	}

	//用户信息日志查询
	@Override
	public Map<String, Object> yhxx_logging_select(int page,int limit) {
		Map<String, Object> map = new HashMap<>();
        Page<YhxxLoggingDto> page2 = PageHelper.startPage(page, limit, true);
        List<YhxxLoggingDto> yhxxList = YHXXGLDao.yhxx_logging_select();
        int count = (int) page2.getTotal();
        map.put("total", count);
        map.put("yhxxLogging", yhxxList);
        return map;
	}
    
}
