package com.changda.gjjapp.zhfwpt.service.yhxxgl;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.zhfwpt.dto.yhxxgl.YhxxLoggingDto;


/**
 * 用户信息管理
 *
 * @author Administrator
 */
public interface YHXXGLService {
    /**
     * 用户信息   密码重置
     *
     * @param zjhm 证件号码
     * @param grzh 个人账号
     * @param pwd  密码
     */
    boolean updatePwd(String zjhm, String grzh, String pwd);

    /**
     * 用户信息查询
     *
     * @param zjhm     证件号码
     * @param xingming 姓名
     * @param grzh     个人账号
     * @param zhucerq  注册日期
     * @param denglurq 登陆日期
     */
    Map<String, Object> yongHuXinXiSearch(String yhlb,String data, String zckssj, String zcjssj, String dljssj, String dlkssj, int page, int limit);
    
    /**
     * 修改用户信息
     * @param grzh 个人账户
     * @param xingbie 性别
     * @param xmqp 姓名全拼
     * @param csny 出生年月
     * @return
     */
    ResultDto userInfoUpdate(String grzh,String xingbie,String xmqp,String csny);
    
    /**
     * 修改用户注销状态
     * @param grzh 个人账号
     * @param iszx 是否注销
     * @return
     */
    ResultDto iszx(String grzh,String iszx,String zxbz);
    
    /**
     * 用户登录记录
     * @return
     */
    ResultDto userLoginRecording(@Param("grzh")String grzh);
    
    /**
     * 用户信息日志记录
     * @param username
     * @param czr
     * @param czzt
     * @return
     */
    ResultDto yhxx_logging(String username,String czr,String czzt);
    
    /**
     * 用户信息日志记录查询
     * @return
     */
    Map<String, Object> yhxx_logging_select(int page,int limit);
}
