package com.changda.gjjapp.common.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.changda.gjjapp.db.entity.B_XTCS_PZ;
import com.changda.gjjapp.common.dao.IGolbalDao;
import com.changda.gjjapp.common.entity.GolbalDto;
import com.changda.gjjapp.common.entity.GolbalListDto;
import com.changda.gjjapp.common.service.IB_XTCS_PZService;
import com.changda.gjjapp.common.service.IGolbalService; 

@Service
public class GolbalService implements IGolbalService{

	@Autowired
	private IGolbalDao golbalDao;
	
	@Autowired
	private IB_XTCS_PZService b_xtcs_pzService;
	
	@Override
	public String get_xtcs(Map<String, Object> map) {
		 
		B_XTCS_PZ b_xtcs_pz=b_xtcs_pzService.queryXTCS(map);
		return b_xtcs_pz.getXTCSSDZ();
		
	}	
	
	@Override
	public String get_grdk(Map<String, Object> map) {
		 
		B_XTCS_PZ b_xtcs_pz=b_xtcs_pzService.queryGRDK(map);
		return b_xtcs_pz.getXTCSSDZ();
		
	}
	/**
	 * {@inheritDoc}
	 */
	@Override
	public GolbalDto getConstant() {
		
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("C_CUR", new ArrayList<GolbalDto>());//传入一个jdbc游标，用于接收返回参数  
		
		golbalDao.getConstant(params);
		
		List<GolbalDto> list=(List<GolbalDto>)params.get("C_CUR");
		
		return list.get(0);
		
	}
}
