package com.changda.gjjapp.gedai.dao.zhuyuehuakou;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.changda.cd4j.foundation.core.persistence.annotation.MyBatisDao;
import com.changda.gjjapp.db.entity.GD_MX;
import com.changda.gjjapp.db.entity.TMP_YW_GDHK_QKMX_WH;
import com.changda.gjjapp.gedai.dto.zhuyuehuakou.ZhuYueHuakouCompareDto;

@MyBatisDao
public interface ZhuYueHuaKouCheckDao {

	/**
	 * 计算公积金个贷欠款及罚息明细
	 * @param GRDKBM 个人贷款编码
	 * @param HKKXQ 还款宽限期 0 无宽限期 >1 相应天数 99 当月任意日还款
	 * @param JXFS 复利利息计算方式：0 单利计息 1 复利计息
	 * @param ZNJFX 是否计算滞纳金罚息: 0 不计算 1 计算
	 * @param FXBS 罚息倍数
	 * @param HKRQ 还款日期
	 * @returnx
	 */
	List<TMP_YW_GDHK_QKMX_WH> DRDK_QKMX(@Param("grdkbm")String GRDKBM,@Param("hkkxq")String HKKXQ,@Param("jxfs")String JXFS,@Param("znjfx")String ZNJFX,@Param("fxbs")String FXBS,@Param("hkrq")Date HKRQ );

	/**
	 * 查询逐月划扣用于显示
	 * @param kjqj
	 * @param zjzxdm
	 * @param dkyh
	 * @return
	 */
	List<ZhuYueHuakouCompareDto> zyhukData(@Param("kjqj")String kjqj,@Param("zjzxdm")String zjzxdm,@Param("dkyh")String dkyh);
	
	/**
	 * 查询逐月划扣数据
	 */
	List<Map<String, Object>> zyhk(@Param("kjqj")String kjqj,@Param("zjzxdm")String zjzxdm,@Param("dkyh")String dkyh);
	
	/**
	 * 把查询出的逐月划扣上月和本月的数据插入到jk_zyhkwh表中
	 */
	void insertJKZYHK(List<ZhuYueHuakouCompareDto> list);
	
	
	/**
	 * 查询dkmx临时表
	 * @return 
	 */
	List<TMP_YW_GDHK_QKMX_WH> queryTMPGDHKQKMX();
	
	
	/**
	 * 计算公积金个贷欠款及罚息明细所需条件
	 * 查询 HKKXQ、JXFS、ZNJFX、FXBS
	 */
	String HKKXQ(Map map);
	
	/**
	 * 计算公积金个贷欠款及罚息明细所需条件
	 * 查询 HKKXQ、JXFS、ZNJFX、FXBS
	 */
	String FLLX(Map map);
	
	/**
	 * 计算公积金个贷欠款及罚息明细所需条件
	 * 查询 HKKXQ、JXFS、ZNJFX、FXBS
	 */
	String ZNJFX(Map map);
	
	/**
	 * 计算公积金个贷欠款及罚息明细所需条件
	 * 查询 HKKXQ、JXFS、ZNJFX、FXBS
	 */
	String FXBS(Map map);
	
	/**
	 * 查询资金中心编码
	 */
	String ZJZXDM(@Param("grdkbm")String GRDKBM);
	
	/**
	 * 查询本月个人贷款编码
	 */
	List<Map<String, Object>> bYGRDKBM(@Param("zjzxdm")String zjzxdm,@Param("dkyh")String dkyh,@Param("kjqj")String kjqj);
	
	/**
	 * 查询上月公积金批扣金额
	 */
	List<Map<String, Object>> sygjjpkje(@Param("zjzxdm")String zjzxdm,@Param("dkyh")String dkyh,@Param("kjqj")String kjqj);
}
