package com.changda.gjjapp.gedai.service.yinhangpikou;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.changda.gjjapp.db.entity.GD_MX;
import com.changda.gjjapp.db.entity.TMP_YW_GDHK_QKMX_WH;
import com.changda.gjjapp.gedai.dto.yinhangpikou.YinHangPiKouCompareDto;

/**
 * 银行批扣
 * @author lj
 *
 */
public interface IYinHangPiKouCheckService {
	
	/**
	 * 查询上月银行批扣金额
	 * @throws ParseException 
	 */
	List<Map<String, Object>> syYinHangPiKouJe(String zjzxdm,String dkyh) throws ParseException;
	
	
	/**
	 * 查询银行批扣的数据
	 */
	List<Map<String, Object>> yhpkData(String kjqj,String zjzxdm,String dkyh);
	
	
	
	/**
	 * 获取银行上月和本月批扣金额进行比对
	 * @throws ParseException 
	 * @throws IOException 
	 */
	void yinHangPiKouComparison(String zjzxdm,String dkyh,String kjqj,Date HKRQ) throws ParseException, IOException;
	

	/**
	 * 查询银行批扣用于显示
	 * @param kjqj
	 * @param zjzxdm
	 * @param dkyh
	 * @return
	 */
	Map<String, Object> yhpkData(String kjqj,String zjzxdm,String dkyh,int page,int limit);
	
	
	
	/**
	 * 查询银行批扣的人员
	 */
	List<Map<String, Object>> yinHangPiKouGrdkbm(String zjzxdm,Date kkrq,String dkyh);
	
	/**
	 * 调用CALC_GRDK_QKMX2存储过程查询临时表
	 * @throws IOException 
	 */
	List<TMP_YW_GDHK_QKMX_WH> transferDRDK_QKMX(String GRDKBM,String HKKXQ,String JXFS,String ZNJFX,String FXBS,Date HKRQ) throws IOException;
	
	/**
	 * 插入数据到银行批扣数据表中
	 */
	void insertJKYHPK(List<YinHangPiKouCompareDto> list);
}
