package com.changda.gjjapp.zhfwpt.qdxxgl.controller;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.db.entity.S_YWZD;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.GqdmenwomenblDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.GqdywblslDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.HtjkDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdfwlTjDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdfwnldTjDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdgsjdTJDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdgzxzlTjDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdywblInFoDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdywfwlDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdywzbDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoFWLZBDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoYHTJDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoYeWuBanLiTongJiDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoYeWuFWDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QuDaoYongHuTongJiDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.TdqdblyhZBDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.TdqdywblZBDTO;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.TslvDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.WanWomanZBDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.XinXiTuiSongDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.YwblCGSBDBLvDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.YwblTypeZBSLDto;
import com.changda.gjjapp.zhfwpt.service.qdxxgl.QuDaoXinXiGuanLiService;
import com.changda.gjjapp.zhfwpt.service.qdxxgl.QuDaoYeWuBanLiShuService;

@Controller()
@RequestMapping(value = "/zhfwpt/qdxxgl")
public class QuDaoXinXiGuanLiController {

	@Autowired
	private QuDaoXinXiGuanLiService quDaoXinXiGuanLiService;

	@Autowired
	private QuDaoYeWuBanLiShuService quDaoYeWuBanLiShuService;

	// 渠道用户统计活动用户和注册用户
	@RequestMapping("qdyhtjZCAndHDYH")
	@ResponseBody
	public ResultDto qdyhtjZCAndHDYH(HttpServletRequest request) {
		String year = request.getParameter("year");
		String qdid = request.getParameter("qdid");
		ResultDto resultDto = new ResultDto();
		String z=year+qdid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<QuDaoYongHuTongJiDto> data = quDaoXinXiGuanLiService.qdyhtjZCAndHDYH(year, qdid);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		
		return resultDto;
	}

	// 渠道访问详情表
	@RequestMapping("insertQDFWXQ")
	@ResponseBody
	public ResultDto insertQDFWXQ(HttpServletRequest request) throws ParseException {
		String data = request.getParameter("data");
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(data);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			int status = quDaoXinXiGuanLiService.insertQDFWXQ(data);
			Map<String, Object> map = new HashMap<>();
			map.put("status", status);
			resultDto.setData(map);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}
	
	/// <summary>
		///SQL注入过滤
		/// </summary>
		/// <param name="InText">要过滤的字符串</param>
		/// <returns>如果参数存在不安全字bai符，则返回true</returns>
		public static boolean SqlFilter2(String date){
			boolean c=false;
			boolean q=cleanXSS(date);
			if(q==false){
				String word="and,exec,insert,select,delete,update,chr,mid,master,or,truncate,char,declare,join,',select*,select+,chr(,sleep(,replace(,/*,*/";
				String[] arrs=word.split(",");
				int x=0;
				for(String s:arrs){
					boolean a=date.contains(s);
					if(a){
						x++;
						break;
					}
				}
				if(x>0){
					c=true;
				}else{
					c=false;
				}	
			}else{
				c=q;
			}
			return c;
		}
		
		public static boolean cleanXSS(String value) {
			boolean b=false;
	        if (value != null) {
	            //推荐使用ESAPI库来避免脚本攻击,value = ESAPI.encoder().canonicalize(value);
	            // 避免空字符串
	            String value1 = value.replaceAll("", "");
	            if(!value1.equals(value)){
	            	b=true;
	            }
	            // 避免script 标签
	            Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", Pattern.CASE_INSENSITIVE);
	            String value2 = scriptPattern.matcher(value1).replaceAll("");
	            if(!value1.equals(value2)){
	            	b=true;
	            }
	            // 避免src形式的表达式
	            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\'(.*?)\\\'",
	                    Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
	            String value3 = scriptPattern.matcher(value2).replaceAll("");
	            if(!value2.equals(value3)){
	            	b=true;
	            }
	            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"",
	                    Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
	            String value4 = scriptPattern.matcher(value3).replaceAll("");
	            if(!value3.equals(value4)){
	            	b=true;
	            }
	            // 删除单个的 </script> 标签
	            scriptPattern = Pattern.compile("</script>", Pattern.CASE_INSENSITIVE);
	            String value5 = scriptPattern.matcher(value4).replaceAll("");
	            if(!value4.equals(value5)){
	            	b=true;
	            }
	            // 删除单个的<script ...> 标签
	            scriptPattern = Pattern.compile("<script(.*?)>",
	                    Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
	            String value6 = scriptPattern.matcher(value5).replaceAll("");
	            if(!value5.equals(value6)){
	            	b=true;
	            }
	            // 避免 eval(...) 形式表达式
	            scriptPattern = Pattern.compile("eval\\((.*?)\\)",
	                    Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
	            String value7 = scriptPattern.matcher(value6).replaceAll("");
	            if(!value6.equals(value7)){
	            	b=true;
	            }
	            // 避免 e-xpression(...) 表达式
	            scriptPattern = Pattern.compile("e-xpression\\((.*?)\\)",
	                    Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
	            String value8 = scriptPattern.matcher(value7).replaceAll("");
	            if(!value7.equals(value8)){
	            	b=true;
	            }
	            // 避免 javascript: 表达式
	            scriptPattern = Pattern.compile("javascript:", Pattern.CASE_INSENSITIVE);
	            String  value9 = scriptPattern.matcher(value8).replaceAll("");
	            if(!value8.equals(value9)){
	            	b=true;
	            }
	            // 避免 vbscript:表达式
	            scriptPattern = Pattern.compile("vbscript:", Pattern.CASE_INSENSITIVE);
	            String value10 = scriptPattern.matcher(value9).replaceAll("");
	            if(!value9.equals(value10)){
	            	b=true;
	            }
	            // 避免 οnlοad= 表达式
	            scriptPattern = Pattern.compile("onload(.*?)=",
	                    Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
	            String value11 = scriptPattern.matcher(value10).replaceAll("");
	            if(!value10.equals(value11)){
	            	b=true;
	            }
	        }
	        return b;
	    }

	// 业务访问详情表插入
	@RequestMapping("insertYWFWXQ")
	@ResponseBody
	public ResultDto insertYWFWXQ(HttpServletRequest request) throws ParseException {
		String data = request.getParameter("data");
		ResultDto resultDto = new ResultDto();
		boolean a=SqlFilter2(data);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			int status = quDaoXinXiGuanLiService.insertYWFWXQ(data);
			resultDto.setData(status);
			resultDto.setSuccess(true);
		}
		
		return resultDto;
	}

	// 渠道访问量查询
	@RequestMapping("qdywfwlData")
	@ResponseBody
	public ResultDto qdywfwlData(HttpServletRequest request) {
		String qssj = request.getParameter("qssj");
		String zzsj = request.getParameter("zzsj");
		// num:01按月查询num：02按日查询
		String num = request.getParameter("num");
		ResultDto resultDto = new ResultDto();
		String z=qssj+zzsj+num;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<QdywfwlDto> data = quDaoXinXiGuanLiService.qdywfwlData(qssj, zzsj, num);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 单位渠道业务办理数量（成功、失败、待处理）显示
	@RequestMapping("dWQuDaoBanLiShuL")
	@ResponseBody
	public ResultDto dWQuDaoBanLiShuL(HttpServletRequest request) {
		String qssj = request.getParameter("qssj");
		String zzsj = request.getParameter("zzsj");
		String num = request.getParameter("num");
		ResultDto resultDto = new ResultDto();
		String z=qssj+zzsj+num;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<GqdywblslDto> data = quDaoYeWuBanLiShuService.dWQuDaoBanLiShuL(qssj, zzsj, num);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		
		return resultDto;
	}

	// 个人渠道业务办理数量（成功、失败、待处理）显示
	@RequestMapping("GrQuDaoBanLiShuL")
	@ResponseBody
	public ResultDto GrQuDaoBanLiShuL(HttpServletRequest request) {
		String qssj = request.getParameter("qssj");
		String zzsj = request.getParameter("zzsj");
		String num = request.getParameter("num");
		ResultDto resultDto = new ResultDto();
		String z=qssj+zzsj+num;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<GqdywblslDto> data = quDaoYeWuBanLiShuService.GrQuDaoBanLiShuL(qssj, zzsj, num);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 后台监控所有渠道的业务办理实时监控
	@RequestMapping("htjkMonitor")
	@ResponseBody
	@SuppressWarnings("unchecked")
	public ResultDto htjkMonitor(HttpServletRequest request) {
		String qdid = request.getParameter("qdid");
		String ywlx = request.getParameter("ywlx");
		String qssj = request.getParameter("qssj");
		String zzsj = request.getParameter("zzsj");
		int page = Integer.parseInt(request.getParameter("page"));
		int limit = Integer.parseInt(request.getParameter("limit"));
		String z=qdid+ywlx+qssj+zzsj;
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			Map<String, Object> map = quDaoYeWuBanLiShuService.htjkMonitor(ywlx, qdid, qssj, zzsj, page, limit);
			int total = 0;
			if (map.get("total") == null) {
				total = 0;
			} else {
				total = (int) map.get("total");
			}
			List<HtjkDto> list = (List<HtjkDto>) map.get("data");
			resultDto.setData(list);
			resultDto.setTotal(total);
			resultDto.setSuccess(true);
		}
		
		return resultDto;
	}

	// 渠道访问量占比
	@RequestMapping("qdfwlZB")
	@ResponseBody
	public ResultDto qdfwlZB(HttpServletRequest request) {
		// 年份
		String year = request.getParameter("year");
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(year);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<QuDaoFWLZBDto> data = quDaoXinXiGuanLiService.qdfwlZB(year);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 渠道业务访问量占比
	@RequestMapping("qdywfw")
	@ResponseBody
	public ResultDto qdywfw(HttpServletRequest request) {
		String qssj = request.getParameter("qssj");
		String zzsj = request.getParameter("zzsj");
		// 业务分类1.单位业务2.个人业务
		String ywfl = request.getParameter("ywfl");
		// 个人账号
		String grzh = request.getParameter("grzh");
		ResultDto resultDto = new ResultDto();
		String z=qssj+zzsj+ywfl+grzh;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<QuDaoYeWuFWDto> data = quDaoXinXiGuanLiService.qdywfw(qssj, zzsj, ywfl, grzh);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 渠道业务访问量占比(渠道访问统计分析图)
	@RequestMapping("qdfwtjfxt")
	@ResponseBody
	public ResultDto qdfwtjfxt(HttpServletRequest request) {
		// 业务分类1.单位业务2.个人业务
		String ywfl = request.getParameter("ywfl");
		// 个人账号
		String grzh = request.getParameter("grzh");
		// 年份
		String year = request.getParameter("year");
		ResultDto resultDto = new ResultDto();
		String z=ywfl+grzh+year;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<QuDaoYeWuFWDto> data = quDaoXinXiGuanLiService.qdfwtjfxt(year, ywfl, grzh);
			resultDto.setData(data);
			resultDto.setSuccess(true);	
		}
		return resultDto;
	}

	// 渠道业务统计
	@RequestMapping("qdywbltj")
	@ResponseBody
	public ResultDto qdywbltj(HttpServletRequest request) {
		String qssj = request.getParameter("qssj");
		String zzsj = request.getParameter("zzsj");
		String grzh = request.getParameter("grzh");
		// 业务分类 1.单位业务2.个人业务
		String ywfl = request.getParameter("ywfl");
		ResultDto resultDto = new ResultDto();
		String z=qssj+zzsj+grzh+ywfl;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<QuDaoYeWuBanLiTongJiDto> data = quDaoXinXiGuanLiService.qdywbltj(qssj, zzsj, grzh, ywfl);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		
		return resultDto;
	}

	// 渠道用户统计分析（活动用户、注册用户）
	@RequestMapping("qdyhtjfx")
	@ResponseBody
	public ResultDto qdyhtjfx(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		List<QuDaoYHTJDto> data = quDaoXinXiGuanLiService.qdyhtjfx();
		resultDto.setData(data);
		resultDto.setSuccess(true);
		return resultDto;
	}

	// 渠道业务办理信息双击弹窗
	@RequestMapping("qdywblInFo")
	@ResponseBody
	public ResultDto qdywblInFo(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String ywlxid = request.getParameter("ywlx");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(ywlxid);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<QdywblInFoDto> data = quDaoYeWuBanLiShuService.qdywblInFo(ywlxid);
			resultDto.setData(data);
			resultDto.setSuccess(true);	
		}
		return resultDto;
	}

	// 后台监控业务下拉框
	@RequestMapping("htjkywlx")
	@ResponseBody
	public ResultDto htjkywlx(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String ywfl = request.getParameter("ywfl");
		// 操作类型
		String czlx = request.getParameter("czlx");
		String z=ywfl+czlx;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<S_YWZD> data = quDaoYeWuBanLiShuService.htjkywlx(ywfl, czlx);
			resultDto.setData(data);
			resultDto.setSuccess(true);	
		}
		return resultDto;
	}

	// 渠道各时间段统计
	@RequestMapping("qdgsjdTj")
	@ResponseBody
	public ResultDto qdgsjdTj(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 年份
		String year = request.getParameter("year");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(year);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<QdgsjdTJDto> data = quDaoXinXiGuanLiService.qdgsjdTj(year);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 渠道各年龄段访问统计
	@RequestMapping("qdfwnldTj")
	@ResponseBody
	public ResultDto qdfwnldTj(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 年份
		String year = request.getParameter("year");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(year);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<QdfwnldTjDto> data = quDaoXinXiGuanLiService.qdfwnldTj(year);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 渠道各年龄段业务访问统计
	@RequestMapping("qdywnldfwtj")
	@ResponseBody
	public ResultDto qdywnldfwtj(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 业务编码
		String ywbm = request.getParameter("ywbm");
		String qssj = request.getParameter("qssj");
		String zzsj = request.getParameter("zzsj");
		String z= ywbm+qssj+zzsj;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<QdfwnldTjDto> data = quDaoXinXiGuanLiService.qdywnldfwtj(ywbm, qssj, zzsj);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 渠道业务各时间段统计
	@RequestMapping("qdywgsjdtj")
	@ResponseBody
	public ResultDto qdywgsjdtj(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 业务编码
		String ywbm = request.getParameter("ywbm");
		String qssj = request.getParameter("qssj");
		String zzsj = request.getParameter("zzsj");
		String z=ywbm+qssj+zzsj;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<QdgsjdTJDto> data = quDaoXinXiGuanLiService.qdywgsjdtj(ywbm, qssj, zzsj);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 渠道业务各年龄段办理数统计
	@RequestMapping("qdywblgnldTj")
	@ResponseBody
	public ResultDto qdywblgnldTj(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 业务编码
		String ywbm = request.getParameter("ywbm");
		String qssj = request.getParameter("qssj");
		String zzsj = request.getParameter("zzsj");
		String z=ywbm+qssj+zzsj;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<QdfwnldTjDto> data = quDaoYeWuBanLiShuService.qdywblgnldTj(qssj, zzsj, ywbm);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		
		return resultDto;
	}

	// 渠道业务各年龄段办理数统计
	@RequestMapping("qdywnldblTJ")
	@ResponseBody
	public ResultDto qdywnldblTJ(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 业务编码
		String ywbm = request.getParameter("ywbm");
		String qssj = request.getParameter("qssj");
		String zzsj = request.getParameter("zzsj");
		String z=ywbm+qssj+zzsj;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<QdgsjdTJDto> data = quDaoYeWuBanLiShuService.qdywnldblTJ(qssj, zzsj, ywbm);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 渠道访问量统计
	@RequestMapping("qdfwlTj")
	@ResponseBody
	public ResultDto qdfwlTj(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 年份
		String year = request.getParameter("year");
		// 渠道id
		String qdid = request.getParameter("qdid");
		String z=year+qdid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<QdfwlTjDto> data = quDaoXinXiGuanLiService.qdfwlTj(qdid, year);
			resultDto.setData(data);
			resultDto.setSuccess(true);	
		}
		return resultDto;
	}

	// 渠道下载量关注量访问量统计
	@RequestMapping("qdgzxzlTj")
	@ResponseBody
	public ResultDto qdgzxzlTj(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 年份
		String year = request.getParameter("year");
		// 渠道id
		String qdid = request.getParameter("qdid");
		String z=year+qdid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<QdgzxzlTjDto> data = quDaoXinXiGuanLiService.qdgzxzlTj(qdid, year);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 各渠道注册男女比例占比
	@RequestMapping("gqdmenwomenbl")
	@ResponseBody
	public ResultDto gqdmenwomenbl(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		List<GqdmenwomenblDto> data = quDaoXinXiGuanLiService.gqdmenwomenbl();
		resultDto.setData(data);
		resultDto.setSuccess(true);
		return resultDto;
	}

	// 各渠道信息推送量统计
	@RequestMapping("xinXiTuiSongTJ")
	@ResponseBody
	public ResultDto xinXiTuiSongTJ(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String year = request.getParameter("year");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(year);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<XinXiTuiSongDto> data = quDaoXinXiGuanLiService.xinXiTuiSongTJ(year);
			resultDto.setData(data);
			resultDto.setSuccess(true);	
		}
		return resultDto;
	}

	// 注销被锁定总人数
	@RequestMapping("userLogoutStatus")
	@ResponseBody
	public ResultDto userLogoutStatus(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 用户锁定人数
		int userLogoutCount = quDaoXinXiGuanLiService.userLogoutStatus();
		Map<String, Object> map = new HashMap<>();
		map.put("userLogoutCount", userLogoutCount);
		resultDto.setData(map);
		resultDto.setSuccess(true);
		return resultDto;
	}

	// 男女比例
	@RequestMapping("wanWomanZB")
	@ResponseBody
	public ResultDto wanWomanZB(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		WanWomanZBDto wDto = quDaoXinXiGuanLiService.wanWomanZB();
		resultDto.setData(wDto);
		resultDto.setSuccess(true);
		return resultDto;
	}

	// 渠道业务占比
	@RequestMapping("qdywzb")
	@ResponseBody
	public ResultDto qdywzb(HttpServletRequest request) {
		// 业务编号
		String ywlx = request.getParameter("ywlx");
		// 年份
		String year = request.getParameter("year");
		// 月份
		String month = request.getParameter("month");
		ResultDto resultDto = new ResultDto();
		String z=ywlx+year+month;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			QdywzbDto dto = quDaoXinXiGuanLiService.qdywzb(year, month, ywlx);
			resultDto.setData(dto);
			resultDto.setSuccess(true);	
		}
		return resultDto;
	}

	// 注册用户年龄段分析
	@RequestMapping("zcyhnlFX")
	@ResponseBody
	public ResultDto zcyhnlFX(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		QdfwnldTjDto dto = quDaoXinXiGuanLiService.zcyhnlFX();
		resultDto.setData(dto);
		resultDto.setSuccess(true);
		return resultDto;
	}

	// 各渠道办理成功失败代办率
	@RequestMapping("ywblCGSBDBlv")
	@ResponseBody
	public ResultDto ywblCGSBDBlv(HttpServletRequest request) {
		// 年份
		String year = request.getParameter("year");
		// 月份
		String month = request.getParameter("month");
		// 渠道id
		String qdid = request.getParameter("qdid");
		ResultDto resultDto = new ResultDto();
		String zString=year+month+qdid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(zString);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<YwblCGSBDBLvDto> dto = quDaoXinXiGuanLiService.ywblCGSBDBlv(year, month, qdid);
			resultDto.setData(dto);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 各渠道办理成功失败代办率
	@RequestMapping("ywblTypeZBSL")
	@ResponseBody
	public ResultDto ywblTypeZBSL(HttpServletRequest request) {
		// 年份
		String year = request.getParameter("year");
		// 月份
		String month = request.getParameter("month");
		// 渠道id
		String qdid = request.getParameter("qdid");
		ResultDto resultDto = new ResultDto();
		String z=year+month+qdid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<YwblTypeZBSLDto> dto = quDaoXinXiGuanLiService.ywblTypeZBSL(year, month, qdid);
			resultDto.setData(dto);
			resultDto.setSuccess(true);	
		}
		return resultDto;
	}

	// 投诉率
	@RequestMapping("tslv")
	@ResponseBody
	public ResultDto tslv(HttpServletRequest request) {
		// 年份
		String year = request.getParameter("year");
		ResultDto resultDto = new ResultDto();
//		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(year);
//		if(a){
//			resultDto.setData(0);
//			resultDto.setMessage("存在sql注入");
//			resultDto.setSuccess(false);
//		}else{
			TslvDto dto = quDaoXinXiGuanLiService.tslv(year);
			resultDto.setData(dto);
			resultDto.setSuccess(true);
//		}
		return resultDto;
	}

	// 用户分布情况 特定渠道用户业务办理数
	@RequestMapping("tdqdblyhZB")
	@ResponseBody
	public ResultDto tdqdblyhZB(HttpServletRequest request) {
		// 年份
		String year = request.getParameter("year");
		// 月份
		String month = request.getParameter("month");
		// 渠道id
		String qdid = request.getParameter("qdid");
		ResultDto resultDto = new ResultDto();
		String z=year+month+qdid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			TdqdblyhZBDto dto = quDaoXinXiGuanLiService.tdqdblyhZB(year, month, qdid);
			resultDto.setData(dto);
			resultDto.setSuccess(true);	
		}
		return resultDto;
	}

	// 渠道分布情况
	@RequestMapping("tdqdywblZB")
	@ResponseBody
	public ResultDto tdqdywblZB(HttpServletRequest request) {
		// 年份
		String year = request.getParameter("year");
		// 月份
		String month = request.getParameter("month");
		// 渠道id
		String qdid = request.getParameter("qdid");
		ResultDto resultDto = new ResultDto();
		String z=year+month+qdid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			TdqdywblZBDTO dto = quDaoXinXiGuanLiService.tdqdywblZB(year, month, qdid);
			resultDto.setData(dto);
			resultDto.setSuccess(true);	
		}
		return resultDto;
	}

	// 用户分析活动用户的年龄段和活动用户和注册用户占比
	@RequestMapping("userFBNLD")
	@ResponseBody
	public ResultDto userFBNLD(HttpServletRequest request) {
		//num 0 注册用户 1.活动用户
		String num = request.getParameter("num");
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(num);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			Map<String, Object> map = quDaoXinXiGuanLiService.userFBNLD(num);
			resultDto.setData(map);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}
	
	
	
}
