package com.changda.gjjapp.zhfwpt.qdywqxgl.controller;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.db.entity.M_XEKZB;
import com.changda.gjjapp.db.entity.M_YWZTKZ_2;
import com.changda.gjjapp.zhfwpt.dto.qdywqxgl.*;
import com.changda.gjjapp.zhfwpt.qdxxgl.controller.QuDaoXinXiGuanLiController;
import com.changda.gjjapp.zhfwpt.service.qdywquanxiankz.QuDaoQuanXianKongZhiService;
import com.changda.gjjapp.zhfwpt.service.qdywquanxiankz.YeWuQuanXianKongZhiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 渠道、业务权限管理
 *
 * @author Administrator
 */
@Controller("qxkz")
@RequestMapping(value = "/zhfwpt/qdywqxgl")
public class QuDaoYeWuQuanXianGuanLiController {

    @Autowired
    private YeWuQuanXianKongZhiService yeWuQuanXianKongZhiService;

    @Autowired
    private QuDaoQuanXianKongZhiService quDaoQuanXianKongZhiService;

    // 查询渠道状态表用于管理渠道权限
    @RequestMapping("quDaoZhuangTaiSearch")
    @ResponseBody
    public ResultDto quDaoZhuangTaiSearch(HttpServletRequest request) {
        String primaryid = request.getParameter("primaryid");
        ResultDto resultDto = new ResultDto();
        if (primaryid == null) {
            List<QuDaoQuanXianGuanLiDto> list = quDaoQuanXianKongZhiService.quDaoZhuangTaiSearch(primaryid);
            resultDto.setData(list);
            resultDto.setSuccess(true);
        } else {
            boolean a = QuDaoXinXiGuanLiController.SqlFilter2(primaryid);
            if (a) {
                resultDto.setData(0);
                resultDto.setMessage("存在sql注入");
                resultDto.setSuccess(false);
            } else {
                List<QuDaoQuanXianGuanLiDto> list = quDaoQuanXianKongZhiService.quDaoZhuangTaiSearch(primaryid);
                resultDto.setData(list);
                resultDto.setSuccess(true);
            }
        }
        return resultDto;
    }

    public Date show() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar c = Calendar.getInstance();
        c = Calendar.getInstance();
        c.add(Calendar.MINUTE, +5);
        System.out.println(sdf.format(c.getTime()));
        return c.getTime();
    }

    // 修改阀值和控制渠道权限的时间
    @RequestMapping("updateTimeAndFz")
    @ResponseBody
    public ResultDto updateTimeAndFz(HttpServletRequest request) {
        String kssj = request.getParameter("kssj");
        String jssj = request.getParameter("jssj");
        String qdid = request.getParameter("qdid");
        String ksrq = request.getParameter("ksrq");
        String tzrq = request.getParameter("tzrq");
        String fz = request.getParameter("fz");
        int qdzt = Integer.parseInt(request.getParameter("qdzt"));
        ResultDto resultDto = new ResultDto();
        String z = kssj + jssj + qdid + ksrq + tzrq + fz;
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(z);
        if (a) {
            resultDto.setData(0);
            resultDto.setMessage("存在sql注入");
            resultDto.setSuccess(false);
        } else {
            boolean flag = quDaoQuanXianKongZhiService.updateTimeAndFz(kssj, jssj, ksrq, tzrq, fz, qdid, qdzt);
            resultDto.setData(flag);
            resultDto.setSuccess(true);
        }
        return resultDto;
    }

    @RequestMapping("ywztSreach")
    @ResponseBody
    public ResultDto ywztSreach(HttpServletRequest request) {
        String qdid = request.getParameter("qdid");
        ResultDto resultDto = new ResultDto();
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(qdid);
        if (a) {
            resultDto.setData(0);
            resultDto.setMessage("存在sql注入");
            resultDto.setSuccess(false);
        } else {
            List<QDYWQuanXianGuanLiDto> list = yeWuQuanXianKongZhiService.ywztSreach(qdid);
            resultDto.setData(list);
            resultDto.setSuccess(true);
        }
        return resultDto;
    }

    @RequestMapping("updateYWZT")
    public void updateYWZT(HttpServletRequest request) {
        String ywzt = request.getParameter("ywzt");
        String qdid = request.getParameter("qdid");
        String ywbm = request.getParameter("ywbm");
        String z = ywzt + qdid + ywbm;
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(z);
        if (a) {

        } else {
            yeWuQuanXianKongZhiService.updateYWZT(ywzt, qdid, ywbm);
        }
    }

    @RequestMapping("updateDuanXinZT")
    public void updateDuanXinZT(HttpServletRequest request) {
        String zjzxdm = request.getParameter("zjzxdm");
        String dxzt = request.getParameter("dxzt");
        String z = zjzxdm + dxzt;
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(z);
        if (a) {

        } else {
            quDaoQuanXianKongZhiService.updateDuanXinZT(zjzxdm, dxzt);
        }

    }

    // 更新渠道状态
    @RequestMapping("updateQDZT")
    @ResponseBody
    public ResultDto updateQDZT(HttpServletRequest request) {
        // 渠道id
        String qdid = request.getParameter("qdid");
        // 阀值
        String fz = request.getParameter("fz");
        // 待机时间
        String djsj = request.getParameter("djsj");
        // 渠道状态
        String qdzt = request.getParameter("qdzt");
        ResultDto resultDto = new ResultDto();
        String z = qdid + fz + djsj + qdzt;
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(z);
        if (a) {
            resultDto.setData(0);
            resultDto.setMessage("存在sql注入");
            resultDto.setSuccess(false);
        } else {
            resultDto = quDaoQuanXianKongZhiService.updateQDZT(qdid, fz, djsj, qdzt);
        }
        return resultDto;
    }

    // 渠道控制接口
    @RequestMapping("qdkzInfo")
    @ResponseBody
    public ResultDto qdkzInfo(HttpServletRequest request) {
        String qdid = request.getParameter("qdid");
        ResultDto resultDto = new ResultDto();
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(qdid);
        if (a) {
            resultDto.setData(0);
            resultDto.setMessage("存在sql注入");
            resultDto.setSuccess(false);
        } else {
            List<QuDaoQuanXianGuanLiDto> list = quDaoQuanXianKongZhiService.qdkzInfo(qdid);
            resultDto.setData(list);
            resultDto.setSuccess(true);
        }

        return resultDto;
    }

    // 渠道业务控制接口
    @RequestMapping("qdywkz")
    @ResponseBody
    public ResultDto qdywkz(HttpServletRequest request) {
        String qdid = request.getParameter("qdid");
        String ywbm = request.getParameter("ywbm");
        ResultDto resultDto = new ResultDto();
        String z = qdid + ywbm;
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(z);
        if (a) {
            resultDto.setData(0);
            resultDto.setMessage("存在sql注入");
            resultDto.setSuccess(false);
        } else {
            List<QDYWQuanXianGuanLiDto> list = yeWuQuanXianKongZhiService.qdywkz(qdid, ywbm);
            resultDto.setData(list);
            resultDto.setSuccess(true);
        }
        return resultDto;
    }

    // 待机时间控制恶意刷新
    @RequestMapping("qx")
    public void AccessControl() throws ParseException {
        quDaoQuanXianKongZhiService.onlineUsers();
    }

    // 在线人数
    @RequestMapping("quDaoSSKZ")
    public void quDaoSSKZ() throws ParseException {
        quDaoQuanXianKongZhiService.quDaoSSKZ();
    }

    // 业务控制2
    @RequestMapping("sreachM_YWZTKZ_2")
    @ResponseBody
    public ResultDto sreachM_YWZTKZ_2(HttpServletRequest request) {
        Integer limit = Integer.parseInt(request.getParameter("limit"));
        Integer page = Integer.parseInt(request.getParameter("page"));
        // 业务操作类型2（1.查询业务2.申请业务3.其他业务类型）
        String ywczlx_2 = request.getParameter("ywczlx_2");
        // 业务名称
        String ywmc = request.getParameter("ywmc");

        String ywbm = request.getParameter("ywbm");

        String issh = request.getParameter("issh");
        ResultDto resultDto = new ResultDto();
        String z = ywczlx_2 + ywmc + ywbm + issh;
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(z);
        if (a) {
            resultDto.setData(0);
            resultDto.setMessage("存在sql注入");
            resultDto.setSuccess(false);
        } else {
            Map<String, Object> map = quDaoQuanXianKongZhiService.sreachM_YWZTKZ_2(limit, page, ywczlx_2, ywmc, issh, ywbm);
            List<M_YWZTKZ_2> list = (List<M_YWZTKZ_2>) map.get("data");
            int total = (int) map.get("total");
            resultDto.setData(list);
            resultDto.setTotal(total);
            resultDto.setSuccess(true);
        }

        return resultDto;
    }

    // 修改渠道状态
    @RequestMapping("updateQD_state")
    @ResponseBody
    public ResultDto updateQD_state(HttpServletRequest request) {
        // 主键
        String primaryid = request.getParameter("primaryid");
        // 是否审核1.审核0.未审核
        String qdzt = request.getParameter("qdzt");
        // 阀值
        String fz = request.getParameter("fz");
        // 待机时间
        String djsj = request.getParameter("djsj");
        // 渠道
        String qdid = request.getParameter("qdid");
        // 操作人
        String czr = request.getParameter("czr");
        String z = primaryid + qdzt + fz + djsj + qdid + czr;
        ResultDto resultDto = new ResultDto();
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(z);
        if (a) {
            resultDto.setData(0);
            resultDto.setMessage("存在sql注入");
            resultDto.setSuccess(false);
        } else {
            resultDto = quDaoQuanXianKongZhiService.updateQD_state(qdzt, fz, djsj, primaryid, qdid, czr);
        }
        return resultDto;
    }

    // 修改业务状态（保存按钮）
    @RequestMapping("updateM_YWZTKZ_2State")
    @ResponseBody
    public ResultDto updateM_YWZTKZ_2State(HttpServletRequest request) {
        // 主键
        String primaryid = request.getParameter("primaryid");
        // 业务状态1.开启0.停止
        String wxzt = request.getParameter("wxzt");
        String wtzt = request.getParameter("wtzt");
        String appzt = request.getParameter("appzt");
        String znzdzt = request.getParameter("znzdzt");
        String zh308zt = request.getParameter("zh308zt");
        String sjzt = request.getParameter("sjzt");
        // 启用结束时间
        String qyjssj = request.getParameter("qyjssj");
        // 启用开始时间
        String qykssj = request.getParameter("qykssj");
        // 启用开始日期
        String qyksrq = request.getParameter("qyksrq");
        // 启用结束日期
        String qyjsrq = request.getParameter("qyjsrq");
        // 操作类型
        String czlx = request.getParameter("czlx");
        // 操作人
        String czr = request.getParameter("czr");
        // 启用时间段
        String qysjd = request.getParameter("qysjd");
        // 业务名称
        String ywbm = request.getParameter("ywbm");
        // 业务类别
        String ywlb = request.getParameter("ywlb");
        ResultDto resultDto = new ResultDto();
        String z = primaryid + wxzt + wtzt + appzt + znzdzt + zh308zt + sjzt + qyjssj + qykssj + qyksrq + qyjsrq + czlx + czr + qysjd + ywbm + ywlb;
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(z);
        if (a) {
            resultDto.setData(0);
            resultDto.setMessage("存在sql注入");
            resultDto.setSuccess(false);
        } else {
            resultDto = quDaoQuanXianKongZhiService.updateM_YWZTKZ_2State(primaryid, wtzt, wxzt, appzt, znzdzt, zh308zt, sjzt,
                    qyjssj, qykssj, qyksrq, qyjsrq, czlx, czr, qysjd, ywbm, ywlb);
        }
        return resultDto;
    }

    // 审核业务状态（审核按钮）
    @RequestMapping("updateSHState")
    @ResponseBody
    public ResultDto updateSHState(HttpServletRequest request) {
        ResultDto resultDto = new ResultDto();
        // 主键
        String primaryid = request.getParameter("primaryid");

        String czlx = request.getParameter("czlx");

        String ywlb = request.getParameter("ywlb");
        String ywbm = request.getParameter("ywbm");
        String qysjd = request.getParameter("qysjd");
        String czr = request.getParameter("czr");
        String wxzt = request.getParameter("wxzt");
        String appzt = request.getParameter("appzt");
        String znzdzt = request.getParameter("znzdzt");
        String zh308zt = request.getParameter("zh308zt");
        String sjzt = request.getParameter("sjzt");
        String wtzt = request.getParameter("wtzt");
        String z = primaryid + czlx + ywlb + ywbm + qysjd + czr + wxzt + appzt + znzdzt + zh308zt + sjzt + wtzt;
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(z);
        if (a) {
            resultDto.setData(0);
            resultDto.setMessage("存在sql注入");
            resultDto.setSuccess(false);
        } else {
            resultDto = quDaoQuanXianKongZhiService.updateSHState(primaryid, czlx, ywlb, ywbm, qysjd, czr, wxzt, appzt, znzdzt, zh308zt, sjzt, wtzt);
        }
        return resultDto;
    }

    // 渠道状态接口
    @RequestMapping("qdztkzInterface")
    @ResponseBody
    public ResultDto qdztkzInterface(HttpServletRequest request) {
        // 业务编码
        ResultDto resultDto = new ResultDto();
        String ywbm = request.getParameter("ywbm");
        String qdid = request.getParameter("qdid");
        String z = ywbm + qdid;
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(z);
        if (a) {
            resultDto.setData(0);
            resultDto.setMessage("存在sql注入");
            resultDto.setSuccess(false);
        } else {
            int num = quDaoQuanXianKongZhiService.qdztkzInterface(ywbm, qdid);
            Map<String, Object> map = new HashMap<>();
            map.put("num", num);
            resultDto.setData(map);
            resultDto.setSuccess(true);
        }
        return resultDto;
    }

    // 短信控制信息
    @RequestMapping("dxkzInfo")
    @ResponseBody
    public ResultDto dxkzInfo(HttpServletRequest request) throws Exception {
        ResultDto resultDto = new ResultDto();
        String page = request.getParameter("page");
        String limit = request.getParameter("limit");
        String z = page + limit;
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(z);
        if (a) {
            resultDto.setData(0);
            resultDto.setMessage("存在sql注入");
            resultDto.setSuccess(false);
        } else {
            Map<String, Object> map = quDaoQuanXianKongZhiService.dxkzInfo(page, limit);
            List<DuanXinQuanXianGuanLiDto> list = (List<DuanXinQuanXianGuanLiDto>) map.get("list");
            int total = (int) map.get("total");
            resultDto.setTotal(total);
            resultDto.setData(list);
            resultDto.setSuccess(true);
        }
        return resultDto;
    }

    // 限额控制信息
    @RequestMapping("xekzInfo")
    @ResponseBody
    public ResultDto xekzInfo(HttpServletRequest request) throws Exception {
        List<M_XEKZB> list = quDaoQuanXianKongZhiService.xekzInfo();
        ResultDto resultDto = new ResultDto();
        resultDto.setData(list);
        resultDto.setSuccess(true);
        return resultDto;
    }

    // 修改限额值
    @RequestMapping("xeUpdate")
    @ResponseBody
    public ResultDto xeUpdate(HttpServletRequest request) {
        ResultDto resultDto = new ResultDto();
        // 主键
        String id = request.getParameter("id");
        // 限额值
        String value = request.getParameter("value");
        String zString = id + value;
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(zString);
        if (a) {
            resultDto.setData(0);
            resultDto.setMessage("存在sql注入");
            resultDto.setSuccess(false);
        } else {
            resultDto = quDaoQuanXianKongZhiService.xeUpdate(id, value);
        }
        return resultDto;
    }

    // 渠道总控修改日志记录
    @RequestMapping("qdzkLoggingInfo")
    @ResponseBody
    public ResultDto qdzkLoggingInfo(HttpServletRequest request) {
        ResultDto resultDto = new ResultDto();
        Integer limit = Integer.parseInt(request.getParameter("limit"));
        Integer page = Integer.parseInt(request.getParameter("page"));
        String czsj = request.getParameter("czsj");
        String qdid = request.getParameter("qdid");
        String z = limit + page + czsj + qdid;
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(z);
        if (a) {
            resultDto.setData(0);
            resultDto.setMessage("存在sql注入");
            resultDto.setSuccess(false);
        } else {
            Map<String, Object> map = quDaoQuanXianKongZhiService.qdzkLoggingInfo(qdid, czsj, page, limit);
            List<QdzkLoggingInfoDto> list = (List<QdzkLoggingInfoDto>) map.get("data");
            int total = (int) map.get("total");
            resultDto.setData(list);
            resultDto.setTotal(total);
            resultDto.setSuccess(true);
        }
        return resultDto;
    }

    // 渠道总控修改日志记录
    @RequestMapping("fwkzLoggingInfo")
    @ResponseBody
    public ResultDto fwkzLoggingInfo(HttpServletRequest request) {
        Integer limit = Integer.parseInt(request.getParameter("limit"));
        Integer page = Integer.parseInt(request.getParameter("page"));
        String ywbm = request.getParameter("ywbm");
        ResultDto resultDto = new ResultDto();
        String z = limit + page + ywbm;
        boolean a = QuDaoXinXiGuanLiController.SqlFilter2(z);
        if (a) {
            resultDto.setData(0);
            resultDto.setMessage("存在sql注入");
            resultDto.setSuccess(false);
        } else {
            Map<String, Object> map = quDaoQuanXianKongZhiService.fwkzLoggingInfo(page, limit, ywbm);
            List<FwkzLogginInfoDto> list = (List<FwkzLogginInfoDto>) map.get("data");
            int total = (int) map.get("total");
            resultDto.setData(list);
            resultDto.setTotal(total);
            resultDto.setSuccess(true);
        }
        return resultDto;
    }

}
