package com.changda.gjjapp.zhfwpt.tyfb.controller;
import java.util.*;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.cd4j.foundation.core.utils.FastJsonUtil;
import com.changda.cd4j.foundation.core.web.BaseController;
import com.changda.gjjapp.db.entity.M_LANMU;
import com.changda.gjjapp.zhfwpt.qdxxgl.controller.QuDaoXinXiGuanLiController;
import com.changda.gjjapp.zhfwpt.service.tyfb.IM_LANMUService;

@Controller
@RequestMapping(value="/zhfwpt/M_LANMU")
public class M_LANMUController extends BaseController
{
 
 @Autowired
 private IM_LANMUService m_lanmuService;
 
 @RequestMapping("query")
 @ResponseBody
 public ResultDto query(HttpServletRequest request)
 {
  ResultDto resultDto = new ResultDto();
  Map<String, Object> inputMap = super.getParamtersMap(request);
  List<M_LANMU> listm_lanmu = m_lanmuService.query(inputMap);
  resultDto.setSuccess(true);
  resultDto.setData(listm_lanmu);
  return resultDto;
 }
 
 @RequestMapping("count")
 @ResponseBody
 public ResultDto count(HttpServletRequest request)
 {
  ResultDto resultDto = new ResultDto();
  Map<String, Object> inputMap = super.getParamtersMap(request);
  int count = m_lanmuService.count(inputMap);
  resultDto.setSuccess(true);
  resultDto.setData(count);
  return resultDto;
 }
 
 @RequestMapping("insert")
 @ResponseBody
 public ResultDto insert(HttpServletRequest request)
 {
  ResultDto resultDto = new ResultDto();
  String paramdata = request.getParameter("params");
  boolean a=QuDaoXinXiGuanLiController.SqlFilter2(paramdata);
	if(a){
		resultDto.setData(0);
		resultDto.setMessage("存在sql注入");
		resultDto.setSuccess(false);
	}else{
		List<M_LANMU> listm_lanmu = FastJsonUtil.toListObject(paramdata, M_LANMU.class);
		  m_lanmuService.insert(listm_lanmu);
		  resultDto.setSuccess(true);
		  resultDto.setMessage("新增数据成功");
	}
  return resultDto;
 }
 
 @RequestMapping("delete")
 @ResponseBody
 public ResultDto delete(HttpServletRequest request)
 {
  ResultDto resultDto = new ResultDto();
  String paramdata = request.getParameter("params");
  boolean a=QuDaoXinXiGuanLiController.SqlFilter2(paramdata);
	if(a){
		resultDto.setData(0);
		resultDto.setMessage("存在sql注入");
		resultDto.setSuccess(false);
	}else{
		List<M_LANMU> listm_lanmu = FastJsonUtil.toListObject(paramdata, M_LANMU.class);
		  m_lanmuService.delete(listm_lanmu);
		  resultDto.setSuccess(true);
		  resultDto.setMessage("删除数据成功");
	}
  return resultDto;
 }
 
 @RequestMapping("update")
 @ResponseBody
 public ResultDto update(HttpServletRequest request)
 {
  ResultDto resultDto = new ResultDto();
  String paramdata = request.getParameter("params");
  boolean a=QuDaoXinXiGuanLiController.SqlFilter2(paramdata);
	if(a){
		resultDto.setData(0);
		resultDto.setMessage("存在sql注入");
		resultDto.setSuccess(false);
	}else{
		List<M_LANMU> listm_lanmu = FastJsonUtil.toListObject(paramdata, M_LANMU.class);
		  m_lanmuService.update(listm_lanmu);
		  resultDto.setSuccess(true);
		  resultDto.setMessage("新增数据成功");
	}
  return resultDto;
 }
}

