package com.changda.gjjapp.zhfwpt.wjdc.controller;
import java.util.*;
import javax.servlet.http.HttpServletRequest;

import com.changda.gjjapp.db.entity.M_TSXQ;
import com.changda.gjjapp.zhfwpt.qdxxgl.controller.QuDaoXinXiGuanLiController;
import com.changda.gjjapp.zhfwpt.service.wjdc.IM_TSXQService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.cd4j.foundation.core.utils.FastJsonUtil;
import com.changda.cd4j.foundation.core.web.BaseController;

@Controller
@RequestMapping(value="/zhfwpt/M_TSXQ")
public class M_TSXQController extends BaseController
{
 
 @Autowired
 private IM_TSXQService m_tsxqService;
 
 @RequestMapping("query")
 @ResponseBody
 public ResultDto query(HttpServletRequest request)
 {
  ResultDto resultDto = new ResultDto();
  Map<String, String> inputMap = super.getParameterStringMap(request);
  List<M_TSXQ> listm_tsxq = m_tsxqService.query(inputMap);
  resultDto.setSuccess(true);
  resultDto.setData(listm_tsxq);
  return resultDto;
 }
 
 @RequestMapping("count")
 @ResponseBody
 public ResultDto count(HttpServletRequest request)
 {
  ResultDto resultDto = new ResultDto();
  Map<String, Object> inputMap = super.getParamtersMap(request);
  int count = m_tsxqService.count(inputMap);
  resultDto.setSuccess(true);
  resultDto.setData(count);
  return resultDto;
 }
 
 @RequestMapping("insert")
 @ResponseBody
 public ResultDto insert(HttpServletRequest request)
 {
  ResultDto resultDto = new ResultDto();
  String paramdata = request.getParameter("params");
  boolean a=QuDaoXinXiGuanLiController.SqlFilter2(paramdata);
	if(a){
		resultDto.setData(0);
		resultDto.setMessage("存在sql注入");
		resultDto.setSuccess(false);
	}else{
		List<M_TSXQ> listm_tsxq = FastJsonUtil.toListObject(paramdata, M_TSXQ.class);
		  m_tsxqService.insert(listm_tsxq);
		  resultDto.setSuccess(true);
		  resultDto.setMessage("新增数据成功");
	}
  return resultDto;
 }
 
 @RequestMapping("delete")
 @ResponseBody
 public ResultDto delete(HttpServletRequest request)
 {
  ResultDto resultDto = new ResultDto();
  String paramdata = request.getParameter("params");
  boolean a=QuDaoXinXiGuanLiController.SqlFilter2(paramdata);
	if(a){
		resultDto.setData(0);
		resultDto.setMessage("存在sql注入");
		resultDto.setSuccess(false);
	}else{
		List<M_TSXQ> listm_tsxq = FastJsonUtil.toListObject(paramdata, M_TSXQ.class);
		  m_tsxqService.delete(listm_tsxq);
		  resultDto.setSuccess(true);
		  resultDto.setMessage("删除数据成功");
	}
  return resultDto;
 }
 
 @RequestMapping("update")
 @ResponseBody
 public ResultDto update(HttpServletRequest request)
 {
  ResultDto resultDto = new ResultDto();
  String paramdata = request.getParameter("params");
  boolean a=QuDaoXinXiGuanLiController.SqlFilter2(paramdata);
	if(a){
		resultDto.setData(0);
		resultDto.setMessage("存在sql注入");
		resultDto.setSuccess(false);
	}else{
		List<M_TSXQ> listm_tsxq = FastJsonUtil.toListObject(paramdata, M_TSXQ.class);
		  m_tsxqService.update(listm_tsxq);
		  resultDto.setSuccess(true);
		  resultDto.setMessage("新增数据成功");	
	}
  return resultDto;
 }
}

