package com.changda.gjjapp.zhfwpt.wjdc.controller;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.changda.gjjapp.zhfwpt.dto.wjdc.S_TSLXDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.TslxAdvisorySortDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.WJDCDAANTJDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.ZiXunReDianTSPXDto;
import com.changda.gjjapp.zhfwpt.qdxxgl.controller.QuDaoXinXiGuanLiController;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.cd4j.foundation.core.web.BaseController;
import com.changda.gjjapp.db.entity.M_TSXQ;
import com.changda.gjjapp.zhfwpt.dto.qdywqxgl.QDYWQuanXianGuanLiDto;
import com.changda.gjjapp.zhfwpt.dto.tyfb.TyfbLoggingDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.HdjlLoggingDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.M_WJDC_INFODto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.M_WJDC_ITEMDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.M_WJDC_ORDERDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.M_ZHISHIKUMULU;
import com.changda.gjjapp.zhfwpt.service.wjdc.WJDCService;

/**
 * 问卷调查
 *
 * @author Administrator
 */

@Controller()
@RequestMapping(value = "/zhfwpt/wjdc")
public class WJDCController extends BaseController {

	@Autowired
	private WJDCService wjdcService;

	// 查询渠道状态表用于管理渠道权限
	@RequestMapping("sreachWJXX")
	@ResponseBody
	public ResultDto sreachWJXX(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String wjmc = request.getParameter("wjmc");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(wjmc);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<M_WJDC_ORDERDto> list = wjdcService.sreachWJXX(wjmc);
			resultDto.setData(list);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 删除问卷、问题、答案
	@RequestMapping("deleteWj")
	@ResponseBody
	public ResultDto deleteWj(HttpServletRequest request) {
		String wjid = request.getParameter("wjid");
		System.out.println("wjid" + wjid);
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(wjid);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			boolean falg = wjdcService.deleteWJ(wjid);
			resultDto.setData(falg);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 修改问卷信息
	@RequestMapping("updateWJ")
	@ResponseBody
	public ResultDto updateWJ(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String wjid = request.getParameter("wjid");
		String wjmc = request.getParameter("wjmc");
		String sfqy = request.getParameter("sfqy");
		String wjzqkssj = request.getParameter("wjzqkssj");
		String wjzqjssj = request.getParameter("wjzqjssj");
		String z=wjid+wjmc+sfqy+wjzqkssj+wjzqjssj;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			boolean falg = wjdcService.updateWJ(wjmc, sfqy, wjzqkssj, wjzqjssj, wjid);
			resultDto.setData(falg);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 添加问卷信息
	@RequestMapping("addWJ")
	@ResponseBody
	public ResultDto addWJ(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String wjmc = request.getParameter("wjmc");
		String sfqy = request.getParameter("sfqy");
		String wjzqkssj = request.getParameter("wjzqkssj");
		String wjzqjssj = request.getParameter("wjzqjssj");
		String z=wjmc+sfqy+wjzqkssj+wjzqjssj;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			boolean falg = wjdcService.addWJ(wjmc, sfqy, wjzqkssj, wjzqjssj);
			resultDto.setData(falg);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 查询问卷调查问题信息
	@RequestMapping("WJWTInfo")
	@ResponseBody
	public ResultDto WJWTInfo(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String wtmc = request.getParameter("wtmc");
		String wjid = request.getParameter("wjid");
		String z=wjid+wtmc;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<M_WJDC_INFODto> list = wjdcService.WJWTInfo(wjid, wtmc);
			resultDto.setData(list);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 删除问题答案
	@RequestMapping("deleteWTDA")
	@ResponseBody
	public ResultDto deleteWTDA(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String wjdcwtid = request.getParameter("wtid");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(wjdcwtid);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			boolean flag = wjdcService.deleteWTDA(wjdcwtid);
			resultDto.setData(flag);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 查询问题信息
	@RequestMapping("wjdcWTINFO")
	@ResponseBody
	public ResultDto wjdcWTINFO(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String wtid = request.getParameter("wtid");
		String wjid = request.getParameter("wjid");
		String z=wtid+wjid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<M_WJDC_INFODto> list = wjdcService.wjdcWTINFO(wjid, wtid);
			resultDto.setData(list);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 查询问题信息
	@RequestMapping("wjdcDAANInfo")
	@ResponseBody
	public ResultDto wjdcDAANInfo(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String wtid = request.getParameter("wtid");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(wtid);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<M_WJDC_ITEMDto> list = wjdcService.wjdcDAANInfo(wtid);
			resultDto.setData(list);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 新增问题和答案
	@RequestMapping("addWTAndDaAn")
	@ResponseBody
	public ResultDto addWTAndDaAn(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String data = request.getParameter("data");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(data);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			boolean flag = wjdcService.addWTAndDaAn(data);
			resultDto.setData(flag);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 编辑问题答案
	@RequestMapping("updateWT")
	@ResponseBody
	public ResultDto updateWT(HttpServletRequest request) {
		String data = request.getParameter("data");
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(data);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			boolean flag = wjdcService.updateWT(data);
			resultDto.setData(flag);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 网上调查 插入反馈表
	@RequestMapping("insertFK")
	@ResponseBody
	public ResultDto insertFK(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String data = request.getParameter("data");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(data);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			int status = 0;
			try {
				status = wjdcService.insertFK(data);
				resultDto.setSuccess(true);
			} catch (Exception e) {
				logger.error("错误信息为:" + e);
				resultDto.setSuccess(false);
			}
			resultDto.setData(status);	
		}
		return resultDto;
	}

	// 查询问题和答案
	@RequestMapping("sreachWj_List")
	@ResponseBody
	public ResultDto sreachWj(HttpServletRequest request) {
		List<M_WJDC_ORDERDto> list = wjdcService.sreachWj();
		ResultDto resultDto = new ResultDto();
		resultDto.setData(list);
		resultDto.setSuccess(true);
		return resultDto;
	}

	// 查询问题和答案
	@RequestMapping("sreachWj_Item")
	@ResponseBody
	public ResultDto sreachDaAndWent(HttpServletRequest request) {
		String data = request.getParameter("data");
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(data);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<M_WJDC_INFODto> list = wjdcService.sreachDaAndWent(data);
			resultDto.setData(list);
			resultDto.setSuccess(true);	
		}
		
		return resultDto;
	}

	// 查询投诉类型
	@RequestMapping("sreachTSType")
	@ResponseBody
	public ResultDto sreachTSType(HttpServletRequest request) {
		String zlx = request.getParameter("zlx");
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(zlx);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<S_TSLXDto> list = wjdcService.sreachTSType(zlx);
			resultDto.setData(list);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 插入投诉建议
	@RequestMapping("insertTS")
	@ResponseBody
	public ResultDto insertTS(HttpServletRequest request) {
		String data = request.getParameter("data");
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(data);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			int status = 0;
			int count=wjdcService.selectuserpd(data);//通过yhxm查该用户是否存在，存在则继续执行，否则返回
			if(count>0){
				try {
					status = wjdcService.insertTS(data);
					resultDto.setSuccess(true);
				} catch (Exception e) {
					logger.error("错误信息为:" + e);
					resultDto.setSuccess(false);
				}
				resultDto.setData(status);
			}else{
				resultDto.setSuccess(false);
				resultDto.setMessage("用户不存在");
				resultDto.setData(count);
			}	
		}
		
		return resultDto;
	}

	// 查询投诉信息
	@RequestMapping("sreachTSINFO")
	@ResponseBody
	public ResultDto sreachTSINFO(HttpServletRequest request) {
		Integer page = Integer.parseInt(request.getParameter("page"));
		Integer limit = Integer.parseInt(request.getParameter("limit"));
		String bt = request.getParameter("bt");
		String qssj = request.getParameter("qssj");
		String zzsj = request.getParameter("zzsj");
		String grzh = request.getParameter("grzh");
		String zlx = request.getParameter("zlx");
		String tslxid = request.getParameter("tslxid");
		String issh = request.getParameter("issh");
		String sfcl = request.getParameter("sfcl");
		String sfyc = request.getParameter("sfyc");
		String jsbh = request.getParameter("jsbh");
		String tsid = request.getParameter("tsid");
		ResultDto resultDto = new ResultDto();
		String z=bt+qssj+zzsj+grzh+zlx+tslxid+issh+sfcl+sfyc+jsbh+tsid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			Map<String, Object> map = wjdcService.sreachTSINFO(tsid, bt, qssj, zzsj, grzh, zlx, tslxid, page, limit, issh,
					sfcl, sfyc, jsbh);
			List<M_TSXQ> list = (List<M_TSXQ>) map.get("list");
			int total = (int) map.get("total");
			resultDto.setData(list);
			resultDto.setTotal(total);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 查询角色是否能回复
	@RequestMapping("sreachISHF")
	@ResponseBody
	public ResultDto sreachISHF(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String bjsbh = request.getParameter("bjsbh");
		String ajsbh = request.getParameter("ajsbh");
		String tsid = request.getParameter("tsid");
		String data=bjsbh+ajsbh+tsid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(data);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			resultDto = wjdcService.sreachISHF(tsid, ajsbh, bjsbh);
		}
		return resultDto;
	}

	// 添加回复
	@RequestMapping("addHFInfo")
	@ResponseBody
	public ResultDto addHFInfo(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String hfnr = request.getParameter("hfnr");
		String tsid = request.getParameter("tsid");
		String z=hfnr+tsid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			boolean flag = wjdcService.addHFInfo(hfnr, tsid);
			resultDto.setData(flag);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 回复是否隐藏
	@RequestMapping("hfSFYC")
	@ResponseBody
	public ResultDto hfSFYC(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String tsid = request.getParameter("tsid");
		String sfyc = request.getParameter("sfyc");
		String z=tsid+sfyc;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			boolean flag = wjdcService.hfSFYC(sfyc, tsid);
			resultDto.setData(flag);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 问卷调查答案统计
	@RequestMapping("wjdcdaanTJ")
	@ResponseBody
	public ResultDto wjdcdaanTJ(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String wjid = request.getParameter("wjid");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(wjid);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<WJDCDAANTJDto> list = wjdcService.wjdcdaanTJ(wjid);
			resultDto.setData(list);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 问卷调查答案统计
	@RequestMapping("zxrdytspx")
	@ResponseBody
	public ResultDto zxrdytspx(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String lx = request.getParameter("lx");
		String qssj = request.getParameter("qssj");
		String zzsj = request.getParameter("zzsj");
		String z=lx+qssj+zzsj;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<ZiXunReDianTSPXDto> list = wjdcService.zxrdytspx(qssj, zzsj, lx);
			resultDto.setData(list);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 修改回复内容
	@RequestMapping("updateHFNR")
	@ResponseBody
	public ResultDto updateHFNR(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String hfnr = request.getParameter("hfnr");
		String tsid = request.getParameter("tsid");
		String z=hfnr+tsid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			boolean flag = wjdcService.updateHFNR(tsid, hfnr);
			resultDto.setData(flag);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 查询投诉列表
	@RequestMapping("search_GR_TSJYS")
	@ResponseBody
	public ResultDto query(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String grzh = request.getParameter("grzh");
		String zlx = request.getParameter("zlx");
		String pageNumber = request.getParameter("pageNumber");
		String pageSize = request.getParameter("pageSize");
		String z=grzh+zlx+pageNumber+pageSize;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<M_TSXQ> listm_tsxq = wjdcService.query(zlx, grzh, pageNumber, pageSize);
			if (listm_tsxq.size() > 0) {
				resultDto.setSuccess(true);
			} else {
				resultDto.setSuccess(false);
			}
			resultDto.setData(listm_tsxq);	
		}
		
		return resultDto;
	}

	// 查询投诉详情
	@RequestMapping("search_GR_TSJY")
	@ResponseBody
	public ResultDto tsxqSreach(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String tisd = request.getParameter("tsid");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(tisd);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<M_TSXQ> listm_tsxq = wjdcService.tsxqSreach(tisd);
			if (listm_tsxq.size() > 0) {
				resultDto.setSuccess(true);
			} else {
				resultDto.setSuccess(false);
			}
			resultDto.setData(listm_tsxq);
		}
		
		return resultDto;
	}

	@RequestMapping("TslxAdvisorySort")
	@ResponseBody
	public ResultDto TslxAdvisorySort(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String zlx = request.getParameter("zlx");
		String year = request.getParameter("year");
		String z=zlx+year;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<TslxAdvisorySortDto> list = wjdcService.TslxAdvisorySort(zlx, year);
			resultDto.setSuccess(true);
			resultDto.setData(list);
		}
		return resultDto;
	}

	@RequestMapping("insertZhiShiKuJiLu")
	@ResponseBody
	public ResultDto insertZhiShiKuJiLu(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 问题id
		String problemid = request.getParameter("problemid");
		// 答案id
		String answerid = request.getParameter("answerid");
		String z=problemid+answerid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			resultDto = wjdcService.insertZhiShiKuJiLu(problemid, answerid);
		}
		return resultDto;
	}

	@RequestMapping("updateTSHFSHState")
	@ResponseBody
	public ResultDto updateTSHFSHState(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 投诉ID
		String tsid = request.getParameter("tsid");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(tsid);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			resultDto = wjdcService.updateTSHFSHState(tsid);
		}
		return resultDto;
	}

	// 知识库父级目录
	@RequestMapping("treemenuML")
	@ResponseBody
	public ResultDto treemenuML(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		List<M_ZHISHIKUMULU> list = wjdcService.treemenuML();
		resultDto.setSuccess(true);
		resultDto.setData(list);
		return resultDto;
	}

	// 知识库父级目录
	@RequestMapping("fjml")
	@ResponseBody
	public ResultDto fjml(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		List<M_ZHISHIKUMULU> data = wjdcService.fjml();
		resultDto.setSuccess(true);
		resultDto.setData(data);
		return resultDto;
	}

	// 知识库子级目录
	@RequestMapping("zjml")
	@ResponseBody
	public ResultDto zjml(HttpServletRequest request) {
		String lanmuid = request.getParameter("lanmuid");
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(lanmuid);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<M_ZHISHIKUMULU> data = wjdcService.zjml(lanmuid);
			resultDto.setSuccess(true);
			resultDto.setData(data);
		}
		return resultDto;
	}

	// 查询栏目
	@RequestMapping("selectLanMu")
	@ResponseBody
	public ResultDto selectLanMu(HttpServletRequest request) {
		String lanmuid = request.getParameter("lanmuid");
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(lanmuid);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<M_ZHISHIKUMULU> data = wjdcService.selectLanMu(lanmuid);
			resultDto.setSuccess(true);
			resultDto.setData(data);
		}
		return resultDto;
	}

	// 投诉、建议、咨询 问题派发，修改角色编码
	@RequestMapping("wentiPF")
	@ResponseBody
	public ResultDto wentiPF(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 投诉id
		String tsid = request.getParameter("tsid");
		// 角色编号
		String jsbh = request.getParameter("jsbh");
		// 文章是否处理
		String iscl = request.getParameter("iscl");
		String data=tsid+jsbh+iscl;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(data);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			resultDto = wjdcService.wentiPF(jsbh, tsid, iscl);
		}
		return resultDto;
	}

	// 记录互动交流日志
	@RequestMapping("hdjl_logging")
	@ResponseBody
	public ResultDto hdjl_logging(HttpServletRequest request) {
		//标题
		String title= request.getParameter("title");
		//类型
		String lx= request.getParameter("lx");
		//操作人
		String czr= request.getParameter("czr");
		//操作状态
		String czzt= request.getParameter("czzt");
		String z=title+lx+czr+czzt;
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			resultDto = wjdcService.hdjl_logging(title, lx, czr, czzt);
		}
		return resultDto;
	}
	
	// 记录互动交流日志查询
		@RequestMapping("hdjl_logging_select")
		@ResponseBody
		public ResultDto hdjl_logging_select(HttpServletRequest request) {
			Integer page = Integer.parseInt(request.getParameter("page"));
			Integer limit = Integer.parseInt(request.getParameter("limit"));
			String lx= request.getParameter("lx");
			ResultDto resultDto = new ResultDto();
			boolean a=QuDaoXinXiGuanLiController.SqlFilter2(lx);
			if(a){
				resultDto.setData(0);
				resultDto.setMessage("存在sql注入");
				resultDto.setSuccess(false);
			}else{
				Map<String, Object> map = wjdcService.hdjl_logging_select(page, limit, lx);
				List<HdjlLoggingDto> list = (List<HdjlLoggingDto>) map.get("list");
				int total = (int) map.get("total");
				resultDto.setData(list);
				resultDto.setTotal(total);
				resultDto.setSuccess(true);
			}
			return resultDto;
		}

}
