package com.changda.gjjapp.zhfwpt.dao.homepage;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.changda.cd4j.foundation.core.persistence.annotation.MyBatisDao;
import com.changda.gjjapp.zhfwpt.dto.homepage.ComplaintRateDto;
import com.changda.gjjapp.zhfwpt.dto.homepage.LoginCountDto;
import com.changda.gjjapp.zhfwpt.dto.homepage.MydInfoDto;
import com.changda.gjjapp.zhfwpt.dto.homepage.SelectRCAndSl;
import com.changda.gjjapp.zhfwpt.dto.homepage.YwSortTop5Dto;

@MyBatisDao
public interface HomePageDao {
	
	/**
	 * 投诉人数
	 * @param year
	 * @return
	 */
	ComplaintRateDto complaintRate(@Param("year")String year);
	
	
	/**
	 * 问卷调查插入
	 * @param tpxx 投票选项
	 * @param username 用户名
	 * @param grzh 个人账号
	 * @param qdid 渠道id
	 * @return
	 */
	int insertWjdcInfo(@Param("tpxx")String tpxx,@Param("username")String username,@Param("grzh")String grzh,@Param("qdid")String qdid);
	
	/**
	 * 插入问卷调查状态如果今天已插入返回数据
	 * @param grzh
	 * @return
	 */
	int wjdcZT(@Param("grzh")String grzh);
	
	/**
	 * 满意度插入办理详情表统计
	 * @param qdid
	 * @param ywlx
	 * @param grzh
	 * @param sqr
	 * @return
	 */
	int insertWJDCXZ(@Param("qdid")String qdid,@Param("ywlx")String ywlx,@Param("ywzt")String ywzt,@Param("grzh")String grzh,@Param("sqr")String sqr);
	
	/**
	 * 查询业务办理中前五的数据
	 * @return
	 */
	List<YwSortTop5Dto> ywsortTop5();
	
	/**
	 * 满意度调查占比
	 */
	List<MydInfoDto> mydInfo(@Param("year")String year);
	
	/**
	 * 各时间段各渠道登录次数
	 * @return
	 */
	List<LoginCountDto> loginCount();
	
	/**
	 * 查询当天登录人次和登录次数
	 * @return
	 */
	List<SelectRCAndSl> selectRCAndSl();
}
