package com.changda.gjjapp.zhfwpt.dao.yhxxgl;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.changda.cd4j.foundation.core.persistence.annotation.MyBatisDao;
import com.changda.gjjapp.db.entity.WXN_USER;
import com.changda.gjjapp.zhfwpt.dto.yhxxgl.YhxxLoggingDto;

@MyBatisDao
public interface YHXXGLDao {

    /**
     * 用户信息管理 重置密码
     *
     * @param zjhm 证件号码
     * @param grzh 个人账号
     * @param pwd  密码
     */
    int updatePwd(@Param("dbserver") String dbserver,@Param("zjhm") String zjhm, @Param("grzh") String grzh, @Param("pwd") String pwd);

    /**
     * 用户信息查询
     *
     * @param zjhm     证件号码
     * @param grzh     个人账户
     * @param xingming 姓名
     * @param zhucerq  个人账户注册日期
     * @param denglurq 登陆日期
     * @return
     */
    List<WXN_USER> yongHuXinXiSearch(@Param("yhlb")String yhlb,@Param("dbserver") String dbserver,@Param("data") String data, @Param("zckssj") String zckssj, @Param("zcjssj") String zcjssj, @Param("dlkssj") String dlkssj, @Param("dljssj") String dljssj);

    /**
     * 修改用户信息
     * @param grzh 个人账户
     * @param xingbie 性别
     * @param xmqp 姓名全拼
     * @param csny 出生年月
     * @return
     */
    int userInfoUpdate(@Param("grzh")String grzh,@Param("xingbie")String xingbie,@Param("xmqp")String xmqp,@Param("csny")String csny);
    
    /**
     * 修改用户注销状态
     * @param grzh 个人账号
     * @param iszx 是否注销
     * @return
     */
    int iszx(@Param("grzh")String grzh,@Param("iszx")String iszx,@Param("zxbz")String zxbz);
    
    /**
     * 注销状态
     * @param grzh
     * @return
     */
    String zxzt(@Param("grzh")String grzh);
    
    /**
     * 用户登录记录
     * @return
     */
    int userLoginRecording(@Param("grzh")String grzh);
    
    /**
     * 个人刷新次数
     * @param grzh
     * @return
     */
    int grsxCount(@Param("grzh")String grzh);
    
    /**
     * 用户信息日志记录
     * @param username
     * @param czr
     * @param czzt
     * @return
     */
    int yhxx_logging(@Param("username")String username,@Param("czr")String czr,@Param("czzt")String czzt);
    
    /**
     * 用户信息日志记录查询
     * @return
     */
    List<YhxxLoggingDto> yhxx_logging_select();
}
