package com.changda.gjjapp.zhfwpt.service.impl.qdxxgl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.changda.gjjapp.db.entity.S_YWZD;
import com.changda.gjjapp.zhfwpt.dao.qdxxgl.QuDaoYeWuBanLiShuDao;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.GqdywblslDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.HtjkDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdfwnldTjDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdgsjdTJDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdywblInFoDto;
import com.changda.gjjapp.zhfwpt.service.qdxxgl.QuDaoYeWuBanLiShuService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.thoughtworks.xstream.mapper.Mapper.Null;

@Service()
public class QuDaoYeWuBanLiShuServiceImp implements QuDaoYeWuBanLiShuService {

	@Autowired
	private QuDaoYeWuBanLiShuDao QuDaoYeWuBanLiShuDao;

	/**
	 * 单位渠道业务办理数量（成功、失败、待处理）显示
	 */
	@Override
	public List<GqdywblslDto> dWQuDaoBanLiShuL(String qssj, String zzsj, String num) {
		List<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
		if (num.trim().equals("01") || num.trim() == "01") {
			// 按照年月查
			data = QuDaoYeWuBanLiShuDao.dWQuDaoBanLiShuLTwo(qssj, zzsj);
		} else if (num.equals("02") || num.trim() == "02") {
			// 按照年月日查
			data = QuDaoYeWuBanLiShuDao.dWQuDaoBanLiShuL(qssj, zzsj);
		}
		List<GqdywblslDto> list = new ArrayList<>();
		int gmblzsl = 0;
		int wtblzsl = 0;
		int gmblcgzsl = 0;
		int wtblcgzsl = 0;
		int gmblsbzsl = 0;
		int wtblsbzsl = 0;
		int gmclzzsl = 0;
		int wtclzzsl = 0;
		GqdywblslDto gDto2 = new GqdywblslDto();
		for (Map<String, Object> qddwbll : data) {
			GqdywblslDto gDto = new GqdywblslDto();
			gDto.setYwmc(qddwbll.get("YWMC").toString());

			int cggm = Integer.parseInt(qddwbll.get("CGGM").toString());
			int sbgm = Integer.parseInt(qddwbll.get("SBGM").toString());
			int clzgm = Integer.parseInt(qddwbll.get("CLZGM").toString());
			int gmsl = cggm + sbgm + clzgm;
			gmblzsl = gmblzsl + gmsl;
			gmblcgzsl = gmblcgzsl + cggm;
			gmblsbzsl = gmblsbzsl + sbgm;
			gmclzzsl = gmclzzsl + clzgm;

			int cgwt = Integer.parseInt(qddwbll.get("CGWT").toString());
			int sbwt = Integer.parseInt(qddwbll.get("SBWT").toString());
			int clzwt = Integer.parseInt(qddwbll.get("CLZWT").toString());
			int wtsl = cgwt + sbwt + clzwt;
			wtblzsl = wtblzsl + wtsl;
			wtblcgzsl = wtblcgzsl + cgwt;
			wtblsbzsl = wtblsbzsl + sbwt;
			wtclzzsl = wtclzzsl + clzwt;
			gDto.setGmsl(gmsl);
			gDto.setWtsl(wtsl);

			gDto.setCggm(Integer.parseInt(qddwbll.get("CGGM").toString()));
			gDto.setCgwt(Integer.parseInt(qddwbll.get("CGWT").toString()));
			gDto.setSbgm(Integer.parseInt(qddwbll.get("SBGM").toString()));
			gDto.setSbwt(Integer.parseInt(qddwbll.get("SBWT").toString()));
			gDto.setClzgm(Integer.parseInt(qddwbll.get("CLZGM").toString()));
			gDto.setClzwt(Integer.parseInt(qddwbll.get("CLZWT").toString()));
			list.add(gDto);
		}

		gDto2.setGmblzsl(gmblzsl);
		gDto2.setWtblzsl(wtblzsl);
		gDto2.setGmblcgzsl(gmblcgzsl);
		gDto2.setWtblcgzsl(wtblcgzsl);
		gDto2.setGmblsbzsl(gmblsbzsl);
		gDto2.setWtblsbzsl(wtblsbzsl);
		gDto2.setGmclzzsl(gmclzzsl);
		gDto2.setWtclzzsl(wtclzzsl);
		list.add(gDto2);
		return list;
	}

	/**
	 * 个人渠道业务办理数量（成功、失败、待处理）显示
	 */
	@Override
	public List<GqdywblslDto> GrQuDaoBanLiShuL(String qssj, String zzsj, String num) {
		List<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
		if (num.trim().equals("01") || num.trim() == "01") {
			// 按照年月查
			data = QuDaoYeWuBanLiShuDao.GrQuDaoBanLiShuLTwo(qssj, zzsj);
		} else if (num.equals("02") || num.trim() == "02") {
			// 按照年月日查
			data = QuDaoYeWuBanLiShuDao.GrQuDaoBanLiShuL(qssj, zzsj);
		}

		int tjgmblzsl = 0;

		int tjwtblzsl = 0;

		int tjappblzsl = 0;

		int tjwxblzsl = 0;

		int tjgmcgblzsl = 0;

		int tjwtcgblzsl = 0;

		int tjappcgblzsl = 0;

		int tjwxcgblzsl = 0;

		int tjwtsbblzsl = 0;

		int tjwxsbblzsl = 0;

		int tjappsbblzsl = 0;

		int tjgmsbblzsl = 0;

		int tjgmclzblzsl = 0;

		int tjwtclzblzsl = 0;

		int tjwxclzblzsl = 0;

		int tjappclzblzsl = 0;

		GqdywblslDto gDto2 = new GqdywblslDto();
		
		List<GqdywblslDto> list = new ArrayList<>();
		for (Map<String, Object> qddwbll : data) {
			GqdywblslDto gDto = new GqdywblslDto();
			gDto.setYwmc(qddwbll.get("YWMC").toString());
			gDto.setYwlx(qddwbll.get("BM").toString());
			int clzgm = Integer.parseInt(qddwbll.get("CLZGM").toString());
			int sbgm = Integer.parseInt(qddwbll.get("SBGM").toString());
			int cggm = Integer.parseInt(qddwbll.get("CGGM").toString());

			int gmsl = clzgm + sbgm + cggm;
			tjgmblzsl = tjgmblzsl + gmsl;
			tjgmcgblzsl = tjgmcgblzsl + cggm;
			tjgmsbblzsl = tjgmsbblzsl + sbgm;
			tjgmclzblzsl =tjgmclzblzsl + clzgm;
			
			int clzwt = Integer.parseInt(qddwbll.get("CLZWT").toString());
			int sbwt = Integer.parseInt(qddwbll.get("SBWT").toString());
			int cgwt = Integer.parseInt(qddwbll.get("CGWT").toString());

			int wtsl = clzwt + sbwt + cgwt;
			tjwtblzsl = tjwtblzsl + wtsl;
			tjwtcgblzsl = tjwtcgblzsl + cgwt;
			tjwtsbblzsl = tjwtsbblzsl + sbwt;
			tjwtclzblzsl = tjwtclzblzsl + clzwt;
			
			int clzapp = Integer.parseInt(qddwbll.get("CLZAPP").toString());
			int sbapp = Integer.parseInt(qddwbll.get("SBAPP").toString());
			int cgapp = Integer.parseInt(qddwbll.get("CGAPP").toString());

			int appsl = clzapp + sbapp + cgapp;
			tjappblzsl = tjappblzsl + appsl;
			tjappcgblzsl = tjappcgblzsl + cgapp;
			tjappsbblzsl = tjappsbblzsl + sbapp;
			tjappclzblzsl = tjappclzblzsl+clzapp;
			
			int clzwx = Integer.parseInt(qddwbll.get("CLZWX").toString());
			int sbwx = Integer.parseInt(qddwbll.get("SBWX").toString());
			int cgwx = Integer.parseInt(qddwbll.get("CGWX").toString());

			int wxsl = clzwx + sbwx + cgwx;
			tjwxblzsl = tjwxblzsl + wxsl;
			tjwxcgblzsl = tjwxcgblzsl + cgwx;
			tjwxsbblzsl = tjwxsbblzsl + sbwx;
			tjwxclzblzsl = tjwxclzblzsl + clzwx;
			
			gDto.setGmsl(gmsl);
			gDto.setWtsl(wtsl);
			gDto.setAppsl(appsl);
			gDto.setWxsl(wxsl);
			gDto.setCggm(Integer.parseInt(qddwbll.get("CGGM").toString()));
			gDto.setCgwt(Integer.parseInt(qddwbll.get("CGWT").toString()));
			gDto.setCgapp(Integer.parseInt(qddwbll.get("CGAPP").toString()));
			gDto.setCgwx(Integer.parseInt(qddwbll.get("CGWX").toString()));
			gDto.setSbgm(Integer.parseInt(qddwbll.get("SBGM").toString()));
			gDto.setSbwt(Integer.parseInt(qddwbll.get("SBWT").toString()));
			gDto.setSbapp(Integer.parseInt(qddwbll.get("SBAPP").toString()));
			gDto.setSbwx(Integer.parseInt(qddwbll.get("SBWX").toString()));
			gDto.setClzgm(Integer.parseInt(qddwbll.get("CLZGM").toString()));
			gDto.setClzwt(Integer.parseInt(qddwbll.get("CLZWT").toString()));
			gDto.setClzapp(Integer.parseInt(qddwbll.get("CLZAPP").toString()));
			gDto.setClzwx(Integer.parseInt(qddwbll.get("CLZWX").toString()));
			list.add(gDto);
		}
		gDto2.setTjgmblzsl(tjgmblzsl);
		gDto2.setTjwtblzsl(tjwtblzsl);
		gDto2.setTjappblzsl(tjappblzsl);
		gDto2.setTjwxblzsl(tjwxblzsl);
		
		gDto2.setTjgmcgblzsl(tjgmcgblzsl);
		gDto2.setTjwtcgblzsl(tjwtcgblzsl);
		gDto2.setTjwxcgblzsl(tjwxcgblzsl);
		gDto2.setTjappcgblzsl(tjappcgblzsl);
		
		gDto2.setTjwtsbblzsl(tjwtsbblzsl);
		gDto2.setTjwxsbblzsl(tjwxsbblzsl);
		gDto2.setTjgmsbblzsl(tjgmsbblzsl);
		gDto2.setTjappsbblzsl(tjappsbblzsl);
		
		gDto2.setTjgmclzblzsl(tjgmclzblzsl);
		gDto2.setTjwtclzblzsl(tjwtclzblzsl);
		gDto2.setTjwxclzblzsl(tjwxclzblzsl);
		gDto2.setTjappclzblzsl(tjappclzblzsl);
	
		list.add(gDto2);
		return list;
	}

	/**
	 * 后台监控所有渠道的业务办理实时监控
	 */
	@Override
	public Map<String, Object> htjkMonitor(String ywlx, String qdid, String qssj, String zzsj, int page, int limit) {
		Map<String, Object> map = new HashMap<>();
		Page<HtjkDto> page2 = PageHelper.startPage(page, limit, true);
		List<HtjkDto> data = QuDaoYeWuBanLiShuDao.htjkMonitor(ywlx, qdid, qssj, zzsj);
		int count = (int) page2.getTotal();
		map.put("data", data);
		map.put("total", count);
		return map;
	}

	/**
	 * 渠道业务办理信息双击弹窗
	 */
	@Override
	public List<QdywblInFoDto> qdywblInFo(String ywlx) {
		List<QdywblInFoDto> list = QuDaoYeWuBanLiShuDao.qdywblInFo(ywlx);
		return list;
	}

	/**
	 * 后台监控业务下拉框
	 */
	@Override
	public List<S_YWZD> htjkywlx(String ywfl, String czlx) {
		List<Map<String, Object>> dataList = QuDaoYeWuBanLiShuDao.htjkywlx(ywfl, czlx);
		List<S_YWZD> list = new ArrayList<S_YWZD>();
		for (Map<String, Object> map : dataList) {
			S_YWZD sYwzd = new S_YWZD();
			sYwzd.setYWLXID(map.get("YWLXID").toString());
			sYwzd.setBM(map.get("BM").toString());
			sYwzd.setYWMC(map.get("YWMC").toString());
			sYwzd.setYWFL(Integer.parseInt(map.get("YWFL").toString()));
			sYwzd.setYWCZLX(map.get("YWCZLX").toString());
			sYwzd.setSORT(Integer.parseInt(map.get("SORT").toString()));
			list.add(sYwzd);
		}
		return list;
	}

	// 渠道业务各年龄段办理数统计
	@Override
	public List<QdfwnldTjDto> qdywblgnldTj(String qssj, String zzsj, String ywbm) {

		return QuDaoYeWuBanLiShuDao.qdywblgnldTj(qssj, zzsj, ywbm);
	}

	// 渠道各时间段业务办理统计
	@Override
	public List<QdgsjdTJDto> qdywnldblTJ(String qssj, String zzsj, String ywbm) {

		return QuDaoYeWuBanLiShuDao.qdywsjdblTJ(qssj, zzsj, ywbm);
	}

}
