package com.changda.gjjapp.zhfwpt.service.impl.tyfb;

import java.io.BufferedReader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XMLUtil {
	

	public static void printMap(Map<String, Object> xml2Json) {
		Set<String> keySet = xml2Json.keySet();
		for (String key : keySet) {
			Object value = xml2Json.get(key);
			if (value instanceof List) {
				for (Map<String, Object> map : (List<Map<String, Object>>)value) {
					printMap((Map<String, Object>) map);
				}
			}else{
				System.out.print(key+" : "+value+"\t");
			}
		}
		System.out.println("");
	}

	public static Map<String,Object> xml2Json(Element root){
		Map<String,Object> json = new HashMap<String, Object>();
		if(root==null||!root.hasContent()){
			return json;
		}
		List<Element> list = root.elements();
		if(list!=null&&!list.isEmpty()){
			List<Map<String, Object>> listMaps = new ArrayList<Map<String,Object>>();
			for(Element e:list){//遍历每个节点  
				List<Attribute> attributes = e.attributes();
				for (Attribute attribute : attributes) {
					String atext = readAttrText(e,attribute.getName());
					if (StringUtils.isNotEmpty(atext.trim())) {
						json.put(attribute.getName(),atext);
					}
				}
				json.put("item",xml2JsonArray(e));
			}
		}
		return json;
	}

	public static List<Map<String,Object>> xml2JsonArray(Element root){
		List<Map<String,Object>> json = new ArrayList<Map<String,Object>>();
		if(root==null||!root.hasContent()){
			return json;
		}
		List<Element> list = root.elements();
		if(list!=null&&!list.isEmpty()){
			for(Element e:list){//遍历每个节点  
				Map<String,Object> map = new HashMap<String, Object>();
				List<Attribute> attributes = e.attributes();
				for (Attribute attribute : attributes) {
					String atext = readAttrText(e,attribute.getName());
					if (StringUtils.isNotEmpty(atext.trim())) {
						map.put(attribute.getName(),atext);
					}
					Object id = map.get("id");
					if (id!=null) {
						List<Map<String, Object>> listMap = xml2JsonArray(e);
						if (!listMap.isEmpty()) {
							map.put("item",listMap);
						}
					}
				}
				json.add(map);
			}
		}

		return json;
	}


	private static String readAttrText(Element e,String name){
		return e.attribute(name)==null?"":e.attribute(name).getText();
	}

	/**
	 * 把 inputStream文本去读出来
	 * @param is
	 * @return
	 */
	public static String isToString(InputStream is){
		BufferedReader bf = new BufferedReader(new InputStreamReader(is));
		String str = null;
		StringBuffer sb = new StringBuffer();
		try {
			while ((str=bf.readLine())!=null) {
				sb.append(str);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			if (bf!=null) {
				try {
					bf.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return sb.toString();
	}
}
