package com.changda.gjjapp.zhfwpt.service.impl.wjdc;

import java.text.SimpleDateFormat;
import java.util.*;
import com.changda.gjjapp.zhfwpt.dto.wjdc.S_TSLXDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.TslxAdvisorySortDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.WJDCDAANTJDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.ZiXunReDianTSPXDto;

import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.alibaba.fastjson.JSON;
import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.db.entity.M_TSXQ;
import com.changda.gjjapp.zhfwpt.dao.wjdc.WJDCDao;
import com.changda.gjjapp.zhfwpt.dto.tyfb.TyfbLoggingDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.HdjlLoggingDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.M_WJDC_INFODto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.M_WJDC_ITEMDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.M_WJDC_ORDERDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.M_ZHISHIKUMULU;
import com.changda.gjjapp.zhfwpt.service.wjdc.WJDCService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;

/**
 * 投诉类型查询
 *
 * @author Administrator
 */
@Service()
public class WJDCImp implements WJDCService {
	@Autowired
	private WJDCDao wJDCDao;

	// 问卷信息查询
	@Override
	public List<M_WJDC_ORDERDto> sreachWJXX(String wjmc) {
		List<Map<String, Object>> data = wJDCDao.sreachWJXX(wjmc);
		List<M_WJDC_ORDERDto> list = new ArrayList<>();
		for (Map<String, Object> map : data) {
			M_WJDC_ORDERDto mDto = new M_WJDC_ORDERDto();
			mDto.setWjid(map.get("WJID").toString());
			mDto.setWjmc(map.get("WJMC").toString());
			if (map.get("SFQY").toString().equals("0")) {
				mDto.setSfqy("否");
			} else if (map.get("SFQY").toString().equals("1")) {
				mDto.setSfqy("是");
			}
			mDto.setWjzqkssj(map.get("WJZQKSSJ").toString());
			mDto.setWjzqjssj(map.get("WJZQJSSJ").toString());
			mDto.setCjsj(map.get("CJSJ").toString());
			list.add(mDto);
		}
		return list;
	}

	// 删除问卷问题答案
	@Override
	public boolean deleteWJ(String wjid) {
		int daAn = wJDCDao.deleteDA(wjid);
		int wt = wJDCDao.deleteWT(wjid);
		int wj = wJDCDao.deleteWJ(wjid);
		boolean flag = false;
		if (daAn > 0 && wt > 0 && wj > 0) {
			flag = true;
			return flag;
		} else {
			return flag;
		}

	}

	// 修改问卷信息
	@Override
	public boolean updateWJ(String wjmc, String sfqy, String wjzqkssj, String wjzqjssj, String wjid) {
		int num = wJDCDao.updateWJ(wjmc, sfqy, wjzqkssj, wjzqjssj, wjid);
		if (num > 0) {
			return true;
		} else {
			return false;
		}

	}

	// 添加问卷
	@Override
	public boolean addWJ(String wjmc, String sfqy, String wjzqkssj, String wjzqjssj) {
		int num = wJDCDao.addWJ(wjmc, sfqy, wjzqkssj, wjzqjssj);
		if (num > 0) {
			return true;
		} else {
			return false;
		}
	}

	// 问卷问题信息显示
	@Override
	public List<M_WJDC_INFODto> WJWTInfo(String wjid, String wtmc) {
		List<Map<String, Object>> data = wJDCDao.WJWTInfo(wjid, wtmc);
		List<M_WJDC_INFODto> list = new ArrayList<>();
		for (Map<String, Object> map : data) {
			M_WJDC_INFODto mDto = new M_WJDC_INFODto();
			mDto.setWjdcwtid(map.get("WJDCWTID").toString());
			mDto.setWjid(map.get("WJID").toString());
			mDto.setWtmc(map.get("WTMC").toString());
			mDto.setSfdx(map.get("SFDX").toString());
			mDto.setCjsj(map.get("CJSJ").toString());
			list.add(mDto);
		}
		return list;
	}

	// 删除问题答案
	@Override
	public boolean deleteWTDA(String wtid) {
		int num2 = wJDCDao.deleteDAAN(wtid);
		int num = wJDCDao.deleteWenTi(wtid);
		if (num > 0 && num2 > 0) {
			return true;
		} else {
			return false;
		}

	}

	// 问卷调查问题信息编辑
	@Override
	public List<M_WJDC_INFODto> wjdcWTINFO(String wjid, String wjdcwtid) {
		List<Map<String, Object>> data = wJDCDao.wjdcWTINFO(wjid, wjdcwtid);
		List<M_WJDC_INFODto> list = new ArrayList<>();
		for (Map<String, Object> map : data) {
			M_WJDC_INFODto mDto = new M_WJDC_INFODto();
			mDto.setWjid(map.get("WJID").toString());
			mDto.setWjmc(map.get("WJMC").toString());
			mDto.setWjdcwtid(map.get("WJDCWTID").toString());
			mDto.setWtmc(map.get("WTMC").toString());
			mDto.setSfdx(map.get("SFDX").toString());
			list.add(mDto);
		}
		return list;
	}

	// 显示答案
	@Override
	public List<M_WJDC_ITEMDto> wjdcDAANInfo(String wtid) {
		List<Map<String, Object>> data = wJDCDao.daAnInfo(wtid);
		List<M_WJDC_ITEMDto> list = new ArrayList<>();
		for (Map<String, Object> map : data) {
			M_WJDC_ITEMDto mDto = new M_WJDC_ITEMDto();
			mDto.setWjdczbid(map.get("WJDCZBID").toString());
			mDto.setWjdcwtid(map.get("WJDCWTID").toString());
			mDto.setDaanmc(map.get("DAANMC").toString());
			mDto.setCjsj(map.get("CJSJ").toString());
			mDto.setWjid(map.get("WJID").toString());
			list.add(mDto);
		}
		return list;
	}

	// 新增问题答案
	@Override
	public boolean addWTAndDaAn(String data) {
		String s = UUID.randomUUID().toString();
		// 去掉"-"符号
		String guid = s.substring(0, 8) + s.substring(9, 13) + s.substring(14, 18) + s.substring(19, 23)
				+ s.substring(24);

		Map<String, Object> map = JSON.parseObject(data, Map.class);
		// 问卷id
		String wjid = map.get("wjid").toString();
		// 问卷名称
		String wtmc = map.get("wtmc").toString();
		// 是否多选
		String sfdx = map.get("sfdx").toString();

		int num = wJDCDao.addWT(guid, wjid, wtmc, sfdx);
		int num2 = 0;
		List<Object> list = (List<Object>) map.get("items");
		for (int i = 0; i < list.size(); i++) {
			Map<String, Object> daan = (Map<String, Object>) list.get(i);
			String da = daan.get("da").toString();
			if (da != null && !da.equals("")) {
				num2 = wJDCDao.addDaAn(guid, da, wjid);
			}
		}
		if (num > 0 && num2 > 0) {
			return true;
		} else {
			return false;
		}
	}

	// 编辑问题和答案
	@Override
	public boolean updateWT(String data) {
		String s = UUID.randomUUID().toString();
		// 去掉"-"符号
		String guid = s.substring(0, 8) + s.substring(9, 13) + s.substring(14, 18) + s.substring(19, 23)
				+ s.substring(24);

		Map<String, Object> map = JSON.parseObject(data, Map.class);
		// 问题id
		String wjdcwtid = map.get("wtid").toString();
		// 问卷名称
		String wtmc = map.get("wtmc").toString();
		// 是否多选
		String sfdx = map.get("sfdx").toString();
		// 问卷id
		String wjid = map.get("wjid").toString();

		// 修改问题信息
		int num = wJDCDao.updateWT(wjdcwtid, wtmc, sfdx);

		List<Object> list = (List<Object>) map.get("items");
		int num2 = 0;
		for (int i = 0; i < list.size(); i++) {
			Map<String, Object> map3 = (Map<String, Object>) list.get(i);
			String daAnMc = map3.get("da").toString();
			String daAnID = map3.get("id").toString();

			if (daAnID != null && daAnMc == null || daAnMc.equals("")) {
				// 删除这个答案
				num2 = wJDCDao.deleteDaAn(daAnID);
			} else if (daAnMc != null && daAnID == null || daAnID.equals("")) {
				// 新增答案
				num2 = wJDCDao.addDaAn(wjdcwtid, daAnMc, wjid);
			} else if (daAnMc != null && daAnID != null && !daAnID.equals("")) {
				// 修改答案
				num2 = wJDCDao.updateDaAn(daAnID, daAnMc);
			}

		}
		if (num > 0 && num2 > 0) {
			return true;
		} else {
			return false;
		}

	}

	// 网上调查 插入反馈表
	@Override
	public int insertFK(String data) {
		Map<String, Object> map = JSON.parseObject(data, Map.class);
		String qdid = map.get("qdid").toString();
		// 问卷id
		String wjid = map.get("wjid").toString();
		// 用户姓名
		String username = map.get("userName").toString();
		// 个人账号
		String grzh = map.get("grzh").toString();
		// 业务类型
		String ywlx = map.get("ywlx").toString();

		List<Object> list = (List<Object>) map.get("items");
		int num = 0;
		for (int i = 0; i < list.size(); i++) {
			Map<String, Object> map3 = (Map<String, Object>) list.get(i);
			// 问题id
			String wtid = map3.get("wtid").toString();
			// 答案id
			String daanid = map3.get("daanid").toString();

			num = wJDCDao.insertFK(wjid, wtid, daanid, username, grzh, qdid);
		}
		// 业务状态 待处理
		String ywzt = "0";

		if (num > 0) {
			// 成功
			ywzt = "1";
			wJDCDao.insertTSJYZX(qdid, ywlx, ywzt, grzh, username);
			return 1;
		} else {
			// 失败
			ywzt = "2";
			wJDCDao.insertTSJYZX(qdid, ywlx, ywzt, grzh, username);
			return 0;
		}

	}

	// 查询问卷
	@Override
	public List<M_WJDC_ORDERDto> sreachWj() {
		List<Map<String, Object>> wjData = wJDCDao.sreachWj();
		List<M_WJDC_ORDERDto> list = new ArrayList<>();
		for (Map<String, Object> wj : wjData) {
			M_WJDC_ORDERDto mDto = new M_WJDC_ORDERDto();
			mDto.setWjid(wj.get("WJID").toString());
			mDto.setWjmc(wj.get("WJMC").toString());
			mDto.setSfqy(wj.get("SFQY").toString());
			mDto.setWjzqkssj(wj.get("WJZQKSSJ").toString());
			mDto.setWjzqjssj(wj.get("WJZQJSSJ").toString());
			mDto.setCjsj(wj.get("CJSJ").toString());
			list.add(mDto);
		}
		return list;
	}

	// 查询问题和答案
	@Override
	public List<M_WJDC_INFODto> sreachDaAndWent(String data) {
		Map<String, Object> map = JSON.parseObject(data, Map.class);
		String wjid = map.get("wjid").toString();
		List<Map<String, Object>> wtData = wJDCDao.sreachWt(wjid);
		List<M_WJDC_INFODto> list = new ArrayList<>();
		for (Map<String, Object> wt : wtData) {
			String wtid = wt.get("WJDCWTID").toString();
			String wtmc = wt.get("WTMC").toString();
			String sfdx = wt.get("SFDX").toString();
			// 问题类
			M_WJDC_INFODto mdto = new M_WJDC_INFODto();
			mdto.setWtmc(wtmc);
			mdto.setWjdcwtid(wtid);
			mdto.setSfdx(sfdx);
			// 多个答案
			List<Map<String, Object>> daAn = wJDCDao.sreachDaAn(wtid);
			List<M_WJDC_ITEMDto> dAList = new ArrayList<M_WJDC_ITEMDto>();
			for (Map<String, Object> da : daAn) {
				// 答案类
				M_WJDC_ITEMDto idto = new M_WJDC_ITEMDto();
				idto.setWjdczbid(da.get("WJDCZBID").toString());
				idto.setDaanmc(da.get("DAANMC").toString());
				dAList.add(idto);
			}

			if (daAn.size() == 0) {
				dAList = null;
			}
			mdto.setM_wjdc_itemDto(dAList);
			list.add(mdto);

		}
		return list;
	}

	// 查询投诉类型
	@Override
	public List<S_TSLXDto> sreachTSType(String zlx) {
		List<Map<String, Object>> wsType = wJDCDao.sreachTSType(zlx);
		List<S_TSLXDto> list = new ArrayList<>();
		for (Map<String, Object> ws : wsType) {
			S_TSLXDto sDto = new S_TSLXDto();
			sDto.setCjsj(ws.get("CJSJ").toString());
			sDto.setLxmc(ws.get("LXMC").toString());
			sDto.setTslxid(ws.get("TSLXID").toString());
			list.add(sDto);
		}
		return list;
	}

	// 插入投诉建议
	@Override
	public int insertTS(String data) {
		Map<String, Object> map = JSON.parseObject(data, Map.class);
		// 投诉类型
		String tslxid = map.get("tslxid").toString();
		// 标题
		String bt = map.get("bt").toString();
		// 投诉内容
		String tsnr = map.get("tsnr").toString();
		// 用户姓名
		String yhxm = map.get("yhxm").toString();
		// 用户电话
		String yhdh = map.get("yhdh").toString();
		// 个人账号(个人账号有可能为空)
		String grzh = "";
		if (map.get("grzh").equals(" ") || map.get("grzh") == null) {
			grzh = " ";
		} else {
			grzh = map.get("grzh").toString();
		}
		// 渠道ID
		String qdid = map.get("qdid").toString();

		String ywlx = map.get("ywlx").toString();

		String sqr = map.get("sqr").toString();
		int num = wJDCDao.insertTS(tslxid, bt, tsnr, yhxm, yhdh, grzh, qdid);
		// 业务状态0待处理
		String ywzt = "0";
		if (num > 0) {
			// 业务状态1成功
			ywzt = "1";
			wJDCDao.insertTSJYZX(qdid, ywlx, ywzt, grzh, sqr);
			return 1;
		} else {
			// 业务状态失败
			ywzt = "2";
			wJDCDao.insertTSJYZX(qdid, ywlx, ywzt, grzh, sqr);
			return 0;
		}

	}

	// 查询投书详情
	@Override
	public Map<String, Object> sreachTSINFO(String tsid, String bt, String qssj, String zzsj, String grzh, String zlx,
			String tslxid, int page, int limit, String issh, String sfcl, String sfyc, String jsbh) {
		Map<String, Object> map = new HashMap<>();
		Page<M_TSXQ> page2 = PageHelper.startPage(page, limit, true);
		List<M_TSXQ> list = wJDCDao.sreachTSINFO(tsid, bt, qssj, zzsj, grzh, zlx, tslxid, issh, sfcl, sfyc, jsbh);
		int count = (int) page2.getTotal();
		map.put("total", count);
		map.put("list", list);
		return map;
	}

	// 提交回复内容
	@Override
	public boolean addHFInfo(String hfnr, String tsid) {
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");// 设置日期格式
		String hfsj = df.format(new Date()); // new Date()为获取当前系统时间

		int num = wJDCDao.addHFInfo(hfnr, tsid, hfsj);
		if (num > 0) {
			return true;
		} else {
			return false;
		}

	}

	// 回复是否隐藏
	@Override
	public boolean hfSFYC(String sfyc, String tsid) {
		int num = wJDCDao.hfSFYC(tsid, sfyc);
		if (num > 0) {
			return true;

		} else {
			return false;
		}

	}

	// 问卷调查答案统计
	@Override
	public List<WJDCDAANTJDto> wjdcdaanTJ(String wjid) {
		List<Map<String, Object>> data2 = wJDCDao.wjdcdaanTJ(wjid);
		List<WJDCDAANTJDto> list = new ArrayList<WJDCDAANTJDto>();
		String wtid = "";
		for (Map<String, Object> map : data2) {
			WJDCDAANTJDto wDto = new WJDCDAANTJDto();
			String wtid2 = map.get("WJDCWTID").toString();
			if (wtid.equals(wtid2)) {
				wDto.setWtmc(" ");
			} else {
				wDto.setWtmc(map.get("WTMC").toString());
			}
			wtid = map.get("WJDCWTID").toString();
			wDto.setWjdcwtid(wtid);
			wDto.setDaanid(map.get("WJDCZBID").toString());
			wDto.setDaanmc(map.get("DAANMC").toString());
			wDto.setDaAnShu(map.get("DAANSL").toString());

			String zb = map.get("ZB").toString();
			if (zb.equals("%")) {
				wDto.setZb("0%");
			} else {
				wDto.setZb(zb);
			}
			list.add(wDto);
		}

		return list;
	}

	// 咨询
	@Override
	public List<ZiXunReDianTSPXDto> zxrdytspx(String qssj, String zzsj, String lx) {
		List<Map<String, Object>> data = wJDCDao.zxrdytspx(qssj, zzsj, lx);
		List<ZiXunReDianTSPXDto> list = new ArrayList<ZiXunReDianTSPXDto>();
		for (Map<String, Object> map : data) {
			ZiXunReDianTSPXDto zDto = new ZiXunReDianTSPXDto();
			zDto.setTslxid(map.get("TSLXID").toString());
			zDto.setLxmc(map.get("LXMC").toString());
			zDto.setSl(map.get("SL").toString());
			list.add(zDto);
		}
		return list;
	}

	// 修改投诉内容
	@Override
	public boolean updateHFNR(String tsid, String hfnr) {
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");// 设置日期格式
		String hfsj = df.format(new Date()); // new Date()为获取当前系统时间
		int num = wJDCDao.updateHFNR(tsid, hfnr, hfsj);
		wJDCDao.updateTSHFSHState(tsid, 0);
		if (num > 0) {
			return true;
		} else {
			return false;
		}
	}

	// 投诉详情查询微信前端接口 不含内容回复
	@Override
	public List<M_TSXQ> query(String zlx, String grzh, String pageNumber, String pageSize) {
		int pageNum = Integer.parseInt(pageNumber);
		int pageSize2 = Integer.parseInt(pageSize);
		int sizeCountStart = (pageNum - 1) * pageSize2 + 1;
		int sizeCountEnd = pageNum * pageSize2;
		return wJDCDao.query(zlx, grzh, String.valueOf(sizeCountStart), String.valueOf(sizeCountEnd));
	}

	// 查询某一类型的十二个月的投诉数量
	@Override
	public List<TslxAdvisorySortDto> TslxAdvisorySort(String zlx, String year) {

		return wJDCDao.tslxAdvisorySort(zlx, year);
	}

	// 查询投诉详情
	@Override
	public List<M_TSXQ> tsxqSreach(String tsid) {
		return wJDCDao.tsxqSreach(tsid);
	}

	// 插入知识库调用记录
	@Override
	public ResultDto insertZhiShiKuJiLu(String problemid, String answerid) {
		ResultDto resultDto = new ResultDto();
		int num = wJDCDao.insertZhiShiKuJiLu(problemid, answerid);
		if (num > 0) {
			resultDto.setSuccess(true);
		} else {
			resultDto.setSuccess(false);
		}
		return resultDto;
	}

	// 修改投诉回复内容审核状态(审核按钮)
	@Override
	public ResultDto updateTSHFSHState(String tsid) {
		ResultDto resultDto = new ResultDto();
		int issh = 1;
		int num = wJDCDao.updateTSHFSHState(tsid, issh);
		if (num > 0) {
			resultDto.setSuccess(true);
		} else {
			resultDto.setSuccess(false);
		}
		return resultDto;
	}

	// 知识库父级目录
	@Override
	public List<M_ZHISHIKUMULU> treemenuML() {
		return wJDCDao.treemenuML();
	}

	// 知识库父级下拉框
	@Override
	public List<M_ZHISHIKUMULU> fjml() {
		// TODO Auto-generated method stub
		return wJDCDao.fjml();
	}

	// 知识库子级下拉框
	@Override
	public List<M_ZHISHIKUMULU> zjml(String lanmuid) {
		// TODO Auto-generated method stub
		return wJDCDao.zjml(lanmuid);
	}

	// 查询栏目
	@Override
	public List<M_ZHISHIKUMULU> selectLanMu(String lanmuid) {
		// TODO Auto-generated method stub
		return wJDCDao.selectLanMu(lanmuid);
	}

	// 查询角色是否能回复
	@Override
	public ResultDto sreachISHF(String tsid, String ajsbh, String bjsbh) {
		M_TSXQ tsxq = wJDCDao.sreachISHF(tsid);
		Map<String, String> map = new HashMap<>();
		ResultDto resultDto = new ResultDto();
		if (ajsbh.equals(tsxq.getJsbh()) && bjsbh.equals(tsxq.getJsbh())) {
			// 可回复
			map.put("ishf", "1");
			// 可下派
			map.put("isxf", "1");

			resultDto.setData(map);
			resultDto.setSuccess(true);
			return resultDto;
		} else if (ajsbh.equals(tsxq.getJsbh())) {
			// 可回复
			map.put("ishf", "1");
			// 可下派
			map.put("isxf", "1");
			resultDto.setData(map);
			resultDto.setSuccess(true);
			return resultDto;
		} else if (bjsbh.equals(tsxq.getJsbh())) {
			// 可回复
			map.put("ishf", "1");
			// 不可下发
			map.put("isxf", "0");
			resultDto.setData(map);
			resultDto.setSuccess(true);
			return resultDto;
		} else {
			// 不可回复
			map.put("ishf", "0");
			// 不可下发
			map.put("isxf", "0");
			resultDto.setData(map);
			resultDto.setSuccess(false);
			return resultDto;
		}
	}

	// 投诉、建议、咨询 问题派发，修改角色编码
	@Override
	public ResultDto wentiPF(String jsbh, String tsid, String iscl) {
		ResultDto resultDto = new ResultDto();
		int num = wJDCDao.wentiPF(jsbh, tsid);
		if (num > 0) {
			wJDCDao.updateCLZT(iscl, tsid);
			resultDto.setSuccess(true);
			return resultDto;
		} else {
			resultDto.setSuccess(false);
			return resultDto;
		}
	}

	// 记录互动交流日志
	@Override
	public ResultDto hdjl_logging(String title, String lx, String czr, String czzt) {
		ResultDto resultDto = new ResultDto();
		int num = wJDCDao.hdjl_logging(title, lx, czr, czzt);
		if (num > 0) {
			resultDto.setSuccess(true);
			return resultDto;
		} else {
			resultDto.setSuccess(false);
			return resultDto;
		}
	}

	// 记录互动交流日志查询
	@Override
	public Map<String, Object> hdjl_logging_select(int page, int limit, String lx) {
		Map<String, Object> map = new HashMap<>();
		Page<HdjlLoggingDto> page2 = PageHelper.startPage(page, limit, true);
		List<HdjlLoggingDto> list = wJDCDao.hdjl_logging_select(lx);
		int count = (int) page2.getTotal();
		map.put("total", count);
		map.put("list", list);
		return map;
	}

	@Override
	public int selectuserpd(String data) {
		Map<String, Object> map = JSON.parseObject(data, Map.class);
		// 用户姓名
		String yhxm = map.get("yhxm").toString();
		return wJDCDao.selectuserpd(yhxm);
	}

}
