package com.changda.gjjapp.zhfwpt.service.qdywquanxiankz;
/**
 * 渠道权限控制
 *
 * @author Administrator
 */

import java.text.ParseException;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.db.entity.M_XEKZB;
import com.changda.gjjapp.db.entity.M_YWZTKZ_2;
import com.changda.gjjapp.zhfwpt.dto.qdywqxgl.DuanXinQuanXianGuanLiDto;
import com.changda.gjjapp.zhfwpt.dto.qdywqxgl.FwkzLogginInfoDto;
import com.changda.gjjapp.zhfwpt.dto.qdywqxgl.QdzkLoggingInfoDto;
import com.changda.gjjapp.zhfwpt.dto.qdywqxgl.QuDaoQuanXianGuanLiDto;

public interface QuDaoQuanXianKongZhiService {
    /**
     * 查询渠道状态表用于管理渠道权限
     */
    List<QuDaoQuanXianGuanLiDto> quDaoZhuangTaiSearch(String primaryid);

 
    /**
     * 渠道状态实时状态控制
     */
    void quDaoSSKZ();

    /**
     * 修改渠道权限控制的开始时间和结束时间和阀值
     *
     * @param kssj 开始时间
     * @param jssj 结束时间
     * @param fz   阀值
     * @param qdid 渠道id
     */
    boolean updateTimeAndFz(String kssj, String jssj, String ksrq, String tzrq, String fz, String qdid, int qdzt);


    /**
     * 修改短信状态
     *
     * @param zjzxdm 资金中心代码
     * @param dxzt   短信状态
     */
    void updateDuanXinZT(String zjzxdm, String dxzt);
    
    
    /**
     * 渠道控制接口
     * @param qdid 渠道id
     * @return
     */
    List<QuDaoQuanXianGuanLiDto> qdkzInfo(String qdid);
    
    //定时调用在线时间是否超过待机时间
    void onlineUsers() throws ParseException;
    
    /**
     * 修改渠道状态
     * @param qdid
     * @param fz
     * @param djsj
     * @param qdzt
     * @return
     */
    ResultDto updateQDZT(String qdid,String fz,String djsj,String qdzt);
    
    /**
     * 业务控制2
     * @return
     */
    Map<String, Object> sreachM_YWZTKZ_2(int limit,int page,String ywczlx_2,String ywmc,String issh,String ywbm);
    
    /**
     * 修改业务状态(保存)
     * @param primaryid 主键
     * @param issh 是否审核
     * @param ywzt 业务状态
     * @param tzjssj 停止结束时间
     * @param tzkssj 停止开始时间
     * @return
     */
    ResultDto updateM_YWZTKZ_2State(String primaryid, String wtzt, String wxzt, String appzt, String znzdzt,String zh308zt, String sjzt,
                                    String qyjssj,String qykssj,String qyksrq,String qyjsrq,String czlx,String czr,String qysjd,String ywbm,String ywlb);
    
    /**
     * 渠道状态修改
     * @param qdzt 渠道状态
     * @param fz 阈值
     * @param djsj 待机时间
     * @param primaryid 主键ID
     * @return
     */
    ResultDto updateQD_state(String qdzt,String fz,String djsj,String primaryid,String qdid,String czr);
    
    /**
     * 渠道总控修改日志记录
     * @return
     */
    Map<String, Object> qdzkLoggingInfo(String qdid,String czsj,int page,int limit);
    
    /**
     * 修改审核后业务状态
     * @param primaryid 主键
     * @param shywzt 业务状态
     * @param shtzjssj 审核后停止结束时间
     * @param shtzkssj
     * @param shtzksrq
     * @param shtzjsrq
     * @return
     */
    ResultDto updateSHState(String primaryid,String czlx,String ywlb,String ywbm,String qysjd,String czr,String wxzt,String appzt,String znzdzt,String zh308zt, String sjzt, String wtzt);
    
    /**
     * 渠道业务控制 1.开启0.关闭
     * @return
     */
    int qdztkzInterface(String ywbm,String qdid);
    
    /**
     * 短信控制信息
     * @return
     */
    Map<String, Object> dxkzInfo(String pageNumber,String pageSize) throws Exception;
    
    /**
     * 限额控制信息
     * @return
     */
    List<M_XEKZB> xekzInfo();
    
    /**
     * 修改限额值
     * @param id
     * @return
     */
    ResultDto xeUpdate(String id,String value);
    
    /**
     * 服务控制日志
     * @param czsj
     * @return
     */
    Map<String, Object> fwkzLoggingInfo(int page,int limit,String ywbm);
    
  
}
