package com.changda.gjjapp.zhfwpt.service.tyfb;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.db.entity.M_LANMU;
import com.changda.gjjapp.db.entity.M_XWINFO;
import com.changda.gjjapp.zhfwpt.dto.tyfb.TyfbLoggingDto;
import com.changda.gjjapp.zhfwpt.dto.tyfb.UpdateNumDto;
import com.changda.gjjapp.zhfwpt.dto.tyfb.UpdateStatisticsDto;

import org.apache.ibatis.annotations.Param;

/**
 * 统一发布，新闻信息
 * 
 * @author Administrator
 *
 */
public interface TyfbxwInfoService {

	String XMLStructure(String lanmuid);

	/**
	 * 测试、获取栏目信息
	 */
	void lanmuInfo();
	
	void wsGetMultiInfos();

	/**
	 * 获取网站ID
	 */
	void getWZID();

	/**
	 * 树形列表的结构数据
	 * 
	 * @return
	 */
	List<M_LANMU> lanmuJG();

	/**
	 * 获取栏目信息
	 * 
	 * @param lanmuid
	 */
	int getLanMuInfo(String lanmuid);

	void insertInfo();

	/**
	 * 查询文章内容
	 * 
	 * @return
	 */
	Map<String, Object> query(String lanmuid, String title, String issh, String qssj, String zzsj, int page, int limit);

	/**
	 * 编辑页面栏目下拉框
	 * 
	 * @param lanmuid
	 * @return
	 */
	List<M_LANMU> lanmuXiaLa(String lanmuid);

	/**
	 * 插入文章内容
	 * 
	 * @param data
	 * @return
	 * @throws ParseException
	 * @throws Exception 
	 */
	ResultDto insertWZ(String data) throws ParseException, Exception;

	/**
	 * 审核文章
	 * 
	 * @param i_id
	 * @return
	 * @throws Exception 
	 */
	ResultDto reviewArticle(String i_id, String isyyfs) throws Exception;

	// 删除文章
	ResultDto deleteWz(String primaryid, String i_cataid);

	// 修改文章内容
	ResultDto updateWZ(String data) throws Exception;

	// 根据id查询文章内容
	List<M_XWINFO> searchWZ(String i_id);

	// 更新文章内容
	ResultDto updateWZContent(String i_cataid);

	// 获取栏目更新状态
	String getLanMuState(String lanmuid);

	// 查询各渠道栏目内容的更新
	List<UpdateNumDto> sreachUpdateContentNum(String year);

	// 栏目更新量统计
	List<UpdateStatisticsDto> updateStatistics(String time);
	
	//定时预约发送文章
	void sendArticle() throws Exception;
	
	//统一发布日志记录
	ResultDto logging_tyfb(String lanmuid,String iswx,String iswz,String isapp,String isznzd,String xwly,String zz,String xwsj,String czr,String czzt);
	
	/**
	 * 统一发布日志记录
	 * @return
	 */
	Map<String, Object> logging_tyfb_select(int page,int limit);
}
