package com.changda.gjjapp.zhfwpt.service.wjdc;

import java.util.List;
import java.util.Map;

import com.changda.gjjapp.zhfwpt.dto.wjdc.S_TSLXDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.TslxAdvisorySortDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.WJDCDAANTJDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.ZiXunReDianTSPXDto;

import org.apache.ibatis.annotations.Param;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.db.entity.M_TSXQ;
import com.changda.gjjapp.zhfwpt.dto.wjdc.M_WJDC_INFODto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.M_WJDC_ITEMDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.M_WJDC_ORDERDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.M_ZHISHIKUMULU;


public interface WJDCService {

    /**
     * 查询问卷信息
     *
     * @param wjmc 问卷名称
     */
    List<M_WJDC_ORDERDto> sreachWJXX(String wjmc);

    /**
     * 删除问卷、问题、答案
     *
     * @param wjid 问卷id
     */
    boolean deleteWJ(String wjid);

    /**
     * 修改问卷信息
     *
     * @param wjmc     问卷名称
     * @param sfqy     是否启用1.启用0.不启用
     * @param wjzqkssj 问卷周期开始时间
     * @param wjzqjssj 问卷周期结束时间
     * @param wjid     问卷id
     */
    boolean updateWJ(String wjmc, String sfqy, String wjzqkssj, String wjzqjssj, String wjid);

    /**
     * 添加问卷信息
     *
     * @param wjmc     问卷名称
     * @param sfqy     是否启用1.启用0.不启用
     * @param wjzqkssj 问卷周期开始时间
     * @param wjzqjssj 问卷周期结束时间
     */
    boolean addWJ(String wjmc, String sfqy, String wjzqkssj, String wjzqjssj);

    /**
     * 问卷问题信息查询
     *
     * @param wjid 问卷id
     * @return
     */
    List<M_WJDC_INFODto> WJWTInfo(String wjid, String wtmc);


    /**
     * 删除问题答案
     *
     * @param wtid
     * @return
     */
    boolean deleteWTDA(String wtid);

    /**
     * 问卷调查问题信息编辑
     *
     * @param wjid     问卷id
     * @param wjdcwtid 问卷调查问题id
     * @return
     */
    List<M_WJDC_INFODto> wjdcWTINFO(String wjid, String wjdcwtid);

    /**
     * 显示问题
     *
     * @param wtid 问题id
     * @return
     */
    List<M_WJDC_ITEMDto> wjdcDAANInfo(String wtid);


    /**
     * 新增问题和答案
     *
     * @param data
     * @return
     */
    boolean addWTAndDaAn(String data);

    /**
     * 修改问题和答案
     * data 参数
     *
     * @return
     */
    boolean updateWT(String data);

    /**
     * 网上调查 插入反馈表
     *
     * @param data
     * @return
     */
    int insertFK(String data);

    /**
     * 查询问卷
     * @return
     */
    List<M_WJDC_ORDERDto> sreachWj();

    /**
     * 查询答案
     *
     * @return
     */
    List<M_WJDC_INFODto> sreachDaAndWent(String data);

    /**
     * 查询投诉类型
     * @return
     */
    List<S_TSLXDto> sreachTSType(String zlx);

    /**
     * 插入投诉建议
     * @return`
     */
    int insertTS(String data);
    
    /**
     * 查询投诉详情
     * @return
     */
    Map<String, Object> sreachTSINFO(String tsid,String bt,String qssj,String zzsj,String grzh,String zlx,String tslxid,int page,int limit,String issh,String sfcl,String sfyc,String jsbh);
    
    /**
     * 查询角色是否回复
     * @param tsid
     * @param jsbh
     * @return
     */
    ResultDto sreachISHF(String tsid,String ajsbh,String bjsbh);
    
    /**
     * 提交回复内容
     * @param tsnr
     * @param tsid
     * @return
     */
    boolean addHFInfo(String tsid,String tsnr);
    
    /**
     * 是否隐藏回复
     * @param tsid 投诉id
     * @param sfyc 是否隐藏
     * @return
     */
    boolean hfSFYC(String sfyc,String tsid);
    
    /**
     * 问卷调查答案统计
     * @param wjid 问卷id
     * @return
     */
    List<WJDCDAANTJDto> wjdcdaanTJ(String wjid);
    
    /**
     * 咨询投诉热点排序
     */
    List<ZiXunReDianTSPXDto> zxrdytspx(String qssj,String zzsj,String lx);
    
    /**
     * 修改回复内容
     * @param tsid 投诉id
     * @param hfnr 回复内容
     * @return
     */
    boolean updateHFNR(String tsid,String hfnr);
    
    /**
     * 投诉详情查询微信前端接口 不含内容回复
     * @param map
     * @return
     */
    List<M_TSXQ> query(String zlx,String grzh,String pageNumber,String pageSize);
    
    /**
     * 查询某一类型的十二个月的投诉数量
     * @param zlx 投诉类型
     * @param year 年份
     * @return
     */
    List<TslxAdvisorySortDto> TslxAdvisorySort(String zlx,String year);
    
    /**
     * 查询投诉详情
     * @param tsid
     * @return
     */
    List<M_TSXQ> tsxqSreach(String tsid);
    
    /**
     * 插入知识库调用记录
     * @param primaryid 主键id
     * @param problemid 问题id
     * @param answerid  答案id
     * @param transfertime 调用时间
     * @return
     */
    ResultDto insertZhiShiKuJiLu(String problemid,String answerid);
    
    /**
     * 修改投诉回复内容审核状态
     * @param tsid
     * @return
     */
    ResultDto updateTSHFSHState(String tsid);
    
    /**
     * 知识库父级目录
     * @return
     */
    List<M_ZHISHIKUMULU> treemenuML();
    
    /**
     * 父级目录
     * @return
     */
    List<M_ZHISHIKUMULU> fjml();
    
    /**
     * 子级目录
     * @param lanmuid
     * @return
     */
    List<M_ZHISHIKUMULU> zjml(String lanmuid);
    
    /**
     * 查询栏目
     * @param lanmuid
     * @return
     */
    List<M_ZHISHIKUMULU> selectLanMu(String lanmuid);
    
    /**
     * 投诉、建议、咨询 问题派发，修改角色编码
     * @param jsbh 角色编号
     * @param tsid 投诉ID
     * @return
     */
    ResultDto wentiPF(String jsbh,String tsid,String iscl);
    
    /**
     * 记录互动交流日志
     * @param title
     * @param lx
     * @param czr
     * @param czzt
     * @param czsj
     * @param sfyc
     * @return
     */
    ResultDto hdjl_logging(String title,String lx,String czr,String czzt);
    
    /**
	 * 统一发布日志记录
	 * @return
	 */
	Map<String, Object> hdjl_logging_select(int page,int limit,String lx);
	
	int selectuserpd(String data);
}
