package com.changda.gjjapp.zhfwpt.service.zxhf;
/**
 * 咨询回复
 * @author Administrator
 *
 */

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.db.entity.M_ANSWER;
import com.changda.gjjapp.db.entity.M_ZXLX;
import com.changda.gjjapp.zhfwpt.dto.zxhf.ZhiShiKuDiaoYongTJTuDto;

public interface ZxhfService {

	// 咨询
	Map<String, Object> query(String title, String lanmuid, int page, int limit);
	
	//知识库统计分析投诉、建议、咨询页面展示
	Map<String, Object> query_ZhiShiKuTjPage(String year,String month);
	
	/**
	 * 知识库列表
	 * @param title
	 * @param lanmuid
	 * @return
	 */
	Map<String, Object> zhishikuList(String title,String lanmuid,int limit,int page);
	
	/**
	 * 答案信息
	 * @param primaryid
	 * @return
	 */
	M_ANSWER answerInfo(String primaryid);
	
	/**
	 * 新增知识库信息
	 * @param title
	 * @param lanmuid
	 * @param answer
	 * @param czr
	 * @return
	 */
	int addZhiShiKuInfo(String title,String lanmuid,String answer,String czr);

	/**
	 * 修改知识库信息
	 * @param title 标题
	 * @param lanmuid 栏目ID
	 * @param answer 答案
	 * @param czr 操作人
	 * @param primaryid 主键ID
	 * @return
	 */
	int updateZhiShiKuInfo(String title,String lanmuid,String answer,String czr,String primaryid);
	
	/**
	 * 删除知识库信息
	 * @param primaryid
	 * @return
	 */
	int deleteZhiShiKuInfo(String primaryid);
	
	/**
	 * 操作知识库日志记录
	 * @param title
	 * @param czr
	 * @param czzt
	 * @return
	 */
	ResultDto zsk_Logging(String title,String czr,String czzt,String lanmuid);
	
	/**
	 * 操作知识库日志记录查询
	 * @param page
	 * @param limit
	 * @return
	 */
	Map<String, Object> zsk_Logging_select(int page,int limit,String lanmuid);
}
