package com.changda.gjjapp.gedai.service.zhuyuehuakou;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.changda.gjjapp.db.entity.GD_MX;
import com.changda.gjjapp.db.entity.TMP_YW_GDHK_QKMX_WH;
import com.changda.gjjapp.gedai.dto.zhuyuehuakou.ZhuYueHuakouCompareDto;

/**
 * 对逐月划扣的人员进行检查
 * @author zdk
 *
 */
public interface IZhuYueHuaKouCheckService {
	
	/**
	 * 计算公积金个贷欠款及罚息明细
	 * @param GRDKBM 个人贷款编码
	 * @param HKKXQ 还款宽限期 0 无宽限期 >1 相应天数 99 当月任意日还款
	 * @param JXFS 复利利息计算方式：0 单利计息 1 复利计息
	 * @param ZNJFX 是否计算滞纳金罚息: 0 不计算 1 计算
	 * @param FXBS 罚息倍数s
	 * @param HKRQ 还款日期
	 * @return
	 */
	void  DRDK_QKMX(Date HKRQ,String zjzxdm,String dkyh,String kjqj);
	
	/**
	 * 查询逐月划扣用于显示
	 * @param kjqj
	 * @param zjzxdm
	 * @param dkyh
	 * @return
	 */
	Map<String, Object> zyhukData(String kjqj,String zjzxdm,String dkyh,int page,int limit);
	
	/**
	 * 查询逐月划扣数据
	 */
	List<Map<String, Object>> zyhk(String kjqj,String zjzxdm,String dkyh);

	/**
	 * 查询本月个人贷款编码
	 */
	List<Map<String, Object>> bYGRDKBM(String zjzxdm,String dkyh,String kjqj);
	
	/**
	 * 查询上月个人贷款编码
	 */
	List<Map<String, Object>> sygjjpkje(String kjqj,String zjzxdm,String dkyh);
	
	/**
	 * 计算公积金个贷欠款及罚息明细所需条件
	 * 查询 HKKXQ、JXFS、ZNJFX、FXBS
	 */
	String HKKXQ(String ZJZXDM,String YYWDDM,String TJYHBM,String YHBM,String ZTBM,String XTCSBM);

	/**
	 * 计算公积金个贷欠款及罚息明细所需条件
	 * 查询 HKKXQ、JXFS、ZNJFX、FXBS
	 */
	String FLLX(String ZJZXDM,String YYWDDM,String TJYHBM,String YHBM,String ZTBM,String XTCSBM);
	
	/**
	 * 计算公积金个贷欠款及罚息明细所需条件
	 * 查询 HKKXQ、JXFS、ZNJFX、FXBS
	 */
	String ZNJFX(String ZJZXDM,String YYWDDM,String TJYHBM,String YHBM,String ZTBM,String XTCSBM);
	
	/**
	 * 计算公积金个贷欠款及罚息明细所需条件
	 * 查询 HKKXQ、JXFS、ZNJFX、FXBS
	 */
	String FXBS(String ZJZXDM,String YYWDDM,String TJYHBM,String YHBM,String ZTBM,String XTCSBM);
	
	/**
	 * 查询个人资金代码
	 */
	String ZJZXDM(@Param("grdkbm")String GRDKBM);
	
	
	/**
	 * 获取扣划人员比对列表用于展示
	 * 涉及表 gd_grdkzz、GD_GJJZDHDSQ、gd_gthkr
	 * @return List
	 */
	List<ZhuYueHuakouCompareDto> getKouHuaRenYuanCompareList(String kjqj,int page,int limt);	

	/**
	 * 查询上月扣划金额
	 * @param grdkbm
	 * @param kjqj
	 * @return
	 */
	double getPKJE(String grdkbm,String kjqj);
	
	/**
	 * 把查询出的逐月划扣上月和本月的数据插入到jk_zyhkwh表中
	 */
	void insertJKZYHK(List<ZhuYueHuakouCompareDto> list);
	
}
