package com.changda.gjjapp.encryptor;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller()
@RequestMapping(value = "/encrypt")
public class EncryptController {

    @Autowired
    private StringEncryptor stringEncryptor;

    @ResponseBody
    @RequestMapping("/jasyptEnc")
    public ResultDto encrypt(String encStr) {
        ResultDto resultDto = new ResultDto();
        resultDto.setData(stringEncryptor.encrypt(encStr));
        resultDto.setSuccess(true);
        return resultDto;
    }


    @ResponseBody
    @RequestMapping("/jasyptDec")
    public ResultDto decrypt(String decStr) {
        ResultDto resultDto = new ResultDto();
        resultDto.setData(stringEncryptor.decrypt(decStr));
        resultDto.setSuccess(true);
        return resultDto;
    }
}
