package com.changda.gjjapp.encryptor;

import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.jasypt.spring4.properties.EncryptablePropertyPlaceholderConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DefaultResourceLoader;

@Configuration
public class EncryptorConfig {

    /*@Bean
    public StandardPBEStringEncryptor standardPBEStringEncryptor() {
        EnvironmentStringPBEConfig stringPBEConfig = new EnvironmentStringPBEConfig();
        stringPBEConfig.setAlgorithm("PBEWithMD5AndDES");
        stringPBEConfig.setPassword("root");
        StandardPBEStringEncryptor pbeStringEncryptor = new StandardPBEStringEncryptor();
        pbeStringEncryptor.setConfig(stringPBEConfig);
        return pbeStringEncryptor;
    }*/

    @Bean
    public EncryptablePropertyPlaceholderConfigurer propertyConfigurer(StringEncryptor pbeStringEncryptor) {
        EncryptablePropertyPlaceholderConfigurer placeholderConfigurer = new EncryptablePropertyPlaceholderConfigurer(pbeStringEncryptor);
        DefaultResourceLoader defaultResourceLoader = new DefaultResourceLoader();
        placeholderConfigurer.setLocations(defaultResourceLoader.getResource("classpath:gjj.properties"));
        return placeholderConfigurer;
    }

    @Bean
    public StringEncryptor stringEncryptor() {
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        // 加密盐值
        config.setPassword("gjjcdgs856177110");
        // 加密算法
        config.setAlgorithm(StandardPBEByteEncryptor.DEFAULT_ALGORITHM);
        // key迭代次数
        config.setKeyObtentionIterations("1000");
        // 池大小
        config.setPoolSize("1");
        config.setProviderName("SunJCE");
        // 随机盐生成器
        config.setSaltGeneratorClassName("org.jasypt.salt.RandomSaltGenerator");
        config.setIvGeneratorClassName("org.jasypt.iv.RandomIvGenerator");
        // 加密后输出字符串编码方式
        config.setStringOutputType("base64");
        encryptor.setConfig(config);
        return encryptor;
    }



}
