package com.changda.gjjapp.zhfwpt.tyfb.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.springframework.ui.Model;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.apache.cxf.common.util.PropertiesLoaderUtils;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.db.entity.M_LANMU;
import com.changda.gjjapp.db.entity.M_TSXQ;
import com.changda.gjjapp.db.entity.M_XWINFO;
import com.changda.gjjapp.zhfwpt.dto.tyfb.Image;
import com.changda.gjjapp.zhfwpt.dto.tyfb.TyfbLoggingDto;
import com.changda.gjjapp.zhfwpt.dto.tyfb.UpdateNumDto;
import com.changda.gjjapp.zhfwpt.dto.tyfb.UpdateStatisticsDto;
import com.changda.gjjapp.zhfwpt.qdxxgl.controller.QuDaoXinXiGuanLiController;
import com.changda.gjjapp.zhfwpt.service.tyfb.TyfbxwInfoService;

import net.sf.json.JSONObject;

/**
 * 统一发布新闻信息
 * 
 * @author Administrator
 *
 */
@Controller("tyfb")
@RequestMapping("/zhfwpt/tyfb")
public class TYFBXWInfoController {
	public static final String FILE_PATH = "upload.properties";

	@Autowired
	private TyfbxwInfoService tyfbxwInfoService;

	@RequestMapping("lanmuInfo")
	@ResponseBody
	public void lanmuInfo(HttpServletRequest request) {
		this.tyfbxwInfoService.lanmuInfo();
	}

	@RequestMapping("getWZID")
	@ResponseBody
	public void getWZID(HttpServletRequest request) {
		this.tyfbxwInfoService.getWZID();
	}

	@RequestMapping("wsGetMultiInfos")
	@ResponseBody
	public void wsGetMultiInfos(HttpServletRequest request) {
		this.tyfbxwInfoService.wsGetMultiInfos();
	}

	@RequestMapping("lanmuJG")
	@ResponseBody
	public ResultDto lanmuJG(HttpServletRequest request) {
		List<M_LANMU> list = this.tyfbxwInfoService.lanmuJG();
		ResultDto resultDto = new ResultDto();
		resultDto.setData(list);
		resultDto.setSuccess(Boolean.valueOf(true));
		return resultDto;
	}

	// 栏目树菜单
	@RequestMapping("lanmuXiaLa")
	@ResponseBody
	public ResultDto lanmuXiaLa(HttpServletRequest request) {
		String lanmuid = request.getParameter("lanmuid");
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(lanmuid);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<M_LANMU> list = this.tyfbxwInfoService.lanmuXiaLa(lanmuid);
			resultDto.setData(list);
			resultDto.setSuccess(Boolean.valueOf(true));
		}
		return resultDto;
	}

	@RequestMapping("getLanMuInfo")
	@ResponseBody
	public void getLanMuInfo(HttpServletRequest request) {
		this.tyfbxwInfoService.insertInfo();

	}

	// 上传文件生成url

	// 查询文章内容
	@RequestMapping("query")
	@ResponseBody
	public ResultDto query(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String qssj = request.getParameter("qssj");
		String zzsj = request.getParameter("zzsj");
		String title = request.getParameter("title");
		String lanmuid = request.getParameter("lanmuid");
		String issh = request.getParameter("issh");
		int page = Integer.parseInt(request.getParameter("page"));
		int limit = Integer.parseInt(request.getParameter("limit"));
		String z=qssj+zzsj+title+lanmuid+issh;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			Map<String, Object> map = tyfbxwInfoService.query(lanmuid, title, issh, qssj, zzsj, page, limit);
			List<M_XWINFO> data = (List<M_XWINFO>) map.get("data");
			int total = (int) map.get("total");
			resultDto.setData(data);
			resultDto.setTotal(total);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 查询文章内容
	@RequestMapping("searchWZ")
	@ResponseBody
	public ResultDto searchWZ(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String i_id = request.getParameter("i_id");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(i_id);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<M_XWINFO> data = tyfbxwInfoService.searchWZ(i_id);
			resultDto.setData(data);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 插入文章内容
	@RequestMapping("insertWZ")
	@ResponseBody
	public ResultDto insertWZ(HttpServletRequest request) throws Exception {
		ResultDto resultDto = new ResultDto();
		String data = request.getParameter("data");
//		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(data);
//		if(a){
//			resultDto.setData(0);
//			resultDto.setMessage("存在sql注入");
//			resultDto.setSuccess(false);
//		}else{
			resultDto = tyfbxwInfoService.insertWZ(data);
//		}
		return resultDto;
	}

	// 获取栏目结构
	@RequestMapping("XMLStructure")
	@ResponseBody
	public ResultDto XMLStructure(HttpServletRequest request) {
		tyfbxwInfoService.XMLStructure("");
		ResultDto resultDto = new ResultDto();
		resultDto.setData(true);
		resultDto.setSuccess(true);
		return resultDto;
	}

	// 获取栏目更新状态
	@RequestMapping("getLanMuState")
	@ResponseBody
	public ResultDto getLanMuState(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		String lanmuid = request.getParameter("lanmuid");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(lanmuid);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			String lanMuState = tyfbxwInfoService.getLanMuState(lanmuid);
			resultDto.setData(lanMuState);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 删除文章
	@RequestMapping("deleteWz")
	@ResponseBody
	public ResultDto deleteWz(HttpServletRequest request) {
		String i_id = request.getParameter("i_id");
		String i_cataid = request.getParameter("i_cataid");
		ResultDto resultDto = new ResultDto();
		String z=i_id+i_cataid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			resultDto = tyfbxwInfoService.deleteWz(i_id, i_cataid);
		}
		return resultDto;
	}

	// 修改文章
	@RequestMapping("updateWZ")
	@ResponseBody
	public ResultDto updateWZ(HttpServletRequest request) throws Exception {
		ResultDto resultDto = new ResultDto();
		String data = request.getParameter("data");
//		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(data);
//		if(a){
//			resultDto.setData(0);
//			resultDto.setMessage("存在sql注入");
//			resultDto.setSuccess(false);
//		}else{
			resultDto = tyfbxwInfoService.updateWZ(data);
//		}
		return resultDto;
	}

	// 审核文章
	@RequestMapping("reviewArticle")
	@ResponseBody
	public ResultDto reviewArticle(HttpServletRequest request) throws Exception {
		ResultDto resultDto = new ResultDto();
		String i_id = request.getParameter("i_id");
		String isyyfs = request.getParameter("isyyfs");
		String z=i_id+isyyfs;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			resultDto = tyfbxwInfoService.reviewArticle(i_id, isyyfs);	
		}
		return resultDto;
	}

	// 更新栏目文章
	@RequestMapping("updateWZContent")
	@ResponseBody
	public ResultDto updateWZContent(HttpServletRequest request) throws Exception {
		String i_cataid = request.getParameter("i_cataid");
		ResultDto resultDto=new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(i_cataid);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			if("".equals(i_cataid)){
				 resultDto.setSuccess(false);
			}else{
				resultDto = tyfbxwInfoService.updateWZContent(i_cataid);
			}
		}
		return resultDto;
	}

	// 查询各渠道栏目内容的更新
	@RequestMapping("sreachUpdateContentNum")
	@ResponseBody
	public ResultDto sreachUpdateContentNum(HttpServletRequest request) {
		String year = request.getParameter("year");
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(year);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<UpdateNumDto> list = tyfbxwInfoService.sreachUpdateContentNum(year);
			resultDto.setSuccess(true);
			resultDto.setData(list);
		}
		return resultDto;
	}

	// 查询各渠道栏目内容的更新
	@RequestMapping("updateStatistics")
	@ResponseBody
	public ResultDto updateStatistics(HttpServletRequest request) {
		String time = request.getParameter("time");
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(time);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			List<UpdateStatisticsDto> list = tyfbxwInfoService.updateStatistics(time);
			resultDto.setSuccess(true);
			resultDto.setData(list);
		}
		return resultDto;
	}

	// 预约发送文章
	@RequestMapping("yyfs")
	public void sendArticle() throws Exception {
		tyfbxwInfoService.sendArticle();
	}

	// 统一发布日志记录
	@RequestMapping("logging_tyfb")
	@ResponseBody
	public ResultDto logging_tyfb(HttpServletRequest request) {
		// 栏目id
		String lanmuid = request.getParameter("lanmuid");
		// 是否发送微信
		String iswx = request.getParameter("iswx");
		// 是否发送网站
		String iswz = request.getParameter("iswz");
		// 是否发送app
		String isapp = request.getParameter("isapp");
		// 是否发送智能终端
		String isznzd = request.getParameter("isznzd");
		// 新闻来源
		String xwly = request.getParameter("xwly");
		// 作者
		String zz = request.getParameter("zz");
		// 新闻时间
		String xwsj = request.getParameter("xwsj");
		// 操作人
		String czr = request.getParameter("czr");
		// 操作状态
		String czzt = request.getParameter("czzt");
		ResultDto resultDto = new ResultDto();
		String z=lanmuid+iswx+iswz+isapp+isznzd+xwly+zz+xwsj+czr+czzt;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			resultDto = tyfbxwInfoService.logging_tyfb(lanmuid, iswx, iswz, isapp, isznzd, xwly, zz, xwsj, czr,
					czzt);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 统一发布日志查询
	@RequestMapping("logging_tyfb_select")
	@ResponseBody
	public ResultDto logging_tyfb_select(HttpServletRequest request) {
		Integer page = Integer.parseInt(request.getParameter("page"));
		Integer limit = Integer.parseInt(request.getParameter("limit"));
		Map<String, Object> map = tyfbxwInfoService.logging_tyfb_select(page, limit);
		List<TyfbLoggingDto> list = (List<TyfbLoggingDto>) map.get("list");
		int total = (int) map.get("total");
		ResultDto resultDto = new ResultDto();
		resultDto.setData(list);
		resultDto.setTotal(total);
		resultDto.setSuccess(true);
		return resultDto;
	}

}
