package com.changda.gjjapp.zhfwpt.zxhf.controller;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.db.entity.M_ANSWER;
import com.changda.gjjapp.db.entity.M_ZXLX;
import com.changda.gjjapp.zhfwpt.dto.zxhf.ZskLoggingDto;
import com.changda.gjjapp.zhfwpt.qdxxgl.controller.QuDaoXinXiGuanLiController;
import com.changda.gjjapp.zhfwpt.service.zxhf.ZxhfService;

@Controller
@RequestMapping(value = "/zhfwpt/zxhf")
public class ZxhfController {

	@Autowired
	private ZxhfService zxhfService;

	// 查询文章内容
	@RequestMapping("query")
	@ResponseBody
	public ResultDto query(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 上级id
		String lanmuid = request.getParameter("lanmuid");
		// 标题
		String title = request.getParameter("title");
		int page = Integer.parseInt(request.getParameter("page"));
		int limit = Integer.parseInt(request.getParameter("limit"));
		String z=lanmuid+title;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			Map<String, Object> map = zxhfService.query(title, lanmuid, page, limit);
			List<M_ANSWER> data = (List<M_ANSWER>) map.get("data");
			int total = (int) map.get("total");
			resultDto.setData(data);
			resultDto.setTotal(total);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 知识库统计分析投诉、建议、咨询页面展示
	@RequestMapping("query_ZhiShiKuTjPage")
	@ResponseBody
	public ResultDto query_ZhiShiKuTjPage(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 年
		String year = request.getParameter("year");
		// 月
		String month = request.getParameter("month");
		String z=year+month;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			Map<String, Object> map = zxhfService.query_ZhiShiKuTjPage(year, month);
			resultDto.setData(map);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 查询文章内容
	@RequestMapping("zhishikuList")
	@ResponseBody
	public ResultDto zhishikuList(HttpServletRequest request) {
		// 栏目id
		String lanmuid = request.getParameter("lanmuid");
		// 标题
		String title = request.getParameter("title");
		ResultDto resultDto = new ResultDto();
		int page = Integer.parseInt(request.getParameter("page"));
		int limit = Integer.parseInt(request.getParameter("limit"));
		String z=lanmuid+title;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			Map<String, Object> map = zxhfService.zhishikuList(title, lanmuid, limit, page);
			List<M_ANSWER> data = (List<M_ANSWER>) map.get("data");
			int total = (int) map.get("total");
			resultDto.setData(data);
			resultDto.setTotal(total);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}

	// 知识库答案信息
	@RequestMapping("answerInfo")
	@ResponseBody
	public ResultDto answerInfo(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 主键id
		String primaryid = request.getParameter("primaryid");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(primaryid);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			M_ANSWER dto = zxhfService.answerInfo(primaryid);
			resultDto.setData(dto);
			resultDto.setSuccess(true);	
		}
		return resultDto;
	}

	// 新增知识库信息
	@RequestMapping("addZhiShiKuInfo")
	@ResponseBody
	public ResultDto addZhiShiKuInfo(HttpServletRequest request) {
		// 栏目id
		String lanmuid = request.getParameter("lanmuid");
		// 操作人
		String czr = request.getParameter("czr");
		// 答案
		String answer = request.getParameter("answer");
		// 标题
		String title = request.getParameter("title");
		ResultDto resultDto = new ResultDto();
		String z=lanmuid+czr+answer+title;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			int num = zxhfService.addZhiShiKuInfo(title, lanmuid, answer, czr);
			if (num > 0) {
				resultDto.setSuccess(true);
			} else {
				resultDto.setSuccess(false);
			}	
		}
		return resultDto;
	}

	// 修改知识库信息
	@RequestMapping("updateZhiShiKuInfo")
	@ResponseBody
	public ResultDto updateZhiShiKuInfo(HttpServletRequest request) {
		// 栏目id
		String lanmuid = request.getParameter("lanmuid");
		// 操作人
		String czr = request.getParameter("czr");
		// 答案
		String answer = request.getParameter("answer");
		// 标题
		String title = request.getParameter("title");
		// 主键ID
		String primaryid = request.getParameter("primaryid");
		ResultDto resultDto = new ResultDto();
		String z=lanmuid+czr+answer+title+primaryid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			int num = zxhfService.updateZhiShiKuInfo(title, lanmuid, answer, czr, primaryid);
			if (num > 0) {
				resultDto.setSuccess(true);
			} else {
				resultDto.setSuccess(false);
			}
		}
		
		return resultDto;
	}

	// 删除知识库信息
	@RequestMapping("deleteZhiShiKuInfo")
	@ResponseBody
	public ResultDto deleteZhiShiKuInfo(HttpServletRequest request) {
		// 主键ID
		String primaryid = request.getParameter("primaryid");
		ResultDto resultDto = new ResultDto();
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(primaryid);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			int num = zxhfService.deleteZhiShiKuInfo(primaryid);
			if (num > 0) {
				resultDto.setSuccess(true);
			} else {
				resultDto.setSuccess(false);
			}
		}
		return resultDto;
	}

	// 操作知识库日志记录
	@RequestMapping("zsk_Logging")
	@ResponseBody
	public ResultDto zsk_Logging(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		// 标题
		String title = request.getParameter("title");
		// 操作人
		String czr = request.getParameter("czr");
		// 操作状态
		String czzt = request.getParameter("czzt");
		// 栏目id
		String lanmuid = request.getParameter("lanmuid");
		String z=title+czr+czzt+lanmuid;
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(z);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			resultDto = zxhfService.zsk_Logging(title, czr, czzt,lanmuid);
		}
		return resultDto;
	}

	//操作知识库日志记录查询
	@RequestMapping("zsk_Logging_select")
	@ResponseBody
	public ResultDto zsk_Logging_select(HttpServletRequest request) {
		ResultDto resultDto = new ResultDto();
		int page = Integer.parseInt(request.getParameter("page"));
		int limit = Integer.parseInt(request.getParameter("limit"));
		// 栏目id
		String lanmuid = request.getParameter("lanmuid");
		boolean a=QuDaoXinXiGuanLiController.SqlFilter2(lanmuid);
		if(a){
			resultDto.setData(0);
			resultDto.setMessage("存在sql注入");
			resultDto.setSuccess(false);
		}else{
			Map<String, Object> map = zxhfService.zsk_Logging_select(page, limit,lanmuid);
			List<ZskLoggingDto> data = (List<ZskLoggingDto>) map.get("data");
			int total = (int) map.get("total");
			resultDto.setData(data);
			resultDto.setTotal(total);
			resultDto.setSuccess(true);
		}
		return resultDto;
	}
}
