package com.changda.gjjapp.zhfwpt.dao.qdywqxgl;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.changda.cd4j.foundation.core.persistence.annotation.MyBatisDao;
import com.changda.gjjapp.db.entity.M_XEKZB;
import com.changda.gjjapp.db.entity.M_YWZTKZ_2;
import com.changda.gjjapp.zhfwpt.dto.qdywqxgl.DuanXinQuanXianGuanLiDto;
import com.changda.gjjapp.zhfwpt.dto.qdywqxgl.FwkzLogginInfoDto;
import com.changda.gjjapp.zhfwpt.dto.qdywqxgl.Page2;
import com.changda.gjjapp.zhfwpt.dto.qdywqxgl.QdzkLoggingInfoDto;

/**
 * 渠道权限管理
 *
 * @author Administrator
 */
@MyBatisDao
public interface QuDaoQuanXianGuanLiDao {
    /**
     * 查询渠道状态表用于管理渠道权限
     *
     * @return
     */
    List<Map<String, Object>> quDaoZhuangTaiSearch(@Param("primaryid") String primaryid);

    /**
     * 查询App渠道状态
     *
     * @return
     */
    Map<String, Object> quDaoZhuangTai(@Param("qdid") String qdid);

    /**
     * 更新当前时间和上一分钟的人数
     */
    void updateRs();

    /**
     * 修改渠道状态
     *
     * @param qdid   渠道id
     * @param status 渠道状态 1.启动2.停止
     */
    void updateQuDaoStatus(@Param("qdid") String qdid, @Param("status") int status);

    /**
     * 查询渠道访问在线人数用于阀值控制
     *
     * @param LastMinute 前一分钟的时间
     * @param qdid       渠道id
     */
    int quDaoFangWenCount(@Param("qdid") String qdid);

    /**
     * @param qdid
     * @param status
     */
    void updateQuDaoSSStatus(@Param("qdid") String qdid, @Param("status") int status, @Param("tzsj") String tzsj);

    /**
     * 更新M_QDZTKZ（渠道权限控制表）中前五分钟的在线人数
     */
    void updateOnlineUsers(@Param("qdid") String qdid, @Param("mfzrs") int mfzrs);

    /**
     * 修改渠道权限控制的开始时间和结束时间和阀值
     *
     * @param kssj 开始时间
     * @param jssj 结束时间
     * @param fz   阀值
     * @param qdid 渠道id
     */
    int updateTimeAndFz(@Param("kssj") String kssj, @Param("fz") int fz, @Param("jssj") String jssj, @Param("ksrq") String ksrq, @Param("tzrq") String tzrq, @Param("qdid") String qdid, @Param("qdzt") int qdzt);


    /**
     * 短信权限显示
     */
    List<Map<String, Object>> duanXinZTSreach();

    /**
     * 修改短信状态
     *
     * @param zjzxdm 资金中心代码
     * @param dxzt   短信状态
     */
    void updateDuanXinZT(@Param("zjzxdm") String zjzxdm, @Param("dxzt") String dxzt);
    
    /**
     * 渠道控制接口
     * @param qdid
     * @return
     */
    List<Map<String, Object>> qdkzInfo(@Param("qdid")String qdid);
    
    /**
     * 在线人数计算
     * @param qdid
     * @return
     */
    List<Map<String, Object>> onlineUsers(@Param("qdid")String qdid);
    
    /**
     * 更新在线状态
     * @param id
     * @return
     */
    int updateOnlineUsers2(@Param("qdid")String qdid,@Param("djsj")String djsj);
    
    /**
     * 更新渠道状态
     * @param qdid
     * @return
     */
    int updateQDZT(@Param("qdid")String qdid,@Param("qdzt")String qdzt,@Param("fz")String fz,@Param("djsj")String djsj);
    
    
    /**
     * 业务控制2
     * @return
     */
    List<M_YWZTKZ_2> sreachM_YWZTKZ_2(@Param("ywczlx_2")String ywczlx_2,@Param("ywmc")String ywmc,@Param("issh")String issh,@Param("ywbm")String ywbm);
    
    /**
     * 修改业务状态
     * @param primaryid 主键
     * @param issh 是否审核
     * @param ywzt 业务状态
     * @param tzjssj 停止结束时间
     * @param tzkssj 停止开始时间
     * @return
     */
    int updateM_YWZTKZ_2State(@Param("primaryid")String primaryid,@Param("wtzt")String wtzt,@Param("wxzt") String wxzt,@Param("appzt") String appzt,@Param("znzdzt") String znzdzt,@Param("qyjssj")String qyjssj,@Param("qykssj")String qykssj,@Param("qyksrq")String qyksrq,@Param("qyjsrq")String qyjsrq,@Param("czlx")String czlx);
    
    /**
     * 渠道状态修改
     * @param qdzt 渠道状态
     * @param fz 阈值
     * @param djsj 待机时间
     * @param primaryid 主键ID
     * @return
     */
    int updateQD_state(@Param("qdzt")String qdzt,@Param("fz")String fz,@Param("djsj")String djsj,@Param("primaryid")String primaryid);
    
    /**
     * 渠道总控修改日志记录
     * @return
     */
    List<QdzkLoggingInfoDto> qdzkLoggingInfo(@Param("czsj")String czsj,@Param("qdid")String qdid);
    
    /**
     * 渠道总控修改日志记录
     * @param qdzt 渠道状态
     * @param fz 阀值
     * @param djsj 待机时间
     * @param qdmc 渠道名称
     * @param czr 操作人
     * @param czzt 操作状态
     * @return
     */
    int qdzkLogging(@Param("qdzt")String qdzt,@Param("fz")String fz,@Param("djsj")String djsj,@Param("qdid")String qdid,@Param("czr")String czr,@Param("czzt")String czzt);
    
    /**
     * 修改业务状态
     * @param issh 是否审核1.审核0.未审核
     * @param primaryid 主键id
     * @return
     */
    int updateYWZT2(@Param("issh")String issh,@Param("primaryid")String primaryid,@Param("czlx")String czlx);
    
    /**
     * 修改审核后业务状态
     * @param mYwztkz_2
     * @return
     */
    int updateSHState(@Param("primaryid")String primaryid,@Param("czlx")String czlx);
    
    /**
     * 渠道业务控制 shywzt是否开启1.开启0.未开启
     * @return
     */
    M_YWZTKZ_2 qdztkzInterface(@Param("ywbm")String ywbm);
    
    /**
     * 渠道业务控制 是否在审核过的时间范围内
     * @return
     */
    int qdztkzInterface2(@Param("ywbm")String ywbm,@Param("day")String day,@Param("sj")String sj);
    
    /**
     * 短信控制信息
     * @return
     */
    List<DuanXinQuanXianGuanLiDto> dxkzInfo();
    
    /**
     * 短信控制信息查询临时表
     * @return
     */
    List<DuanXinQuanXianGuanLiDto> tMP_SMS_DIS(@Param("sizeCountStart")String sizeCountStart,@Param("sizeCountEnd")String sizeCountEnd);
    
    /**
     * 短信控制信息查询临时表2
     * @return
     */
    List<Page2> tMP_SMS_DIS2();
    
    /**
     * 限额控制信息
     * @return
     */
    List<M_XEKZB> xekzInfo();
    
    /**
     * 修改限额值
     * @param id
     * @return
     */
    int xeUpdate(@Param("id")String id,@Param("value")String value);
    
    /**
     * 服务控制日志记录
     * @param ywlb 业务类别
     * @param ywmc 业务名称
     * @param qdqyzt 渠道启用状态
     * @param qysjd 启用时间段
     * @param czr 操作人
     * @param czzt 操作状态（操作状态0.保存1.修改2.删除3.审核）
     * @return
     */
    int fwkzLogging(@Param("ywlb")String ywlb,@Param("ywbm")String ywbm,@Param("qysjd")String qysjd,@Param("czr")String czr,@Param("czzt")String czzt,@Param("wxzt")String wxzt,@Param("appzt")String appzt,@Param("znzdzt")String znzdzt,@Param("wtzt")String wtzt);
    
    /**
     * 服务控制日志
     * @param czsj
     * @return
     */
    List<FwkzLogginInfoDto> fwkzLoggingInfo(@Param("ywbm")String ywbm);
}
