package com.changda.gjjapp.zhfwpt.dao.wjdc;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;
import com.changda.cd4j.foundation.core.persistence.annotation.MyBatisDao;
import com.changda.gjjapp.db.entity.M_TSXQ;
import com.changda.gjjapp.zhfwpt.dto.wjdc.HdjlLoggingDto;
import com.changda.gjjapp.zhfwpt.dto.wjdc.M_ZHISHIKUMULU;
import com.changda.gjjapp.zhfwpt.dto.wjdc.TslxAdvisorySortDto;

@MyBatisDao
public interface WJDCDao {
    /**
     * 查询问卷信息
     *
     * @param wjmc 问卷名称
     */
    List<Map<String, Object>> sreachWJXX(@Param("wjmc") String wjmc);

    /**
     * 删除问卷、问题、答案
     *
     * @param wjid
     * @return
     */
    int deleteDA(@Param("wjid") String wjid);

    int deleteWT(@Param("wjid") String wjid);

    int deleteWJ(@Param("wjid") String wjid);

    /**
     * 删除问题、答案
     */
    int deleteWenTi(@Param("wjdcwtid") String wjdcwtid);

    int deleteDAAN(@Param("wjdcwtid") String wjdcwtid);

    /**
     * 修改问卷信息
     *
     * @param wjmc     问卷名称
     * @param sfqy     是否启用1.启用0.不启用
     * @param wjzqkssj 问卷周期开始时间
     * @param wjzqjssj 问卷周期结束时间
     * @param wjid     问卷id
     */
    int updateWJ(@Param("wjmc") String wjmc, @Param("sfqy") String sfqy, @Param("wjzqkssj") String wjzqkssj, @Param("wjzqjssj") String wjzqjssj, @Param("wjid") String wjid);


    /**
     * 添加问卷信息
     *
     * @param wjmc     问卷名称
     * @param sfqy     是否启用1.启用0.不启用
     * @param wjzqkssj 问卷周期开始时间
     * @param wjzqjssj 问卷周期结束时间
     */
    int addWJ(@Param("wjmc") String wjmc, @Param("sfqy") String sfqy, @Param("wjzqkssj") String wjzqkssj, @Param("wjzqjssj") String wjzqjssj);


    /**
     * 问卷问题信息查询
     *
     * @param wjid 问卷id
     * @param wtmc 问题名称
     * @return
     */
    List<Map<String, Object>> WJWTInfo(@Param("wjid") String wjid, @Param("wtmc") String wtmc);

    /**
     * 问卷调查问题信息编辑
     *
     * @param wjid     问卷id
     * @param wjdcwtid 问卷调查问题id
     * @return
     */
    List<Map<String, Object>> wjdcWTINFO(@Param("wjid") String wjid, @Param("wjdcwtid") String wjdcwtid);

    /**
     * 显示问题
     *
     * @param wtid 问题id
     * @return
     */
    List<Map<String, Object>> daAnInfo(@Param("wtid") String wtid);

    /**
     * 新增问题
     *
     * @param wjdcwtid 问卷调查问题id
     * @param wjid     问卷id
     * @param wtmc     问题名称
     * @param sfdx     是否多选1.是0.否
     * @return
     */
    int addWT(@Param("wjdcwtid") String wjdcwtid, @Param("wjid") String wjid, @Param("wtmc") String wtmc, @Param("sfdx") String sfdx);

    /**
     * 新增答案
     *
     * @param wjdcwtid 问卷调查问题id
     * @param daanmc   答案名称
     * @param wjid     问卷id
     * @return
     */
    int addDaAn(@Param("wjdcwtid") String wjdcwtid, @Param("daanmc") String daanmc, @Param("wjid") String wjid);

    /**
     * 修改问题
     *
     * @param wjdcwtid 问题id
     * @param wtmc     问题名称
     * @param sfdx     是否多选
     * @return
     */
    int updateWT(@Param("wjdcwtid") String wjdcwtid, @Param("wtmc") String wtmc, @Param("sfdx") String sfdx);


    /**
     * 修改答案
     *
     * @param wjdczbid 问题id
     * @param daan     答案名称
     * @return
     */
    int updateDaAn(@Param("wjdczbid") String wjdczbid, @Param("daan") String daan);

    /**
     * 删除答案
     *
     * @param wjdczbid 问卷调查答案id
     * @return
     */
    int deleteDaAn(@Param("wjdczbid") String wjdczbid);

    /**
     * 网上调查 插入反馈表
     *
     * @param wjid     问卷id
     * @param wtid     问题id
     * @param daanid   答案id
     * @param tpxx     投票选项
     * @param tpsj     投票时间
     * @param username 用户名称
     * @param grzh     个人账号
     * @return
     */
    int insertFK(@Param("wjid") String wjid, @Param("wtid") String wtid, @Param("daanid") String daanid, @Param("username") String username, @Param("grzh") String grzh, @Param("qdid") String qdid,@Param("tpxx")String tpxx);

    /**
     * 查询问卷
     *
     * @return
     */
    List<Map<String, Object>> sreachWj();

    /**
     * 查询问题
     *
     * @param wjid 问卷id
     * @return
     */
    List<Map<String, Object>> sreachWt(@Param("wjid") String wjid);

    /**
     * 查询答案
     *
     * @param wjdcwtid 问题id
     * @return
     */
    List<Map<String, Object>> sreachDaAn(@Param("wjdcwtid") String wjdcwtid);

    /**
     * 查询投诉类型
     * @param zlx 主类型
     * @return
     */
    List<Map<String, Object>> sreachTSType(@Param("zlx")String zlx);


    /**
     * 插入投诉建议
     *
     * @param tslxid 投诉类型id
     * @param bt     标题
     * @param tsnr   投诉内容
     * @param yhxm   用户姓名
     * @param yhdh   用户电话
     * @return
     */
    int insertTS(@Param("tslxid") String tslxid, @Param("bt") String bt, @Param("tsnr") String tsnr, @Param("yhxm") String yhxm, @Param("yhdh") String yhdh, @Param("grzh") String grzh, @Param("qdid") String qdid);

    /**
     * 查询投诉详情
     *
     * @return
     */
    List<M_TSXQ> sreachTSINFO(@Param("tsid") String tsid,@Param("bt") String bt,@Param("qssj") String qssj,@Param("zzsj") String zzsj,@Param("grzh")String grzh,@Param("zlx")String zlx,@Param("tslxid")String tslxid,@Param("issh")String issh,@Param("sfcl")String sfcl,@Param("sfyc")String sfyc,@Param("jsbh")String jsbh);

    /**
     * 查询角色是否能回复
     *
     * @return
     */
    M_TSXQ sreachISHF(@Param("tsid") String tsid);

    
    /**
     * 提交回复内容
     *
     * @param hfnr 回复内容
     * @param tsid 投诉id
     * @return
     */
    int addHFInfo(@Param("hfnr") String hfnr, @Param("tsid") String tsid, @Param("hfsj") String hfsj);

    /**
     * 是否隐藏回复
     *
     * @param tsid 投诉id
     * @param sfyc 是否隐藏
     * @return
     */
    int hfSFYC(@Param("tsid") String tsid, @Param("sfyc") String sfyc);

    /**
     * 问卷调查答案统计
     *
     * @param wjid 问卷id
     * @return
     */
    List<Map<String, Object>> wjdcdaanTJ(@Param("wjid") String wjid);
    
    
    /**
     * 咨询投诉热点排序
     */
    List<Map<String, Object>> zxrdytspx(@Param("qssj")String qssj,@Param("zzsj")String zzsj,@Param("ywlx")String lx);
    
    /**
     * 修改恢复内容
     * @param tsid 投诉id
     * @param hfnr 恢复内容
     * @return
     */
    int updateHFNR(@Param("tsid")String tsid,@Param("hfnr")String hfnr,@Param("hfsj")String hfsj);
    
    /**
     * 投诉详情查询微信前端接口 不含内容回复
     * @param map
     * @return
     */
    List<M_TSXQ> query(@Param("zlx")String zlx,@Param("grzh")String grzh,@Param("sizeCountStart")String sizeCountStart,@Param("sizeCountEnd")String sizeCountEnd);
    
    /**
     * 查询某一类型的十二个月的投诉数量
     * @param zlx 投诉类型
     * @param year 年份
     * @return
     */
    List<TslxAdvisorySortDto> tslxAdvisorySort(@Param("zlx")String zlx,@Param("year")String year);
    
    /**
     * 查询投诉详情
     * @param tsid
     * @return
     */
    List<M_TSXQ> tsxqSreach(@Param("tsid")String tsid);
    
    /**
     * 插入知识库调用记录
     * @param primaryid 主键id
     * @param problemid 问题id
     * @param answerid  答案id
     * @param transfertime 调用时间
     * @return
     */
    int insertZhiShiKuJiLu(@Param("problemid")String problemid,@Param("answerid")String answerid);
    
    /**
     * 修改投诉回复内容审核状态
     * @param tsid
     * @return
     */
    int updateTSHFSHState(@Param("tsid")String tsid,@Param("issh")int issh);
    
    /**
     * 插入投诉、建议、咨询办理信息
     * @param qdid
     * @param ywlx
     * @param ywzt
     * @param sqr
     * @param grzh
     * (#{qdid},#{ywlx},#{ywzt},sysdate,#{grzh},#{sqr})
     * @return
     */
    int insertTSJYZX(@Param("qdid")String qdid,@Param("ywlx")String ywlx,@Param("ywzt")String ywzt,@Param("grzh")String grzh,@Param("sqr")String sqr);
    
    /**
     * 知识库父级目录
     * @return
     */
    List<M_ZHISHIKUMULU> treemenuML();
    
    /**
     * 父级目录
     * @return
     */
    List<M_ZHISHIKUMULU> fjml();
    
    /**
     * 子级目录
     * @param lanmuid
     * @return
     */
    List<M_ZHISHIKUMULU> zjml(@Param("lanmuid")String lanmuid);
    
    /**
     * 查询栏目
     * @param lanmuid
     * @return
     */
    List<M_ZHISHIKUMULU> selectLanMu(@Param("lanmuid")String lanmuid);
    
    /**
     * 投诉、建议、咨询 问题派发，修改角色编码
     * @param jsbh 角色编号
     * @param tsid 投诉ID
     * @return
     */
    int wentiPF(@Param("jsbh")String jsbh,@Param("tsid")String tsid);
    
    /**
     * 派发问题后 是否处理改成未处理 
     * @param iscl
     * @param tsid
     * @return
     */
    int updateCLZT(@Param("iscl")String iscl,@Param("tsid")String tsid);
    
    /**
     * 互动交流日志查询
     * @param lx
     * @return
     */
    List<HdjlLoggingDto> hdjl_logging_select(@Param("lx")String lx);
    
    /**
     * 记录互动交流日志
     * @param title
     * @param lx
     * @param czr
     * @param czzt
     * @param czsj
     * @param sfyc
     * @return
     */
    int hdjl_logging(@Param("title")String title,@Param("lx")String lx,@Param("czr")String czr,@Param("czzt")String czzt);
    
    int selectuserpd(@Param("yhxm")String yhxm);
}

