package com.changda.gjjapp.zhfwpt.service.impl.zxhf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.db.entity.M_ANSWER;
import com.changda.gjjapp.db.entity.M_XWINFO;
import com.changda.gjjapp.db.entity.M_ZXLX;
import com.changda.gjjapp.zhfwpt.dao.zxhf.ZxhfDao;
import com.changda.gjjapp.zhfwpt.dto.zxhf.TouSuJianYiZiXunTypeSortDto;
import com.changda.gjjapp.zhfwpt.dto.zxhf.ZhiShiKuDiaoYongTJTuDto;
import com.changda.gjjapp.zhfwpt.dto.zxhf.ZhiShiKuDiaoYongTongJiFXDto;
import com.changda.gjjapp.zhfwpt.dto.zxhf.ZskLoggingDto;
import com.changda.gjjapp.zhfwpt.service.zxhf.ZxhfService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;


@Service()
public class ZxhfServiceImp implements ZxhfService{
	@Autowired
	private ZxhfDao zxhfDao;

	//咨询内容
	@Override
	public Map<String, Object> query(String title,String lanmuid,int page,int limit) {
		Map<String, Object> map = new HashMap<>();
		Page<M_ANSWER> page2 = PageHelper.startPage(page, limit, true);
		List<M_ANSWER> list = zxhfDao.query_M_ANSWER(lanmuid, title);
		int count = (int) page2.getTotal();
		map.put("total", count);
		map.put("data", list);
		return map;
	}

	//知识库统计分析投诉、建议、咨询页面展示
	@Override
	public Map<String, Object> query_ZhiShiKuTjPage(String year,String month) {
		// 去掉"-"符号
//        String year2 = year.substring(0, 4) ;
//        System.out.println(year2);
		Map<String, Object> map = new HashMap<>();
		List<ZhiShiKuDiaoYongTJTuDto> listTJTu = zxhfDao.query_ZhiShiKuDiaoYongTJTu(year);
		
		List<ZhiShiKuDiaoYongTongJiFXDto> listTjFx = zxhfDao.query_ZhiShiKuDiaoYongTongJiFX(year);
		
		List<TouSuJianYiZiXunTypeSortDto> listTouSuSlrt = zxhfDao.query_TouSuJianYiZiXunTypeSort(year,month);
		
		map.put("listTJTu", listTJTu);
		map.put("listTjFx", listTjFx);
		map.put("listTouSuSlrt", listTouSuSlrt);
		return map;
	}

	//知识库列表
	@Override
	public Map<String, Object> zhishikuList(String title, String lanmuid, int limit, int page) {
		Map<String, Object> map = new HashMap<>();
		Page<M_ANSWER> page2 = PageHelper.startPage(page, limit, true);
		List<M_ANSWER> list = zxhfDao.zhishikuList(title, lanmuid);
		int count = (int) page2.getTotal();
		map.put("total", count);
		map.put("data", list);
		return map;
	}

	//知识库答案信息
	@Override
	public M_ANSWER answerInfo(String primaryid) {
		// TODO Auto-generated method stub
		return zxhfDao.answerInfo(primaryid);
	}

	//新增知识库信息
	@Override
	public int addZhiShiKuInfo(String title, String lanmuid, String answer, String czr) {
		int num = zxhfDao.addZhiShiKuInfo(title, lanmuid, answer, czr);
		if (num>0) {
			return 1;
		}else {
			return 0;
		}
	}

	//修改知识库信息
	@Override
	public int updateZhiShiKuInfo(String title, String lanmuid, String answer, String czr, String primaryid) {
		int num = zxhfDao.updateZhiShiKuInfo(title, lanmuid, answer, czr, primaryid);
		if (num>0) {
			return 1;
		}else {
			return 0;
		}
	}

	//删除知识库信息
	@Override
	public int deleteZhiShiKuInfo(String primaryid) {
		int num = zxhfDao.deleteZhiShiKuInfo(primaryid);
		if (num>0) {
			return 1;
		}else {
			return 0;
		}
	}

	//操作知识库日志记录
	@Override
	public ResultDto zsk_Logging(String title, String czr, String czzt,String lanmuid) {
		ResultDto resultDto = new ResultDto();
		int num = zxhfDao.zsk_Logging(title, czr, czzt, lanmuid);
		if (num > 0) {
			resultDto.setSuccess(true);
			return resultDto;
		}else{
			resultDto.setSuccess(false);
			return resultDto;
		}
	}

	//操作知识库日志记录查询
	@Override
	public Map<String, Object> zsk_Logging_select(int page, int limit,String lanmuid) {
		Map<String, Object> map = new HashMap<>();
		Page<ZskLoggingDto> page2 = PageHelper.startPage(page, limit, true);
		List<ZskLoggingDto> list = zxhfDao.zsk_Logging_select(lanmuid);
		int count = (int) page2.getTotal();
		map.put("total", count);
		map.put("data", list);
		return map;
	}

	
	
}
